/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.developer.loggers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StackTraceUtility {
    private static final Log log = LogFactory.getLog(StackTraceUtility.class);
    private final Class<?> lowestClassInStackTrace;
    private final List<StackTraceElement> stackTrace;
    private final String methodName;

    public StackTraceUtility(Class<?> lowestClassInStackTrace, boolean enabled) {
        this.lowestClassInStackTrace = lowestClassInStackTrace;
        this.stackTrace = enabled ? this.loadStackTrace() : Collections.emptyList();
        this.methodName = this.stackTrace.isEmpty() ? "UNKNOWN" : this.stackTrace.get(0).getMethodName();
    }

    private List<StackTraceElement> loadStackTrace() {
        Object[] stack = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>(Arrays.asList(stack));
        this.trimStackTraceAtBeginning(list);
        this.trimStackTraceAtEnd(list);
        this.removeJenaClassesFromStackTrace(list);
        log.debug((Object)("Stack array: " + Arrays.toString(stack)));
        log.debug((Object)("Stack trace: " + list));
        return Collections.unmodifiableList(list);
    }

    private void trimStackTraceAtBeginning(List<StackTraceElement> list) {
        StackTraceElement ste;
        ListIterator<StackTraceElement> iter = list.listIterator();
        while (iter.hasNext() && !(ste = iter.next()).getClassName().equals(this.lowestClassInStackTrace.getName())) {
            iter.remove();
        }
    }

    private void trimStackTraceAtEnd(List<StackTraceElement> list) {
        ListIterator<StackTraceElement> iter = list.listIterator();
        boolean trimming = false;
        while (iter.hasNext()) {
            StackTraceElement ste = iter.next();
            if (trimming) {
                iter.remove();
                continue;
            }
            if (!ste.getClassName().contains("ApplicationFilterChain")) continue;
            trimming = true;
        }
    }

    private void removeJenaClassesFromStackTrace(List<StackTraceElement> list) {
        ListIterator<StackTraceElement> iter = list.listIterator();
        while (iter.hasNext()) {
            StackTraceElement ste = iter.next();
            if (!ste.getClassName().startsWith("com.hp.hpl.jena.")) continue;
            iter.remove();
        }
    }

    public boolean passesStackRestriction(String restriction) {
        if (StringUtils.isEmpty((String)restriction)) {
            return true;
        }
        try {
            return this.passesStackRestriction(Pattern.compile(restriction));
        }
        catch (Exception e) {
            log.warn((Object)("Failed when testing stack restriction: '" + restriction + "'"));
            return true;
        }
    }

    public boolean passesStackRestriction(Pattern restriction) {
        if (restriction == null) {
            return true;
        }
        String q = this.assembleCallStackString();
        return restriction.matcher(q).find();
    }

    private String assembleCallStackString() {
        StringBuilder stack = new StringBuilder();
        for (StackTraceElement ste : this.stackTrace) {
            stack.append(ste.getClassName()).append(" ").append(ste.getMethodName()).append(" ");
        }
        return stack.deleteCharAt(stack.length() - 1).toString();
    }

    public String format(boolean requested) {
        StringBuilder sb = new StringBuilder();
        if (requested) {
            for (StackTraceElement ste : this.stackTrace) {
                sb.append(String.format("   %s.%s(%s:%d) \n", ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber()));
            }
            sb.append("   ...\n");
        }
        return sb.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }
}

