/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tags
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(Tags.class);
    protected final LinkedHashSet<String> tags;

    public Tags() {
        this.tags = new LinkedHashSet();
    }

    public Tags(LinkedHashSet<String> tags) {
        this.tags = tags;
    }

    public TemplateModel wrap() {
        try {
            return new TagsWrapper().wrap(this);
        }
        catch (TemplateModelException e) {
            log.error((Object)"Error creating Tags template model");
            return null;
        }
    }

    public void add(String ... tags) {
        for (String tag : tags) {
            this.add(tag);
        }
    }

    public void add(String tag) {
        this.tags.add(tag);
    }

    public String list() {
        return StringUtils.join(this.tags, (String)"\n");
    }

    public static class TagsWrapper
    extends BeansWrapper {
        public TagsWrapper() {
            this.setExposureLevel(1);
        }

        protected void finetuneMethodAppearance(Class cls, Method method, BeansWrapper.MethodAppearanceDecision decision) {
            try {
                String methodName = method.getName();
                if (!methodName.equals("add") && !methodName.equals("list")) {
                    decision.setExposeMethodAs(null);
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

