/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.testing;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.SortedSet;
import java.util.TreeSet;

public class ModelUtilitiesTestHelper {
    public static Model model(Statement ... stmts) {
        return ModelFactory.createDefaultModel().add(stmts);
    }

    public static Statement typeStatement(String subjectUri, String classUri) {
        return ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)subjectUri), (Property)RDF.type, (RDFNode)ResourceFactory.createResource((String)classUri));
    }

    public static Statement objectProperty(String subjectUri, String propertyUri, String objectUri) {
        return ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)subjectUri), (Property)ResourceFactory.createProperty((String)propertyUri), (RDFNode)ResourceFactory.createResource((String)objectUri));
    }

    public static Statement dataProperty(String subjectUri, String propertyUri, String objectValue) {
        return ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)subjectUri), (Property)ResourceFactory.createProperty((String)propertyUri), (RDFNode)ResourceFactory.createPlainLiteral((String)objectValue));
    }

    public static Statement dataProperty(String subjectUri, String propertyUri, Object objectValue, XSDDatatype dataType) {
        return ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)subjectUri), (Property)ResourceFactory.createProperty((String)propertyUri), (RDFNode)ResourceFactory.createTypedLiteral((String)String.valueOf(objectValue), (RDFDatatype)dataType));
    }

    public static Statement dataProperty(String subjectUri, String propertyUri, String objectValue, String language) {
        return ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)subjectUri), (Property)ResourceFactory.createProperty((String)propertyUri), (RDFNode)ResourceFactory.createLangLiteral((String)objectValue, (String)language));
    }

    public static SortedSet<String> modelToStrings(Model m) {
        TreeSet<String> set = new TreeSet<String>();
        for (Statement stmt : m.listStatements().toList()) {
            set.add(stmt.toString());
        }
        return set;
    }
}

