/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class QueryUtilsTest
extends AbstractTestClass {
    private QuerySolutionMap bindings = new QuerySolutionMap();
    private List<Map<String, String>> theList = this.list(this.map(this.pair("id", "1"), this.pair("color", "blue"), this.pair("size", "large")), this.map(this.pair("id", "2"), this.pair("color", "red"), this.pair("size", "large"), this.pair("parity", "odd")));
    private List<Map<String, String>> filteredList;

    @Test
    public void bindResource() {
        this.bindings.add("uri", (RDFNode)ResourceFactory.createResource((String)"http://my.uri"));
        this.assertBoundQueryEquals("a resource ?uri", "a resource <http://my.uri>");
    }

    @Test
    public void bindPlainLiteral() {
        this.bindings.add("plain", (RDFNode)ResourceFactory.createPlainLiteral((String)"too easy"));
        this.assertBoundQueryEquals("This is ?plain ?plain", "This is \"too easy\" \"too easy\"");
    }

    @Test
    public void bindTypedLiteral() {
        this.bindings.add("typed", (RDFNode)ResourceFactory.createTypedLiteral((Object)100L));
        this.assertBoundQueryEquals("take this ?typed number", "take this \"100\"^^<http://www.w3.org/2001/XMLSchema#long> number");
    }

    @Test
    public void bindLanguageLiteral() {
        Literal l = ModelFactory.createDefaultModel().createLiteral("Spanish", "es-ES");
        this.bindings.add("lang", (RDFNode)l);
        this.assertBoundQueryEquals("speak my ?lang?", "speak my \"Spanish\"@es-ES?");
    }

    @Ignore
    @Test
    public void bindAnon() {
        Assert.fail((String)"bindAnon not implemented");
    }

    private void assertBoundQueryEquals(String template, String expected) {
        String actual = QueryUtils.bindVariables((String)template, (QuerySolution)this.bindings);
        Assert.assertEquals((String)"bounding results", (Object)expected, (Object)actual);
    }

    @Test
    public void noKeys() {
        this.assertExpectedIDs(this.ids("1", "2"), this.keys(new String[0]));
    }

    @Test
    public void emptyList() {
        this.theList = new ArrayList<Map<String, String>>();
        this.assertExpectedIDs(this.ids(new String[0]), this.keys("color"));
    }

    @Test
    public void unrecognizedKey() {
        this.assertExpectedIDs(this.ids("1", "2"), this.keys("bogus"));
    }

    @Test
    public void unmatchedKey() {
        this.assertExpectedIDs(this.ids("1", "2"), this.keys("parity"));
    }

    @Test
    public void foundDuplicate() {
        this.assertExpectedIDs(this.ids("1"), this.keys("size"));
    }

    @Test
    public void noDuplicates() {
        this.assertExpectedIDs(this.ids("1", "2"), this.keys("color"));
    }

    @Test
    public void matchOneKeyOfMany() {
        this.assertExpectedIDs(this.ids("1"), this.keys("color", "size"));
    }

    @Test
    public void multipleDuplicatesOfASingleRecord() {
        this.theList.add(this.map(this.pair("id", "3"), this.pair("size", "large")));
        this.assertExpectedIDs(this.ids("1"), this.keys("color", "size"));
    }

    private void assertExpectedIDs(String[] ids, String[] keys) {
        this.filteredList = QueryUtils.removeDuplicatesMapsFromList(this.theList, (String[])keys);
        Assert.assertEquals((String)"ids", Arrays.asList(ids), this.idsInFilteredList());
    }

    private List<String> idsInFilteredList() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Map<String, String> map : this.filteredList) {
            String id = map.get("id");
            if (id == null) {
                Assert.fail((String)"ID was null");
                continue;
            }
            ids.add(id);
        }
        return ids;
    }

    @SafeVarargs
    private final List<Map<String, String>> list(Map<String, String> ... maps) {
        return new ArrayList<Map<String, String>>(Arrays.asList(maps));
    }

    private Map<String, String> map(String[] ... pairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] pair : pairs) {
            map.put(pair[0], pair[1]);
        }
        return map;
    }

    private String[] pair(String ... s) {
        return s;
    }

    private String[] keys(String ... keys) {
        return keys;
    }

    private String[] ids(String ... ids) {
        return ids;
    }
}

