/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class VClassJenaTest {
    private OntModel _constModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
    protected AnnotationProperty LOCAL_SHORTDEF = this._constModel.createAnnotationProperty("http://purl.obolibrary.org/obo/IAO_0000115");
    protected AnnotationProperty LOCAL_DESCRIPTION_ANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#descriptionAnnot");
    protected AnnotationProperty LOCAL_DISPLAY_LIMIT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayLimitAnnot");
    protected AnnotationProperty LOCAL_EXAMPLE_ANNOT = this._constModel.createAnnotationProperty("http://purl.obolibrary.org/obo/IAO_0000112");
    protected AnnotationProperty LOCAL_DISPLAY_RANK_ANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRankAnnot");
    protected AnnotationProperty LOCAL_SEARCH_BOOST_ANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#searchBoostAnnot");
    protected AnnotationProperty LOCAL_PROPERTY_CUSTOMENTRYFORMANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customEntryFormAnnot");
    protected AnnotationProperty LOCAL_PROPERTY_CUSTOMDISPLAYVIEWANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customDisplayViewAnnot");
    protected AnnotationProperty LOCAL_PROPERTY_CUSTOMSHORTVIEWANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customShortViewAnnot");
    protected AnnotationProperty LOCAL_PROPERTY_CUSTOMSEARCHVIEWANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customSearchViewAnnot");
    protected AnnotationProperty LOCAL_HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromDisplayBelowRoleLevelAnnot");
    protected AnnotationProperty LOCAL_PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#prohibitedFromUpdateBelowRoleLevelAnnot");
    protected AnnotationProperty LOCAL_HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromPublishBelowRoleLevelAnnot");
    protected AnnotationProperty LOCAL_IN_CLASSGROUP = this._constModel.createAnnotationProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup");
    private final boolean ALSO_TRY_NO_LANG = true;

    @Test
    public void correctValues() {
        String class1URI = "http://test.vivo/AcademicDegree";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        String rdfsLabel = "this is the rdfs label";
        String lang = "en-US";
        OntClass class1 = ontModel.createClass(class1URI);
        class1.setLabel(rdfsLabel, lang);
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inClassGroup"), (RDFNode)ontModel.createResource("http://thisIsTheClassGroupURI"));
        class1.setPropertyValue(ontModel.createProperty("http://purl.obolibrary.org/obo/IAO_0000115"), (RDFNode)ontModel.createTypedLiteral("this is the short definition"));
        class1.setPropertyValue(ontModel.createProperty("http://purl.obolibrary.org/obo/IAO_0000112"), (RDFNode)ontModel.createTypedLiteral("this is the example"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#descriptionAnnot"), (RDFNode)ontModel.createTypedLiteral("this is the description"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayLimitAnnot"), (RDFNode)ontModel.createTypedLiteral(-1));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRankAnnot"), (RDFNode)ontModel.createTypedLiteral(-11));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#searchBoostAnnot"), (RDFNode)ontModel.createTypedLiteral(2.4f));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromDisplayBelowRoleLevelAnnot"), (RDFNode)ontModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#curator"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#prohibitedFromUpdateBelowRoleLevelAnnot"), (RDFNode)ontModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#selfEditor"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#hiddenFromPublishBelowRoleLevelAnnot"), (RDFNode)ontModel.createResource("http://vitro.mannlib.cornell.edu/ns/vitro/role#editor"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customEntryFormAnnot"), (RDFNode)ontModel.createTypedLiteral("this is the custom entry form annotation"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customDisplayViewAnnot"), (RDFNode)ontModel.createTypedLiteral("this is the custom display view annotation"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customShortViewAnnot"), (RDFNode)ontModel.createTypedLiteral("this is the custom short view annotation"));
        class1.setPropertyValue(ontModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customSearchViewAnnot"), (RDFNode)ontModel.createTypedLiteral("this is the custom search view annotation"));
        WebappDaoFactoryJena wadf = new WebappDaoFactoryJena(ontModel);
        VClass vClass = this.vClassWebappFromOntClass(class1, wadf);
        VClassJena vClassJena = new VClassJena(class1, wadf);
        Assert.assertEquals((Object)vClassJena.getName(), (Object)vClass.getName());
        Assert.assertEquals((Object)vClassJena.getLocalNameWithPrefix(), (Object)vClass.getLocalNameWithPrefix());
        Assert.assertEquals((Object)vClassJena.getPickListName(), (Object)vClass.getPickListName());
        Assert.assertEquals((Object)vClassJena.getExample(), (Object)vClass.getExample());
        Assert.assertEquals((Object)vClassJena.getDescription(), (Object)vClass.getDescription());
        Assert.assertEquals((Object)vClassJena.getShortDef(), (Object)vClass.getShortDef());
        Assert.assertEquals((long)vClassJena.getDisplayRank(), (long)vClass.getDisplayRank());
        Assert.assertEquals((Object)vClassJena.getGroupURI(), (Object)vClass.getGroupURI());
        Assert.assertEquals((Object)vClassJena.getCustomEntryForm(), (Object)vClass.getCustomEntryForm());
        Assert.assertEquals((Object)vClassJena.getCustomShortView(), (Object)vClass.getCustomShortView());
        Assert.assertEquals((Object)vClassJena.getCustomSearchView(), (Object)vClass.getCustomSearchView());
        Assert.assertEquals((Object)vClassJena.getSearchBoost(), (Object)vClass.getSearchBoost());
        Assert.assertEquals((Object)vClassJena.getHiddenFromDisplayBelowRoleLevel(), (Object)vClass.getHiddenFromDisplayBelowRoleLevel());
        Assert.assertEquals((Object)vClassJena.getProhibitedFromUpdateBelowRoleLevel(), (Object)vClass.getProhibitedFromUpdateBelowRoleLevel());
        Assert.assertEquals((Object)vClassJena.getHiddenFromPublishBelowRoleLevel(), (Object)vClass.getHiddenFromPublishBelowRoleLevel());
    }

    void printModels(OntModel ontModel) {
        System.out.println("\nThe model has " + ontModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        ontModel.writeAll((OutputStream)System.out, "N3", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VClass vClassWebappFromOntClass(OntClass cls, WebappDaoFactoryJena wadf) {
        VClass vcw = new VClass();
        cls.getModel().enterCriticalSection(true);
        vcw.setName(this.getLabelForClass(cls, false, false, wadf));
        vcw.setLocalNameWithPrefix(wadf.makeLocalNameWithPrefix((ResourceBean)vcw));
        vcw.setPickListName(this.getLabelForClass(cls, false, true, wadf));
        try {
            if (cls.isAnon()) {
                vcw.setNamespace("http://vitro.mannlib.cornell.edu/ns/bnode#");
                vcw.setLocalName(cls.getId().toString());
            } else {
                if (vcw.getName() == null) {
                    vcw.setName("[null]");
                }
                vcw.setURI(cls.getURI());
                vcw.setNamespace(cls.getNameSpace());
                vcw.setLocalName(cls.getLocalName());
            }
            try {
                Resource groupRes = (Resource)cls.getPropertyValue((Property)this.LOCAL_IN_CLASSGROUP);
                if (groupRes != null) {
                    vcw.setGroupURI(groupRes.getURI());
                }
            }
            catch (Exception e) {
                System.out.println("error retrieving vitro:inClassGroup property value for " + cls.getURI());
            }
            vcw.setShortDef(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_SHORTDEF));
            vcw.setExample(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_EXAMPLE_ANNOT));
            vcw.setDescription(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_DESCRIPTION_ANNOT));
            vcw.setDisplayLimit(this.getPropertyNonNegativeIntValue((OntResource)cls, (Property)this.LOCAL_DISPLAY_LIMIT));
            vcw.setDisplayRank(this.getPropertyNonNegativeIntValue((OntResource)cls, (Property)this.LOCAL_DISPLAY_RANK_ANNOT));
            vcw.setCustomEntryForm(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_PROPERTY_CUSTOMENTRYFORMANNOT));
            vcw.setCustomDisplayView(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_PROPERTY_CUSTOMDISPLAYVIEWANNOT));
            vcw.setCustomShortView(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_PROPERTY_CUSTOMSHORTVIEWANNOT));
            vcw.setCustomSearchView(this.getPropertyStringValue((OntResource)cls, (Property)this.LOCAL_PROPERTY_CUSTOMSEARCHVIEWANNOT));
            vcw.setSearchBoost(this.getPropertyFloatValue((OntResource)cls, (Property)this.LOCAL_SEARCH_BOOST_ANNOT));
            StmtIterator it = cls.listProperties((Property)this.LOCAL_HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel hiddenRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri((String)res.getURI())) == null || hiddenRoleLevel != null && roleFromModel.compareTo((Enum)hiddenRoleLevel) <= 0) continue;
                hiddenRoleLevel = roleFromModel;
            }
            vcw.setHiddenFromDisplayBelowRoleLevel(hiddenRoleLevel);
            it = cls.listProperties((Property)this.LOCAL_PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel prohibitedRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri((String)res.getURI())) == null || prohibitedRoleLevel != null && roleFromModel.compareTo((Enum)prohibitedRoleLevel) <= 0) continue;
                prohibitedRoleLevel = roleFromModel;
            }
            vcw.setProhibitedFromUpdateBelowRoleLevel(prohibitedRoleLevel);
            it = cls.listProperties((Property)this.LOCAL_HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel publishRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri((String)res.getURI())) == null || publishRoleLevel != null && roleFromModel.compareTo((Enum)publishRoleLevel) <= 0) continue;
                publishRoleLevel = roleFromModel;
            }
            vcw.setHiddenFromPublishBelowRoleLevel(publishRoleLevel);
        }
        finally {
            cls.getModel().leaveCriticalSection();
        }
        return vcw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabelForClass(OntClass cls, boolean withPrefix, boolean forPickList, WebappDaoFactoryJena wadf) {
        cls.getModel().enterCriticalSection(true);
        try {
            if (cls.isAnon()) {
                if (cls.isRestriction()) {
                    String cRest;
                    String labelStr;
                    block42: {
                        MinCardinalityRestriction mcRest;
                        Restriction rest = cls.asRestriction();
                        OntProperty onProperty = rest.getOnProperty();
                        labelStr = "restriction on " + this.getLabelOrId((OntResource)onProperty) + ": ";
                        if (rest.isAllValuesFromRestriction() || rest.isSomeValuesFromRestriction()) {
                            Resource fillerRes = null;
                            if (rest.isAllValuesFromRestriction()) {
                                AllValuesFromRestriction avfRest = rest.asAllValuesFromRestriction();
                                fillerRes = avfRest.getAllValuesFrom();
                                labelStr = labelStr + "all values from ";
                            } else {
                                SomeValuesFromRestriction svfRest = rest.asSomeValuesFromRestriction();
                                fillerRes = svfRest.getSomeValuesFrom();
                                labelStr = labelStr + "some values from ";
                            }
                            if (fillerRes.canAs(OntClass.class)) {
                                OntClass avf = (OntClass)fillerRes.as(OntClass.class);
                                labelStr = labelStr + this.getLabelForClass(avf, withPrefix, forPickList, wadf);
                            } else {
                                try {
                                    labelStr = labelStr + this.getLabelOrId((OntResource)fillerRes.as(OntResource.class));
                                }
                                catch (Exception e) {
                                    labelStr = labelStr + "???";
                                }
                            }
                        } else if (rest.isHasValueRestriction()) {
                            HasValueRestriction hvRest = rest.asHasValueRestriction();
                            labelStr = labelStr + "has value ";
                            RDFNode fillerNode = hvRest.getHasValue();
                            try {
                                if (fillerNode.isResource()) {
                                    labelStr = labelStr + this.getLabelOrId((OntResource)fillerNode.as(OntResource.class));
                                    break block42;
                                }
                                labelStr = labelStr + ((Literal)fillerNode.as(Literal.class)).getLexicalForm();
                            }
                            catch (Exception e) {
                                labelStr = labelStr + "???";
                            }
                        } else if (rest.isMinCardinalityRestriction()) {
                            mcRest = rest.asMinCardinalityRestriction();
                            labelStr = labelStr + "minimum cardinality ";
                            labelStr = labelStr + mcRest.getMinCardinality();
                        } else if (rest.isMaxCardinalityRestriction()) {
                            mcRest = rest.asMaxCardinalityRestriction();
                            labelStr = labelStr + "maximum cardinality ";
                            labelStr = labelStr + mcRest.getMaxCardinality();
                        } else if (rest.isCardinalityRestriction()) {
                            cRest = rest.asCardinalityRestriction();
                            labelStr = labelStr + "cardinality ";
                            labelStr = labelStr + cRest.getCardinality();
                        }
                    }
                    cRest = labelStr;
                    return cRest;
                }
                if (this.isBooleanClassExpression(cls)) {
                    Object icls;
                    String labelStr = "(";
                    if (cls.isComplementClass()) {
                        labelStr = labelStr + "not ";
                        ComplementClass ccls = (ComplementClass)cls.as(ComplementClass.class);
                        labelStr = labelStr + this.getLabelForClass(ccls.getOperand(), withPrefix, forPickList, wadf);
                    } else if (cls.isIntersectionClass()) {
                        icls = (IntersectionClass)cls.as(IntersectionClass.class);
                        ExtendedIterator operandIt = icls.listOperands();
                        while (operandIt.hasNext()) {
                            OntClass operand = (OntClass)operandIt.next();
                            labelStr = labelStr + this.getLabelForClass(operand, withPrefix, forPickList, wadf);
                            if (!operandIt.hasNext()) continue;
                            labelStr = labelStr + " and ";
                        }
                    } else if (cls.isUnionClass()) {
                        icls = (UnionClass)cls.as(UnionClass.class);
                        ExtendedIterator operandIt = icls.listOperands();
                        while (operandIt.hasNext()) {
                            OntClass operand = (OntClass)operandIt.next();
                            labelStr = labelStr + this.getLabelForClass(operand, withPrefix, forPickList, wadf);
                            if (!operandIt.hasNext()) continue;
                            labelStr = labelStr + " or ";
                        }
                    }
                    icls = labelStr + ")";
                    return icls;
                }
                String labelStr = "<a href=\"vclassEdit?uri=" + URLEncoder.encode(this.getClassURIStr((Resource)cls), "UTF-8") + "\">[anonymous class]</a>";
                return labelStr;
            }
            if (withPrefix || forPickList) {
                OntologyDao oDao = wadf.getOntologyDao();
                Ontology o = oDao.getOntologyByURI(cls.getNameSpace());
                if (o != null) {
                    if (withPrefix) {
                        String string = o.getPrefix() == null ? (o.getName() == null ? "unspec:" + this.getLabelOrId((OntResource)cls) : o.getName() + ":" + this.getLabelOrId((OntResource)cls)) : o.getPrefix() + ":" + this.getLabelOrId((OntResource)cls);
                        return string;
                    }
                    String string = this.getLabelOrId((OntResource)cls) + (o.getPrefix() == null ? (o.getName() == null ? " (unspec)" : " (" + o.getName() + ")") : " (" + o.getPrefix() + ")");
                    return string;
                }
                String string = this.getLabelOrId((OntResource)cls);
                return string;
            }
            String oDao = this.getLabelOrId((OntResource)cls);
            return oDao;
        }
        catch (Exception e) {
            String string = "???";
            return string;
        }
        finally {
            cls.getModel().leaveCriticalSection();
        }
    }

    protected String getLabelOrId(OntResource r) {
        String label = null;
        r.getOntModel().enterCriticalSection(true);
        try {
            label = this.getLabel(r);
            if (label == null || label.length() == 0) {
                label = this.getLocalNameOrId(r);
            }
        }
        finally {
            r.getOntModel().leaveCriticalSection();
        }
        return label;
    }

    protected String getLabel(OntResource r) {
        String label = null;
        r.getOntModel().enterCriticalSection(true);
        try {
            label = this.tryPropertyForPreferredLanguages(r, RDFS.label, true);
            if (label == null) {
                label = this.tryPropertyForPreferredLanguages(r, r.getModel().getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#label"), true);
            }
        }
        finally {
            r.getOntModel().leaveCriticalSection();
        }
        return label;
    }

    private String tryPropertyForPreferredLanguages(OntResource r, Property p, boolean alsoTryNoLang) {
        String label = null;
        String lang = "en-US";
        List labels = r.listPropertyValues(p).toList();
        label = this.getLabel2(lang, labels);
        if (label == null && alsoTryNoLang) {
            label = this.getLabel2("", labels);
        }
        return label;
    }

    private String getLabel2(String lang, List<RDFNode> labelList) {
        for (RDFNode label : labelList) {
            if (!label.isLiteral()) continue;
            Literal labelLit = (Literal)label;
            String labelLanguage = labelLit.getLanguage();
            if (labelLanguage == null && lang == null) {
                return labelLit.getLexicalForm();
            }
            if (lang == null || !lang.equals(labelLanguage)) continue;
            return labelLit.getLexicalForm();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalNameOrId(OntResource r) {
        String label = null;
        r.getOntModel().enterCriticalSection(true);
        try {
            String localName = r.getLocalName();
            label = localName != null ? localName : (r.isAnon() ? r.getId().toString() : r.getURI());
        }
        finally {
            r.getOntModel().leaveCriticalSection();
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPropertyStringValue(OntResource res, Property dataprop) {
        if (dataprop == null) return null;
        try (StmtIterator stateIt = res.getModel().listStatements((Resource)res, dataprop, (RDFNode)((Literal)null));){
            if (stateIt.hasNext()) {
                String string = ((Literal)((Statement)stateIt.next()).getObject()).getString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int getPropertyNonNegativeIntValue(OntResource res, Property dataprop) {
        if (dataprop != null) {
            try {
                return ((Literal)res.getPropertyValue(dataprop)).getInt();
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    protected Float getPropertyFloatValue(OntResource res, Property prop) {
        if (prop != null) {
            try {
                return new Float(((Literal)res.getPropertyValue(prop)).getFloat());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public synchronized boolean isBooleanClassExpression(OntClass cls) {
        return cls.isComplementClass() || cls.isIntersectionClass() || cls.isUnionClass();
    }

    protected String getClassURIStr(Resource cls) {
        if (cls.isAnon()) {
            return "http://vitro.mannlib.cornell.edu/ns/bnode#" + cls.getId().toString();
        }
        return cls.getURI();
    }
}

