/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class EditN3UtilsTest {
    @Test
    public void testStripInvalidXMLChars() {
        Model m = ModelFactory.createDefaultModel();
        String containsInvalidXMLChars = "Blah \u0001blah \u0002blah\udddd";
        String clean = "Blah blah blah";
        m.add(m.createResource(), RDFS.label, containsInvalidXMLChars);
        Assert.assertFalse((boolean)this.isSerializableAsXML(m));
        String stripped = N3EditUtils.stripInvalidXMLChars((String)containsInvalidXMLChars);
        Assert.assertEquals((Object)clean, (Object)stripped);
        m.removeAll();
        m.add(m.createResource(), RDFS.label, stripped);
        Assert.assertTrue((boolean)this.isSerializableAsXML(m));
    }

    private boolean isSerializableAsXML(Model m) {
        try {
            NullOutputStream nullStream = new NullOutputStream();
            m.write((OutputStream)nullStream, "RDF/XML");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

