/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.permissions;

import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;

public abstract class Permission
implements Comparable<Permission> {
    protected final String uri;
    static Permission NOT_AUTHORIZED = new Permission("java:" + Permission.class.getName() + "#NOT_AUTHORIZED"){

        @Override
        public boolean isAuthorized(RequestedAction whatToAuth) {
            return false;
        }
    };

    protected Permission(String uri) {
        if (uri == null) {
            throw new NullPointerException("uri may not be null.");
        }
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public abstract boolean isAuthorized(RequestedAction var1);

    @Override
    public int compareTo(Permission that) {
        return this.uri.compareTo(that.uri);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Permission that = (Permission)obj;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "['" + this.uri + "']";
    }
}

