/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.dao.MenuDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PageDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.menu.MainMenu;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuDaoJena
extends JenaBaseDao
implements MenuDao {
    private static final Log log = LogFactory.getLog(MenuDaoJena.class);
    static final String prefixes = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n";
    protected static final String menuQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?menuItem ?linkText ?urlMapping  WHERE {\n    ?menu rdf:type display:MainMenu .\n    ?menu display:hasElement ?menuItem .  \n    ?menuItem display:linkText ?linkText .\n    OPTIONAL { ?menuItem display:menuPosition ?menuPosition }.\n    OPTIONAL { ?menuItem display:toPage ?page . }\n    OPTIONAL { ?page display:urlMapping ?urlMapping . }\n} \nORDER BY ?menuPosition ?menuItemText \n";
    protected static Query menuQuery;

    public MenuDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    public MainMenu getMainMenu(String url) {
        return this.getMenu((Model)this.getOntModelSelector().getDisplayModel(), url);
    }

    protected MainMenu getMenu(Model displayModel, String url) {
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        QueryExecution qexec = QueryExecutionFactory.create((Query)menuQuery, (Model)displayModel, (QuerySolution)initialBindings);
        try {
            MainMenu menu = new MainMenu();
            HashSet<String> seenMenuItems = new HashSet<String>();
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                String link;
                QuerySolution soln = results.nextSolution();
                Literal itemText = soln.getLiteral("linkText");
                Literal itemLink = soln.getLiteral("urlMapping");
                Resource menuItem = soln.getResource("menuItem");
                String text = itemText != null ? itemText.getLexicalForm() : "(undefined text)";
                String string = link = itemLink != null ? itemLink.getLexicalForm() : "undefinedLink";
                String menuItemUri = PageDaoJena.nodeToString((RDFNode)menuItem);
                if (seenMenuItems.contains(menuItemUri)) continue;
                menu.addItem(text, link, this.isActive(url, link));
                seenMenuItems.add(menuItemUri);
            }
            return menu;
        }
        catch (Throwable th) {
            log.error((Object)th, th);
            return new MainMenu();
        }
    }

    protected boolean isActive(String url, String link) {
        if ("/".equals(link)) {
            return "/".equals(url);
        }
        return url.startsWith(link);
    }

    static {
        try {
            menuQuery = QueryFactory.create((String)menuQueryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for menuQueryString " + th.getMessage()));
            log.error((Object)menuQueryString);
        }
    }
}

