/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FoafNameToRdfsLabelPreprocessor
implements ModelChangePreprocessor {
    private static final String FOAF = "http://xmlns.com/foaf/0.1/";
    private Log log = LogFactory.getLog(FoafNameToRdfsLabelPreprocessor.class);

    @Override
    public void preprocess(Model retractionsModel, Model additionsModel, HttpServletRequest request) {
        this.updateModelWithLabel(additionsModel);
    }

    private String getSparqlQuery() {
        String queryStr = "SELECT ?subject ?firstName ?middleName ?lastName where {?subject <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard .?individualVcard <http://www.w3.org/2006/vcard/ns#hasName> ?fullName .?fullName <http://www.w3.org/2006/vcard/ns#givenName> ?firstName .?fullName <http://www.w3.org/2006/vcard/ns#familyName> ?lastName .OPTIONAL {?subject <http://vivoweb.org/ontology/core#middleName> ?middleName .}}";
        return queryStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModelWithLabel(Model additionsModel) {
        Model changesModel = ModelFactory.createDefaultModel();
        String queryStr = this.getSparqlQuery();
        Property rdfsLabelP = additionsModel.getProperty("http://www.w3.org/2000/01/rdf-schema#label");
        Query query = null;
        QueryExecution qe = null;
        additionsModel.getLock().enterCriticalSection(true);
        try {
            query = QueryFactory.create((String)queryStr);
            qe = QueryExecutionFactory.create((Query)query, (Model)additionsModel);
            ResultSet res = qe.execSelect();
            while (res.hasNext()) {
                String newLabel = "";
                Resource subject = null;
                QuerySolution qs = res.nextSolution();
                subject = qs.getResource("subject");
                if (qs.getLiteral("firstName") == null || qs.getLiteral("lastName") == null) continue;
                Literal firstNameLiteral = qs.getLiteral("firstName");
                Literal lastNameLiteral = qs.getLiteral("lastName");
                String firstNameLanguage = firstNameLiteral.getLanguage();
                String lastNameLanguage = lastNameLiteral.getLanguage();
                newLabel = lastNameLiteral.getString() + ", " + firstNameLiteral.getString();
                if (qs.getLiteral("middleName") != null) {
                    Literal middleNameLiteral = qs.getLiteral("middleName");
                    newLabel = newLabel + " " + middleNameLiteral.getString();
                }
                if (subject != null && firstNameLanguage != null && lastNameLanguage != null && firstNameLanguage.equals(lastNameLanguage)) {
                    Literal labelWithLanguage = changesModel.createLiteral(newLabel, firstNameLanguage);
                    changesModel.add(subject, rdfsLabelP, (RDFNode)labelWithLanguage);
                    continue;
                }
                changesModel.add(subject, rdfsLabelP, newLabel);
            }
        }
        catch (Throwable th) {
            this.log.error((Object)("An error occurred in executing query:" + queryStr));
        }
        finally {
            if (qe != null) {
                qe.close();
            }
            additionsModel.getLock().leaveCriticalSection();
        }
        additionsModel.getLock().enterCriticalSection(false);
        try {
            additionsModel.add(changesModel);
        }
        catch (Throwable th) {
            this.log.error((Object)"An error occurred in writing model", th);
        }
        finally {
            additionsModel.getLock().leaveCriticalSection();
        }
    }
}

