/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.StmtIteratorImpl;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.CloseEvent;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractModelDecorator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryMappedModel
extends AbstractModelDecorator {
    private static final Log log = LogFactory.getLog(MemoryMappedModel.class);
    private final String toString;

    public MemoryMappedModel(Model externalModel, String name) {
        super(VitroModelFactory.createModel());
        super.add(externalModel);
        super.register(new ModelSynchronizer(externalModel, name));
        this.toString = "MemoryMappedModel[wrapping " + ToString.modelToString(externalModel) + "]";
    }

    @Override
    public String toString() {
        return this.toString;
    }

    public class ModelSynchronizer
    implements ModelChangedListener {
        private Model m;
        private String hash;

        public ModelSynchronizer(Model synchronizee, String name) {
            this.m = synchronizee;
            this.hash = Integer.toHexString(this.hashCode());
            log.debug((Object)String.format("create: %s, wraps %s(%s) as %s", this.hash, this.m.getClass().getName(), Integer.toHexString(this.m.hashCode()), name));
        }

        public void addedStatement(Statement s) {
            log.debug((Object)(this.hash + " addedStatement" + s));
            this.m.add(s);
        }

        public void addedStatements(Statement[] statements) {
            log.debug((Object)(this.hash + " addedStatements: " + statements.length));
            this.m.add(statements);
        }

        public void addedStatements(List<Statement> statements) {
            log.debug((Object)(this.hash + " addedStatements: " + statements.size()));
            this.m.add(statements);
        }

        public void addedStatements(StmtIterator statements) {
            if (log.isDebugEnabled()) {
                Set set = statements.toSet();
                log.debug((Object)(this.hash + " addedStatements: " + set.size()));
                this.m.add((StmtIterator)new StmtIteratorImpl(set.iterator()));
            } else {
                this.m.add((StmtIterator)new StmtIteratorImpl((Iterator)statements));
            }
        }

        public void addedStatements(Model model) {
            log.debug((Object)(this.hash + " addedStatements: " + model.size()));
            this.m.add(model);
        }

        public void notifyEvent(Model model, Object event) {
            if (event instanceof CloseEvent) {
                this.m.close();
            }
        }

        public void removedStatement(Statement s) {
            log.debug((Object)(this.hash + " removedStatement" + s));
            this.m.remove(s);
        }

        public void removedStatements(Statement[] statements) {
            log.debug((Object)(this.hash + " removedStatements: " + statements.length));
            this.m.remove(statements);
        }

        public void removedStatements(List<Statement> statements) {
            log.debug((Object)(this.hash + " removedStatements: " + statements.size()));
            this.m.remove(statements);
        }

        public void removedStatements(StmtIterator statements) {
            if (log.isDebugEnabled()) {
                Set set = statements.toSet();
                log.debug((Object)(this.hash + " removedStatements: " + set.size()));
                this.m.remove((StmtIterator)new StmtIteratorImpl(set.iterator()));
            } else {
                this.m.remove((StmtIterator)new StmtIteratorImpl((Iterator)statements));
            }
        }

        public void removedStatements(Model model) {
            log.debug((Object)(this.hash + " removedStatements: " + model.size()));
            this.m.remove(model);
        }
    }
}

