/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.sparql;

import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAllPrefix
extends BaseEditController {
    private static final Log log = LogFactory.getLog(GetAllPrefix.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        Map<String, String> prefixMap = this.getPrefixMap(vreq.getUnfilteredWebappDaoFactory());
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String respo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        respo = respo + "<options>";
        ArrayList<String> prefixList = new ArrayList<String>();
        prefixList.addAll(prefixMap.keySet());
        Collections.sort(prefixList, vreq.getCollator());
        for (String prefix : prefixList) {
            respo = respo + this.makeOption(prefix, prefixMap.get(prefix));
        }
        respo = respo + "</options>";
        out.println(respo);
        out.flush();
        out.close();
    }

    private Map<String, String> getPrefixMap(WebappDaoFactory wadf) {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        OntologyDao oDao = wadf.getOntologyDao();
        for (Ontology o : oDao.getAllOntologies()) {
            if (o.getPrefix() == null) continue;
            prefixMap.put(o.getPrefix(), o.getURI());
        }
        this.addPrefixIfNecessary("owl", OWL.getURI(), prefixMap);
        this.addPrefixIfNecessary("rdf", RDF.getURI(), prefixMap);
        this.addPrefixIfNecessary("rdfs", RDFS.getURI(), prefixMap);
        this.addPrefixIfNecessary("swrl", "http://www.w3.org/2003/11/swrl#", prefixMap);
        this.addPrefixIfNecessary("swrlb", "http://www.w3.org/2003/11/swrlb#", prefixMap);
        this.addPrefixIfNecessary("xsd", XSD.getURI(), prefixMap);
        this.addPrefixIfNecessary("vitro", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#", prefixMap);
        int newPrefixCount = 0;
        ArrayList<BaseResourceBean> ontEntityList = new ArrayList<BaseResourceBean>();
        ontEntityList.addAll(wadf.getVClassDao().getAllVclasses());
        ontEntityList.addAll(wadf.getObjectPropertyDao().getAllObjectProperties());
        ontEntityList.addAll(wadf.getDataPropertyDao().getAllDataProperties());
        for (BaseResourceBean ontEntity : ontEntityList) {
            if (ontEntity.isAnonymous() || prefixMap.containsValue(ontEntity.getNamespace())) continue;
            prefixMap.put("p." + Integer.toString(++newPrefixCount), ontEntity.getNamespace());
        }
        return prefixMap;
    }

    private void addPrefixIfNecessary(String prefix, String namespace, Map<String, String> prefixMap) {
        if (!prefixMap.containsValue(namespace)) {
            prefixMap.put(prefix, namespace);
        }
    }

    private String makeOption(String prefix, String URI2) {
        return "<option><key>" + prefix + "</key>" + "<value>" + URI2 + "</value>" + "</option>";
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

