/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Statement;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerStatementPattern;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxChanges;
import java.util.List;

public interface TBoxReasoner {
    public void updateReasonerModel(TBoxChanges var1);

    public Status performReasoning();

    public List<ObjectProperty> listObjectProperties();

    public List<DatatypeProperty> listDatatypeProperties();

    public List<Restriction> listRestrictions();

    public List<Statement> filterResults(List<ReasonerStatementPattern> var1);

    public static class Status {
        public static final Status SUCCESS = new Status(true, false, "");
        public static final Status ERROR = new Status(true, true, "");
        private final boolean consistent;
        private final boolean inErrorState;
        private final String explanation;

        public static final Status inconsistent(String explanation) {
            return new Status(false, false, explanation);
        }

        private Status(boolean consistent, boolean inErrorState, String explanation) {
            this.consistent = consistent;
            this.inErrorState = inErrorState;
            this.explanation = explanation;
        }

        public boolean isConsistent() {
            return this.consistent;
        }

        public boolean isInErrorState() {
            return this.inErrorState;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

