/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class TBoxInferencesAccumulator {
    private static final Log log = LogFactory.getLog(TBoxInferencesAccumulator.class);
    private static final Property RDFS_TYPE = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final Resource OWL_CLASS = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#Class");
    private static final Property OWL_EQUIVALENT_CLASS = ResourceFactory.createProperty((String)"http://www.w3.org/2002/07/owl#equivalentClass");
    private static final Property OWL_DISJOINT_WITH = ResourceFactory.createProperty((String)"http://www.w3.org/2002/07/owl#disjointWith");
    private static final Property OWL_SUBCLASS_OF = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#subClassOf");
    private static final Property OWL_SUBPROPERTY_OF = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
    private static final Property OWL_INVERSE_OF = ResourceFactory.createProperty((String)"http://www.w3.org/2002/07/owl#inverseOf");
    private static final Resource OWL_THING = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#Thing");
    private static final Resource OWL_OBJECT_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#ObjectProperty");
    private static final Resource OWL_TOP_OBJECT_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#topObjectProperty");
    private static final Resource OWL_BOTTOM_OBJECT_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#bottomObjectProperty");
    private static final Resource OWL_DATA_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#DatatypeProperty");
    private static final Resource OWL_TOP_DATA_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#topDataProperty");
    private static final Resource OWL_BOTTOM_DATA_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#bottomDataProperty");
    private static final Resource OWL_FUNCTIONAL_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#FunctionalProperty");
    private static final Resource OWL_INVERSE_FUNCTIONAL_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#InverseFunctionalProperty");
    private static final Resource OWL_TRANSITIVE_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#TransitiveProperty");
    private static final Resource OWL_SYMMETRIC_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#SymmetricProperty");
    private static final Resource OWL_ASYMMETRIC_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#AsymmetricProperty");
    private static final Resource OWL_REFLEXIVE_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#ReflexiveProperty");
    private static final Resource OWL_IRREFLEXIVE_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#IrreflexiveProperty");
    private static final Resource OWL_ANNOTATION_PROPERTY = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#AnnotationProperty");
    private static final Resource OWL_VERSION_INFO = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#versionInfo");
    private static final Resource OWL_BACKWARD_COMPATIBLE_WITH = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#backwardCompatibleWith");
    private static final Resource OWL_INCOMPATIBLE_WITH = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#incompatibleWith");
    private static final Resource OWL_PRIOR_VERSION = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#priorVersion");
    private static final Resource RDFS_SEE_ALSO = ResourceFactory.createResource((String)"http://www.w3.org/2000/01/rdf-schema#seeAlso");
    private static final Resource RDFS_COMMENT = ResourceFactory.createResource((String)"http://www.w3.org/2000/01/rdf-schema#comment");
    private static final Resource RDFS_IS_DEFINED_BY = ResourceFactory.createResource((String)"http://www.w3.org/2000/01/rdf-schema#isDefinedBy");
    private static final Resource RDFS_LABEL = ResourceFactory.createResource((String)"http://www.w3.org/2000/01/rdf-schema#label");

    public Model populateModelFromReasonerQueries(OWLReasoner reasoner) {
        Model m = ModelFactory.createDefaultModel();
        this.populateClasses(reasoner, m);
        this.populateObjectProperties(reasoner, m);
        this.populateDataProperties(reasoner, m);
        this.klugeOwlInvariants(m);
        this.klugeMistakes(m);
        return m;
    }

    private void populateClasses(OWLReasoner r, Model m) {
        OWLClass bottom = (OWLClass)r.getBottomClassNode().getRepresentativeElement();
        for (OWLClass c : r.getSuperClasses((OWLClassExpression)bottom, false).getFlattened()) {
            this.populateClass(c, r, m);
        }
    }

    private void populateClass(OWLClass c, OWLReasoner r, Model m) {
        log.debug((Object)("Owl class: " + c));
        this.populateClassType(c, m);
        this.populateEquivalentClasses(c, r, m);
        this.populateDisjointClasses(c, r, m);
        this.populateSubClasses(c, r, m);
    }

    private void populateClassType(OWLClass c, Model m) {
        log.debug((Object)(c + " is a class."));
        m.add(this.toResource((OWLNamedObject)c), RDFS_TYPE, (RDFNode)OWL_CLASS);
    }

    private void populateEquivalentClasses(OWLClass c, OWLReasoner r, Model m) {
        for (OWLClass equiv : r.getEquivalentClasses((OWLClassExpression)c).getEntities()) {
            log.debug((Object)("Equivalent class: " + c + ", " + equiv));
            m.add(this.toResource((OWLNamedObject)c), OWL_EQUIVALENT_CLASS, (RDFNode)this.toResource((OWLNamedObject)equiv));
        }
    }

    private void populateDisjointClasses(OWLClass c, OWLReasoner r, Model m) {
        for (OWLClass d : r.getDisjointClasses((OWLClassExpression)c).getFlattened()) {
            if (d.isOWLNothing()) continue;
            log.debug((Object)("Disjoint class: " + c + ", " + d));
            m.add(this.toResource((OWLNamedObject)c), OWL_DISJOINT_WITH, (RDFNode)this.toResource((OWLNamedObject)d));
        }
    }

    private void populateSubClasses(OWLClass c, OWLReasoner r, Model m) {
        for (OWLClass sub : r.getSubClasses((OWLClassExpression)c, false).getFlattened()) {
            log.debug((Object)(sub + " is subclass of " + c));
            if (sub.isOWLNothing()) continue;
            m.add(this.toResource((OWLNamedObject)sub), OWL_SUBCLASS_OF, (RDFNode)this.toResource((OWLNamedObject)c));
        }
    }

    private void populateObjectProperties(OWLReasoner r, Model m) {
        OWLObjectPropertyExpression bottom = (OWLObjectPropertyExpression)r.getBottomObjectPropertyNode().getRepresentativeElement();
        this.populateObjectProperty(bottom, r, m);
        for (OWLObjectPropertyExpression op : r.getSuperObjectProperties(bottom, false).getFlattened()) {
            this.populateObjectProperty(op, r, m);
        }
    }

    private void populateObjectProperty(OWLObjectPropertyExpression ope, OWLReasoner r, Model m) {
        if (!ope.isAnonymous()) {
            OWLObjectProperty op = ope.asOWLObjectProperty();
            log.debug((Object)("object property: " + op));
            this.populateObjectSubProperties(op, r, m);
            this.populateObjectInverseProperties(op, r, m);
        }
    }

    private void populateObjectSubProperties(OWLObjectProperty op, OWLReasoner r, Model m) {
        for (OWLObjectPropertyExpression subOPE : r.getSubObjectProperties((OWLObjectPropertyExpression)op, false).getFlattened()) {
            if (subOPE.isAnonymous()) continue;
            OWLObjectProperty subOP = subOPE.asOWLObjectProperty();
            log.debug((Object)(subOP + " object sub-property of " + op));
            m.add(this.toResource((OWLNamedObject)subOP), OWL_SUBPROPERTY_OF, (RDFNode)this.toResource((OWLNamedObject)op));
        }
        log.debug((Object)(op + " object sub-property of " + op));
        m.add(this.toResource((OWLNamedObject)op), OWL_SUBPROPERTY_OF, (RDFNode)this.toResource((OWLNamedObject)op));
    }

    private void populateObjectInverseProperties(OWLObjectProperty op, OWLReasoner r, Model m) {
        for (OWLObjectPropertyExpression inverseE : r.getInverseObjectProperties((OWLObjectPropertyExpression)op)) {
            if (inverseE.isAnonymous() || inverseE.isOWLBottomObjectProperty() || inverseE.isOWLTopObjectProperty()) continue;
            OWLObjectProperty inverse = inverseE.asOWLObjectProperty();
            log.debug((Object)(inverse + " object inverse of " + op));
            m.add(this.toResource((OWLNamedObject)inverse), OWL_INVERSE_OF, (RDFNode)this.toResource((OWLNamedObject)op));
        }
    }

    private void populateDataProperties(OWLReasoner r, Model m) {
        OWLDataProperty bottom = (OWLDataProperty)r.getBottomDataPropertyNode().getRepresentativeElement();
        this.populateDataProperty(bottom, r, m);
        for (OWLDataProperty dp : r.getSuperDataProperties(bottom, false).getFlattened()) {
            this.populateDataProperty(dp, r, m);
        }
    }

    private void populateDataProperty(OWLDataProperty dp, OWLReasoner r, Model m) {
        log.debug((Object)("data property: " + dp));
        this.populateDataSubProperties(dp, r, m);
    }

    private void populateDataSubProperties(OWLDataProperty dp, OWLReasoner r, Model m) {
        for (OWLDataProperty subDP : r.getSubDataProperties(dp, false).getFlattened()) {
            log.debug((Object)(subDP + " data sub-property of " + dp));
            m.add(this.toResource((OWLNamedObject)subDP), OWL_SUBPROPERTY_OF, (RDFNode)this.toResource((OWLNamedObject)dp));
        }
        log.debug((Object)(dp + " data sub-property of " + dp));
        m.add(this.toResource((OWLNamedObject)dp), OWL_SUBPROPERTY_OF, (RDFNode)this.toResource((OWLNamedObject)dp));
    }

    private Resource toResource(OWLNamedObject owlObject) {
        return ResourceFactory.createResource((String)owlObject.getIRI().toString());
    }

    private void klugeOwlInvariants(Model m) {
        m.add(OWL_BOTTOM_DATA_PROPERTY, RDFS_TYPE, (RDFNode)OWL_DATA_PROPERTY);
        m.add(OWL_BOTTOM_DATA_PROPERTY, RDFS_TYPE, (RDFNode)OWL_FUNCTIONAL_PROPERTY);
        m.add(OWL_TOP_DATA_PROPERTY, RDFS_TYPE, (RDFNode)OWL_DATA_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_FUNCTIONAL_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_INVERSE_FUNCTIONAL_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_TRANSITIVE_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_SYMMETRIC_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_ASYMMETRIC_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_IRREFLEXIVE_PROPERTY);
        m.add(OWL_TOP_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        m.add(OWL_TOP_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_TRANSITIVE_PROPERTY);
        m.add(OWL_TOP_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_REFLEXIVE_PROPERTY);
        m.add(OWL_TOP_OBJECT_PROPERTY, RDFS_TYPE, (RDFNode)OWL_SYMMETRIC_PROPERTY);
        m.add(OWL_THING, RDFS_TYPE, (RDFNode)OWL_CLASS);
        m.add(OWL_VERSION_INFO, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(OWL_BACKWARD_COMPATIBLE_WITH, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(OWL_PRIOR_VERSION, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(OWL_INCOMPATIBLE_WITH, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(RDFS_SEE_ALSO, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(RDFS_COMMENT, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(RDFS_IS_DEFINED_BY, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
        m.add(RDFS_LABEL, RDFS_TYPE, (RDFNode)OWL_ANNOTATION_PROPERTY);
    }

    private void klugeMistakes(Model m) {
        Property ISF_DEPRECATED = ResourceFactory.createProperty((String)"http://isf/deprecated_op");
        m.add((Resource)ISF_DEPRECATED, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        m.add((Resource)ISF_DEPRECATED, OWL_SUBPROPERTY_OF, (RDFNode)ISF_DEPRECATED);
        m.add((Resource)ISF_DEPRECATED, OWL_SUBPROPERTY_OF, (RDFNode)OWL_TOP_OBJECT_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, OWL_SUBPROPERTY_OF, (RDFNode)ISF_DEPRECATED);
        Resource OWL_DEPRECATED = ResourceFactory.createResource((String)"http://www.w3.org/2002/07/owl#DeprecatedProperty");
        m.add(OWL_DEPRECATED, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        m.add(OWL_DEPRECATED, OWL_SUBPROPERTY_OF, (RDFNode)OWL_DEPRECATED);
        m.add(OWL_DEPRECATED, OWL_SUBPROPERTY_OF, (RDFNode)OWL_TOP_OBJECT_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, OWL_SUBPROPERTY_OF, (RDFNode)OWL_DEPRECATED);
        Property DCT_CONTRIBUTOR = ResourceFactory.createProperty((String)"http://purl.org/dc/terms/contributor");
        m.add((Resource)DCT_CONTRIBUTOR, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        m.add((Resource)DCT_CONTRIBUTOR, OWL_SUBPROPERTY_OF, (RDFNode)DCT_CONTRIBUTOR);
        m.add((Resource)DCT_CONTRIBUTOR, OWL_SUBPROPERTY_OF, (RDFNode)OWL_TOP_OBJECT_PROPERTY);
        m.add(OWL_BOTTOM_OBJECT_PROPERTY, OWL_SUBPROPERTY_OF, (RDFNode)DCT_CONTRIBUTOR);
        Resource ARG_2000400 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/ARG_2000400");
        Resource BFO_0000001 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/BFO_0000001");
        Resource BFO_0000002 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/BFO_0000002");
        Resource BFO_0000031 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/BFO_0000031");
        Resource IAO_0000003 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/IAO_0000003");
        Resource IAO_0000009 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/IAO_0000009");
        Resource IAO_0000030 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/IAO_0000030");
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)BFO_0000001);
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)BFO_0000002);
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)BFO_0000031);
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)IAO_0000003);
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)IAO_0000009);
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)IAO_0000030);
        m.add(ARG_2000400, RDFS_TYPE, (RDFNode)OWL_THING);
        Resource BIBO_ACCEPTED = ResourceFactory.createResource((String)"http://purl.org/ontology/bibo/accepted");
        Resource BIBO_DRAFT = ResourceFactory.createResource((String)"http://purl.org/ontology/bibo/draft");
        Resource BIBO_PEER_REVIEWED = ResourceFactory.createResource((String)"http://purl.org/ontology/bibo/peerReviewed");
        Resource BIBO_PUBLISHED = ResourceFactory.createResource((String)"http://purl.org/ontology/bibo/published");
        Resource BIBO_REJECTED = ResourceFactory.createResource((String)"http://purl.org/ontology/bibo/rejected");
        Resource BIBO_UNPUBLISHED = ResourceFactory.createResource((String)"http://purl.org/ontology/bibo/unpublished");
        m.add(BIBO_ACCEPTED, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(BIBO_DRAFT, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(BIBO_PEER_REVIEWED, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(BIBO_PUBLISHED, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(BIBO_REJECTED, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(BIBO_UNPUBLISHED, RDFS_TYPE, (RDFNode)OWL_THING);
        Resource CORE_YMDT_PRECISION = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#yearMonthDayTimePrecision");
        Resource CORE_YMD_PRECISION = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#yearMonthDayPrecision");
        Resource CORE_YM_PRECISION = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#yearMonthPrecision");
        Resource CORE_Y_PRECISION = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#yearPrecision");
        Resource SKOS_CONCEPT = ResourceFactory.createResource((String)"http://www.w3.org/2004/02/skos/core#Concept");
        m.add(CORE_YMDT_PRECISION, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(CORE_YMDT_PRECISION, RDFS_TYPE, (RDFNode)SKOS_CONCEPT);
        m.add(CORE_YMD_PRECISION, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(CORE_YMD_PRECISION, RDFS_TYPE, (RDFNode)SKOS_CONCEPT);
        m.add(CORE_YM_PRECISION, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(CORE_YM_PRECISION, RDFS_TYPE, (RDFNode)SKOS_CONCEPT);
        m.add(CORE_Y_PRECISION, RDFS_TYPE, (RDFNode)OWL_THING);
        m.add(CORE_Y_PRECISION, RDFS_TYPE, (RDFNode)SKOS_CONCEPT);
        Resource CORE_CONTACT_INFO = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#contactInformation");
        m.add(CORE_CONTACT_INFO, RDFS_TYPE, (RDFNode)OWL_DATA_PROPERTY);
        Resource CORE_HAS_FACILITY = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#hasFacility");
        m.add(CORE_HAS_FACILITY, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        Resource CORE_HAS_FUNDING = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#hasFundingVehicle");
        m.add(CORE_HAS_FUNDING, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        Resource CORE_HAS_GOV_AUTH = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#hasGoverningAuthority");
        m.add(CORE_HAS_GOV_AUTH, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        Resource CORE_IN_PRESS = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#inPress");
        m.add(CORE_IN_PRESS, RDFS_TYPE, (RDFNode)OWL_THING);
        Resource CORE_INVITED = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#invited");
        m.add(CORE_INVITED, RDFS_TYPE, (RDFNode)OWL_THING);
        Resource CORE_SUBMITTED = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/core#submitted");
        m.add(CORE_SUBMITTED, RDFS_TYPE, (RDFNode)OWL_THING);
        Resource OBO_HAS_AGENT = ResourceFactory.createResource((String)"http://www.obofoundry.org/ro/ro.owl#has_agent");
        m.add(OBO_HAS_AGENT, RDFS_TYPE, (RDFNode)OWL_OBJECT_PROPERTY);
        Resource OBI_0000066 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/OBI_0000066");
        m.remove(OBI_0000066, RDFS_TYPE, (RDFNode)OWL_CLASS);
        m.remove(OBI_0000066, OWL_SUBCLASS_OF, (RDFNode)OWL_THING);
        m.remove(OBI_0000066, OWL_EQUIVALENT_CLASS, (RDFNode)OBI_0000066);
        Resource OBI_0000086 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/OBI_0000086");
        m.remove(OBI_0000086, RDFS_TYPE, (RDFNode)OWL_CLASS);
        m.remove(OBI_0000086, OWL_SUBCLASS_OF, (RDFNode)OWL_THING);
        m.remove(OBI_0000086, OWL_EQUIVALENT_CLASS, (RDFNode)OBI_0000086);
        Resource OBI_0000094 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/OBI_0000094");
        m.remove(OBI_0000094, RDFS_TYPE, (RDFNode)OWL_CLASS);
        m.remove(OBI_0000094, OWL_SUBCLASS_OF, (RDFNode)OWL_THING);
        m.remove(OBI_0000094, OWL_EQUIVALENT_CLASS, (RDFNode)OBI_0000094);
        Resource OBI_0000571 = ResourceFactory.createResource((String)"http://purl.obolibrary.org/obo/OBI_0000571");
        m.remove(OBI_0000571, RDFS_TYPE, (RDFNode)OWL_CLASS);
        m.remove(OBI_0000571, OWL_SUBCLASS_OF, (RDFNode)OWL_THING);
        m.remove(OBI_0000571, OWL_EQUIVALENT_CLASS, (RDFNode)OBI_0000571);
    }
}

