/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationRdf;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationRdfParser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.InstanceWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockableModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.criticalsection.LockedModel;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ConfigurationBeanLoader {
    private static final String JAVA_URI_PREFIX = "java:";
    private final LockableModel locking;
    private final ServletContext ctx;
    private final HttpServletRequest req;

    public static String toJavaUri(Class<?> clazz) {
        return JAVA_URI_PREFIX + clazz.getName();
    }

    public static boolean isJavaUri(String uri) {
        return uri.startsWith(JAVA_URI_PREFIX);
    }

    public static String fromJavaUri(String uri) {
        if (!ConfigurationBeanLoader.isJavaUri(uri)) {
            throw new IllegalArgumentException("Not a java class URI: '" + uri + "'");
        }
        return uri.substring(JAVA_URI_PREFIX.length());
    }

    public ConfigurationBeanLoader(Model model) {
        this(new LockableModel(model), null, null);
    }

    public ConfigurationBeanLoader(LockableModel locking) {
        this(locking, null, null);
    }

    public ConfigurationBeanLoader(Model model, ServletContext ctx) {
        this(new LockableModel(model), ctx, null);
    }

    public ConfigurationBeanLoader(LockableModel locking, ServletContext ctx) {
        this(locking, ctx, null);
    }

    public ConfigurationBeanLoader(Model model, HttpServletRequest req) {
        this(new LockableModel(model), req);
    }

    public ConfigurationBeanLoader(LockableModel locking, HttpServletRequest req) {
        this(locking, req == null ? null : req.getSession().getServletContext(), req);
    }

    private ConfigurationBeanLoader(LockableModel locking, ServletContext ctx, HttpServletRequest req) {
        this.locking = Objects.requireNonNull(locking, "locking may not be null.");
        this.req = req;
        this.ctx = ctx;
    }

    public <T> T loadInstance(String uri, Class<T> resultClass) throws ConfigurationBeanLoaderException {
        if (uri == null) {
            throw new NullPointerException("uri may not be null.");
        }
        if (resultClass == null) {
            throw new NullPointerException("resultClass may not be null.");
        }
        try {
            ConfigurationRdf<T> parsedRdf = ConfigurationRdfParser.parse(this.locking, uri, resultClass);
            WrappedInstance<T> wrapper = InstanceWrapper.wrap(parsedRdf.getConcreteClass());
            wrapper.satisfyInterfaces(this.ctx, this.req);
            wrapper.setProperties(this, parsedRdf.getPropertyStatements());
            wrapper.validate();
            return wrapper.getInstance();
        }
        catch (Exception e) {
            throw new ConfigurationBeanLoaderException("Failed to load '" + uri + "'", e);
        }
    }

    public <T> Set<T> loadAll(Class<T> resultClass) throws ConfigurationBeanLoaderException {
        HashSet<String> uris = new HashSet<String>();
        LockedModel m = this.locking.read();
        Object object = null;
        try {
            List resources = m.listResourcesWithProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)ConfigurationBeanLoader.toJavaUri(resultClass))).toList();
            for (Resource r : resources) {
                if (!r.isURIResource()) continue;
                uris.add(r.getURI());
            }
        }
        catch (Throwable resources) {
            object = resources;
            throw resources;
        }
        finally {
            if (m != null) {
                if (object != null) {
                    try {
                        m.close();
                    }
                    catch (Throwable resources) {
                        ((Throwable)object).addSuppressed(resources);
                    }
                } else {
                    m.close();
                }
            }
        }
        HashSet<T> instances = new HashSet<T>();
        for (String uri : uris) {
            instances.add(this.loadInstance(uri, resultClass));
        }
        return instances;
    }
}

