/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FixedHTMLDataGetter
extends DataGetterBase
implements DataGetter {
    String dataGetterURI;
    String htmlValue;
    String saveToVar;
    VitroRequest vreq;
    ServletContext context;
    private static final String defaultTemplate = "menupage--defaultFixedHtml.ftl";
    static final Log log = LogFactory.getLog(FixedHTMLDataGetter.class);
    private static final String saveToVarPropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar>";
    private static final String htmlValuePropertyURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#htmlValue>";
    public static final String defaultVarNameForResults = "results";
    private static final String dataGetterQuery = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?saveToVar ?htmlValue WHERE { \n  ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#saveToVar> ?saveToVar . \n  ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#htmlValue> ?htmlValue . \n}";

    public FixedHTMLDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        rmap.put("variableName", this.saveToVar);
        rmap.put(this.saveToVar, this.htmlValue);
        rmap.put("bodyTemplate", defaultTemplate);
        return rmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.context = vreq.getSession().getServletContext();
        this.dataGetterURI = dataGetterURI;
        QuerySolutionMap initBindings = new QuerySolutionMap();
        initBindings.add("dataGetterURI", (RDFNode)ResourceFactory.createResource((String)this.dataGetterURI));
        int count = 0;
        Query dataGetterConfigurationQuery = QueryFactory.create((String)dataGetterQuery);
        displayModel.enterCriticalSection(true);
        try {
            QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterConfigurationQuery, (Model)displayModel, (QuerySolution)initBindings);
            ResultSet res = qexec.execSelect();
            try {
                while (res.hasNext()) {
                    ++count;
                    QuerySolution soln = res.next();
                    Literal value = soln.getLiteral("htmlValue");
                    if (dataGetterConfigurationQuery == null) {
                        log.error((Object)("no html value defined for page " + this.dataGetterURI));
                    } else {
                        this.htmlValue = value.getLexicalForm();
                    }
                    Literal saveTo = soln.getLiteral("saveToVar");
                    if (saveTo != null && saveTo.isLiteral()) {
                        this.saveToVar = saveTo.asLiteral().getLexicalForm();
                        continue;
                    }
                    this.saveToVar = defaultVarNameForResults;
                }
            }
            finally {
                qexec.close();
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }
}

