/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.threads;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroBackgroundThread
extends Thread {
    Log log = LogFactory.getLog(VitroBackgroundThread.class);
    private static final ConcurrentLinkedQueue<WeakReference<VitroBackgroundThread>> allThreads = new ConcurrentLinkedQueue();
    private volatile WorkLevelStamp stamp = new WorkLevelStamp(WorkLevel.IDLE, new String[0]);

    public static List<VitroBackgroundThread> getThreads() {
        ArrayList<VitroBackgroundThread> list = new ArrayList<VitroBackgroundThread>();
        for (WeakReference<VitroBackgroundThread> ref : allThreads) {
            VitroBackgroundThread t = (VitroBackgroundThread)ref.get();
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    public static List<VitroBackgroundThread> getLivingThreads() {
        ArrayList<VitroBackgroundThread> list = new ArrayList<VitroBackgroundThread>();
        for (VitroBackgroundThread t : VitroBackgroundThread.getThreads()) {
            if (!t.isAlive()) continue;
            list.add(t);
        }
        return list;
    }

    public VitroBackgroundThread(String name) {
        super(name);
        allThreads.add(new WeakReference<VitroBackgroundThread>(this));
    }

    public VitroBackgroundThread(Runnable target, String name) {
        super(target, name);
        allThreads.add(new WeakReference<VitroBackgroundThread>(this));
    }

    public void setWorkLevel(WorkLevel level, String ... flags) {
        this.log.debug((Object)("Set work level on '" + this.getName() + "' to " + (Object)((Object)level) + ", flags=" + flags));
        this.stamp = new WorkLevelStamp(level, flags);
    }

    public WorkLevelStamp getWorkLevel() {
        return this.stamp;
    }

    public static class Factory
    implements ThreadFactory {
        private final String threadName;
        private final AtomicInteger index;

        public Factory(String threadName) {
            this.threadName = threadName;
            this.index = new AtomicInteger();
        }

        @Override
        public Thread newThread(Runnable r) {
            return new VitroBackgroundThread(r, this.threadName + "_" + this.index.getAndIncrement());
        }
    }

    public static class WorkLevelStamp {
        private final WorkLevel level;
        private final long since;
        private final List<String> flags;

        public WorkLevelStamp(WorkLevel level, String ... flags) {
            this.level = level;
            this.since = System.currentTimeMillis();
            this.flags = Collections.unmodifiableList(Arrays.asList(flags));
        }

        public WorkLevel getLevel() {
            return this.level;
        }

        public Date getSince() {
            return new Date(this.since);
        }

        public Collection<String> getFlags() {
            return this.flags;
        }
    }

    public static enum WorkLevel {
        IDLE,
        WORKING;

    }
}

