/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.ApplicationDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;

public class UrlBuilderTest
extends AbstractTestClass {
    @Test
    public void testGetUrl() {
        UrlBuilder.contextPath = "/vivo";
        String path1 = "/individual";
        Assert.assertEquals((Object)"/vivo/individual", (Object)UrlBuilder.getUrl((String)path1));
        int portalId = 1;
        String path2 = "/individual?home=" + portalId;
        Assert.assertEquals((Object)"/vivo/individual?home=1", (Object)UrlBuilder.getUrl((String)path2));
    }

    @Test
    public void testGetUrlWithEmptyContext() {
        UrlBuilder.contextPath = "";
        String path = "/individual";
        Assert.assertEquals((Object)path, (Object)UrlBuilder.getUrl((String)path));
    }

    @Test
    public void testGetUrlWithParams() {
        UrlBuilder.contextPath = "/vivo";
        String path = "/individual";
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
        int portalId = 1;
        params.put((Object)"home", (Object)("" + portalId));
        params.put((Object)"name", (Object)"Tom");
        Assert.assertEquals((Object)"/vivo/individual?home=1&name=Tom", (Object)UrlBuilder.getUrl((String)path, (UrlBuilder.ParamMap)params));
    }

    @Test
    public void testEncodeUrl() {
        UrlBuilder.contextPath = "/vivo";
        String path = "/individuallist";
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
        String vClassUri = "http://vivoweb.org/ontology/core#FacultyMember";
        params.put((Object)"vclassId", (Object)vClassUri);
        Assert.assertEquals((Object)"/vivo/individuallist?vclassId=http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23FacultyMember", (Object)UrlBuilder.getUrl((String)path, (UrlBuilder.ParamMap)params));
    }

    @Test
    public void testDecodeUrl() {
        String vClassUri = "http://vivoweb.org/ontology/core#FacultyMember";
        String vClassUriEncoded = "http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23FacultyMember";
        Assert.assertEquals((Object)vClassUri, (Object)UrlBuilder.urlDecode((String)vClassUriEncoded));
    }

    @Test
    public void testUtf8Encode() {
        UrlBuilder.contextPath = "/vivo";
        String path = "/individual";
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
        params.put((Object)"name", (Object)"\u2605Tom\u2605");
        Assert.assertEquals((Object)"/vivo/individual?name=%E2%98%85Tom%E2%98%85", (Object)UrlBuilder.getUrl((String)path, (UrlBuilder.ParamMap)params));
    }

    @Test
    public void testDecodeUtf8Url() {
        String vClassUri = "http://vivoweb.org/ontology/core#FacultyMember\u2605";
        String vClassUriEncoded = "http%3A%2F%2Fvivoweb.org%2Fontology%2Fcore%23FacultyMember%E2%98%85";
        Assert.assertEquals((Object)vClassUri, (Object)UrlBuilder.urlDecode((String)vClassUriEncoded));
    }

    @Test
    public void testGetIndividualProfileURI() {
        VitroRequest vreq = this.makeMockVitroRequest("http://example.com/individual/");
        UrlBuilder.contextPath = "http://example.com";
        String uri = "http://example.com/individual/n2343";
        String url = UrlBuilder.getIndividualProfileUrl((String)uri, (VitroRequest)vreq);
        Assert.assertEquals((Object)"http://example.com/display/n2343", (Object)url);
        uri = "http://example.com/individual/bob";
        url = UrlBuilder.getIndividualProfileUrl((String)uri, (VitroRequest)vreq);
        Assert.assertEquals((Object)"http://example.com/display/bob", (Object)url);
        uri = "http://nondefaultNS.com/individual/n2343";
        url = UrlBuilder.getIndividualProfileUrl((String)uri, (VitroRequest)vreq);
        Assert.assertEquals((Object)("http://example.com/individual?uri=" + URLEncoder.encode((String)uri)), (Object)url);
        uri = "http://example.com/individual#n2343";
        url = UrlBuilder.getIndividualProfileUrl((String)uri, (VitroRequest)vreq);
        Assert.assertEquals((Object)("http://example.com/individual?uri=" + URLEncoder.encode((String)uri)), (Object)url);
        uri = "http://example.com/individual/5LNCannotStartWithNumber";
        url = UrlBuilder.getIndividualProfileUrl((String)uri, (VitroRequest)vreq);
        Assert.assertEquals((Object)("http://example.com/individual?uri=" + URLEncoder.encode((String)uri)), (Object)url);
    }

    protected VitroRequest makeMockVitroRequest(final String defaultNS) {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        return new VitroRequest(req){

            public String getParameter(String key) {
                return null;
            }

            public WebappDaoFactory getWebappDaoFactory() {
                return UrlBuilderTest.this.makeMockWDF(defaultNS);
            }
        };
    }

    protected WebappDaoFactoryStub makeMockWDF(String defaultNS) {
        WebappDaoFactoryStub wdf = new WebappDaoFactoryStub();
        wdf.setDefaultNamespace("http://example.com/individual/");
        ApplicationDaoStub aDao = new ApplicationDaoStub(){

            @Override
            public boolean isExternallyLinkedNamespace(String ns) {
                return false;
            }
        };
        wdf.setApplicationDao(aDao);
        return wdf;
    }

    @Test
    public void testIsUriInDefaultNamespace() {
        String[][] counterExamples;
        String[][] examples;
        for (String[] example : examples = new String[][]{{"http://example.com/individual/n3234", "http://example.com/individual/"}, {"http://example.com/individual#n3234", "http://example.com/individual#"}, {"http://example.com:8080/individual/n3234", "http://example.com:8080/individual/"}, {"http://example.com:8080/individual#n3234", "http://example.com:8080/individual#"}}) {
            Assert.assertTrue((String)("expected '" + example[0] + "' to be in the default NS of '" + example[1] + "'"), (boolean)UrlBuilder.isUriInDefaultNamespace((String)example[0], (String)example[1]));
        }
        for (String[] example : counterExamples = new String[][]{{"http://example.com/individual/5LNCannotStartWithNumber", "http://example.com/individual/"}}) {
            Assert.assertFalse((String)("expected '" + example[0] + "' to NOT be in the default NS of '" + example[1] + "'"), (boolean)UrlBuilder.isUriInDefaultNamespace((String)example[0], (String)example[1]));
        }
    }
}

