/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.validator.impl;

import edu.cornell.mannlib.vedit.validator.ValidationObject;
import edu.cornell.mannlib.vedit.validator.Validator;
import java.util.HashSet;
import java.util.Iterator;

public class EnumValuesValidator
implements Validator {
    private HashSet legalValues = new HashSet();

    @Override
    public ValidationObject validate(Object obj) {
        ValidationObject vo = new ValidationObject();
        if (this.legalValues.contains((String)obj)) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            if (this.legalValues.size() < 7) {
                String msgString = "Please enter one of ";
                Iterator valuesIt = this.legalValues.iterator();
                while (valuesIt.hasNext()) {
                    String legalValue = (String)valuesIt.next();
                    msgString = msgString + "'" + legalValue + "'";
                    if (valuesIt.hasNext()) {
                        msgString = msgString + ", ";
                        continue;
                    }
                    msgString = msgString + ".";
                }
                vo.setMessage(msgString);
            } else {
                vo.setMessage("Please enter a legal value.");
            }
        }
        vo.setValidatedObject(obj);
        return vo;
    }

    public EnumValuesValidator(String[] legalValues) {
        for (int i = 0; i < legalValues.length; ++i) {
            this.legalValues.add(legalValues[i]);
        }
    }
}

