/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailUsersServlet
extends VitroHttpServlet {
    private static final Log log = LogFactory.getLog(MailUsersServlet.class);
    public static HttpServletRequest request;
    public static HttpServletRequest response;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        VitroRequest vreq = new VitroRequest(request);
        String confirmpage = "/confirmUserMail.jsp";
        String errpage = "/contact_err.jsp";
        String status = null;
        if (!FreemarkerEmailFactory.isConfigured((HttpServletRequest)vreq)) {
            status = "This application has not yet been configured to send mail. Email properties must be specified in the configuration properties file.";
            response.sendRedirect("test?bodyJsp=" + errpage + "&ERR=" + status);
            return;
        }
        String SPAM_MESSAGE = "Your message was flagged as spam.";
        boolean probablySpam = false;
        String spamReason = "";
        String originalReferer = (String)request.getSession().getAttribute("commentsFormReferer");
        request.getSession().removeAttribute("commentsFormReferer");
        if (originalReferer == null) {
            originalReferer = "none";
        } else {
            String string = request.getHeader("Referer");
        }
        String formType = vreq.getParameter("DeliveryType");
        List<String> deliverToArray = null;
        int recipientCount = 0;
        String deliveryfrom = null;
        deliverToArray = this.getEmailsForAllUserAccounts(vreq);
        int n = recipientCount = deliverToArray == null ? 0 : deliverToArray.size();
        if (recipientCount == 0) {
            throw new Error("To establish the Contact Us mail capability the system administrators must  specify at least one email address in the current portal.");
        }
        String webusername = vreq.getParameter("webusername");
        String webuseremail = vreq.getParameter("webuseremail");
        String comments = vreq.getParameter("s34gfd88p9x1");
        webusername = webusername.trim();
        deliveryfrom = webuseremail;
        comments = comments.trim();
        StringBuffer msgBuf = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        msgBuf.setLength(0);
        msgBuf.append("<html>" + lineSeparator);
        msgBuf.append("<head>" + lineSeparator);
        msgBuf.append("<style>a {text-decoration: none}</style>" + lineSeparator);
        msgBuf.append("<title>" + deliveryfrom + "</title>" + lineSeparator);
        msgBuf.append("</head>" + lineSeparator);
        msgBuf.append("<body>" + lineSeparator);
        msgBuf.append("<h4>" + deliveryfrom + "</h4>" + lineSeparator);
        msgBuf.append("<h4>From: " + webusername + " (" + webuseremail + ")" + " at IP address " + request.getRemoteAddr() + "</h4>" + lineSeparator);
        msgBuf.append(lineSeparator + "</i></p><h3>Comments:</h3>" + lineSeparator);
        if (comments == null || comments.equals("")) {
            msgBuf.append("<p>BLANK MESSAGE</p>");
        } else {
            msgBuf.append("<p>" + comments + "</p>");
        }
        msgBuf.append("</body>" + lineSeparator);
        msgBuf.append("</html>" + lineSeparator);
        String msgText = msgBuf.toString();
        Calendar cal = Calendar.getInstance();
        Session s = FreemarkerEmailFactory.getEmailSession((HttpServletRequest)vreq);
        try {
            MimeMessage msg = new MimeMessage(s);
            log.debug((Object)"trying to send message from servlet");
            msg.setFrom((Address)new InternetAddress(webuseremail));
            if (recipientCount > 0) {
                InternetAddress[] address = new InternetAddress[recipientCount];
                for (int i = 0; i < recipientCount; ++i) {
                    address[i] = new InternetAddress(deliverToArray.get(i));
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            }
            msg.setSubject(deliveryfrom);
            msg.setContent((Object)msgText, "text/html; charset=UTF-8");
            msg.setSentDate(new Date());
            log.debug((Object)"sending from servlet");
            Transport.send((Message)msg);
        }
        catch (AddressException e) {
            status = "Please supply a valid email address.";
            log.debug((Object)("Error - status is " + status));
        }
        catch (SendFailedException e) {
            status = "The system was unable to deliver your mail.  Please try again later.  [SEND FAILED]";
            log.error((Object)("Error - status is " + status));
        }
        catch (MessagingException e) {
            status = "The system was unable to deliver your mail.  Please try again later.  [MESSAGING]";
            log.error((Object)("Error - status is " + status), (Throwable)e);
        }
        if (status == null && !probablySpam) {
            response.sendRedirect("test?bodyJsp=" + confirmpage);
        } else {
            response.sendRedirect("test?bodyJsp=" + errpage + "&ERR=" + status);
        }
    }

    private List<String> getEmailsForAllUserAccounts(VitroRequest vreq) {
        UserAccountsDao uaDao = vreq.getWebappDaoFactory().getUserAccountsDao();
        ArrayList<String> emails = new ArrayList<String>();
        for (UserAccount user : uaDao.getAllUserAccounts()) {
            emails.add(user.getEmailAddress());
        }
        return emails;
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public String stripProtocol(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("http://", "host: ");
    }
}

