/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.usepages.ManageRootAccount;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsEditPageStrategy;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsProfileCreator;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsUserController;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsEditPage
extends UserAccountsPage {
    private static final Log log = LogFactory.getLog(UserAccountsEditPage.class);
    private static final String PARAMETER_SUBMIT = "submitEdit";
    private static final String PARAMETER_USER_URI = "editAccount";
    private static final String PARAMETER_EMAIL_ADDRESS = "emailAddress";
    private static final String PARAMETER_EXTERNAL_AUTH_ID = "externalAuthId";
    private static final String PARAMETER_EXTERNAL_AUTH_ONLY = "externalAuthOnly";
    private static final String PARAMETER_FIRST_NAME = "firstName";
    private static final String PARAMETER_LAST_NAME = "lastName";
    private static final String PARAMETER_ROLE = "role";
    private static final String PARAMETER_ASSOCIATED_PROFILE_URI = "associatedProfileUri";
    private static final String PARAMETER_NEW_PROFILE_CLASS_URI = "newProfileClassUri";
    private static final String ERROR_NO_EMAIL = "errorEmailIsEmpty";
    private static final String ERROR_EMAIL_IN_USE = "errorEmailInUse";
    private static final String ERROR_EMAIL_INVALID_FORMAT = "errorEmailInvalidFormat";
    private static final String ERROR_EXTERNAL_AUTH_ID_IN_USE = "errorExternalAuthIdInUse";
    private static final String ERROR_NO_FIRST_NAME = "errorFirstNameIsEmpty";
    private static final String ERROR_NO_LAST_NAME = "errorLastNameIsEmpty";
    private static final String ERROR_NO_ROLE = "errorNoRoleSelected";
    private static final String TEMPLATE_NAME = "userAccounts-edit.ftl";
    private final UserAccountsEditPageStrategy strategy;
    private final boolean matchingIsEnabled;
    private boolean submit;
    private String userUri = "";
    private String emailAddress = "";
    private String externalAuthId = "";
    private boolean externalAuthOnly;
    private String firstName = "";
    private String lastName = "";
    private Collection<String> selectedRoleUris = new ArrayList<String>();
    private String associatedProfileUri = "";
    private String newProfileClassUri = "";
    private UserAccount userAccount;
    private String bogusMessage = "";
    private String errorCode = "";

    public UserAccountsEditPage(VitroRequest vreq) {
        super(vreq);
        this.strategy = UserAccountsEditPageStrategy.getInstance(vreq, this, this.isEmailEnabled());
        this.matchingIsEnabled = SelfEditingConfiguration.getBean((ServletRequest)vreq).isConfigured();
        this.parseRequestParameters();
        this.validateUserAccountInfo();
        if (this.isSubmit() && !this.isBogus()) {
            this.validateParameters();
        }
    }

    private void parseRequestParameters() {
        this.submit = this.isFlagOnRequest(PARAMETER_SUBMIT);
        this.userUri = this.getStringParameter(PARAMETER_USER_URI, "");
        this.emailAddress = this.getStringParameter(PARAMETER_EMAIL_ADDRESS, "");
        this.externalAuthId = this.getStringParameter(PARAMETER_EXTERNAL_AUTH_ID, "");
        this.externalAuthOnly = this.isFlagOnRequest(PARAMETER_EXTERNAL_AUTH_ONLY);
        this.firstName = this.getStringParameter(PARAMETER_FIRST_NAME, "");
        this.lastName = this.getStringParameter(PARAMETER_LAST_NAME, "");
        this.selectedRoleUris = this.getStringParameters(PARAMETER_ROLE);
        this.associatedProfileUri = this.getStringParameter(PARAMETER_ASSOCIATED_PROFILE_URI, "");
        this.newProfileClassUri = this.getStringParameter(PARAMETER_NEW_PROFILE_CLASS_URI, "");
        this.strategy.parseAdditionalParameters();
    }

    private void validateUserAccountInfo() {
        this.userAccount = this.userAccountsDao.getUserAccountByUri(this.userUri);
        if (this.userAccount == null) {
            log.warn((Object)("Edit account for '" + this.userUri + "' is bogus: no such user"));
            this.bogusMessage = UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)this.vreq);
            return;
        }
        if (this.userAccount.isRootUser() && !PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{new ManageRootAccount()})) {
            log.warn((Object)("User is attempting to edit the root account, but is not authorized to do so. Logged in as: " + LoginStatusBean.getCurrentUser((HttpServletRequest)this.vreq)));
            this.bogusMessage = UserAccountsUserController.getBogusStandardMessage((HttpServletRequest)this.vreq);
            return;
        }
    }

    public boolean isBogus() {
        return !this.bogusMessage.isEmpty();
    }

    public String getBogusMessage() {
        return this.bogusMessage;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    private void validateParameters() {
        this.errorCode = this.emailAddress.isEmpty() ? ERROR_NO_EMAIL : (this.emailIsChanged() && this.isEmailInUse() ? ERROR_EMAIL_IN_USE : (!this.isEmailValidFormat() ? ERROR_EMAIL_INVALID_FORMAT : (this.externalAuthIdIsChanged() && this.isExternalAuthIdInUse() ? ERROR_EXTERNAL_AUTH_ID_IN_USE : (this.firstName.isEmpty() ? ERROR_NO_FIRST_NAME : (this.lastName.isEmpty() ? ERROR_NO_LAST_NAME : (!this.isRootUser() && this.selectedRoleUris.isEmpty() ? ERROR_NO_ROLE : this.strategy.additionalValidations()))))));
    }

    private boolean emailIsChanged() {
        return !this.emailAddress.equals(this.userAccount.getEmailAddress());
    }

    private boolean isEmailInUse() {
        return this.userAccountsDao.getUserAccountByEmail(this.emailAddress) != null;
    }

    private boolean isEmailValidFormat() {
        return Authenticator.isValidEmailAddress(this.emailAddress);
    }

    private boolean externalAuthIdIsChanged() {
        return !this.externalAuthId.equals(this.userAccount.getExternalAuthId());
    }

    private boolean isExternalAuthIdInUse() {
        if (this.externalAuthId.isEmpty()) {
            return false;
        }
        return this.userAccountsDao.getUserAccountByExternalAuthId(this.externalAuthId) != null;
    }

    private boolean isRootUser() {
        return this.userAccount != null && this.userAccount.isRootUser();
    }

    public boolean isValid() {
        return this.errorCode.isEmpty();
    }

    public final ResponseValues showPage() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userUri", this.userUri);
        if (this.isSubmit()) {
            body.put(PARAMETER_EMAIL_ADDRESS, this.emailAddress);
            body.put(PARAMETER_EXTERNAL_AUTH_ID, this.externalAuthId);
            body.put(PARAMETER_FIRST_NAME, this.firstName);
            body.put(PARAMETER_LAST_NAME, this.lastName);
            body.put("selectedRoles", this.selectedRoleUris);
            body.put(PARAMETER_NEW_PROFILE_CLASS_URI, this.newProfileClassUri);
            if (this.externalAuthOnly) {
                body.put(PARAMETER_EXTERNAL_AUTH_ONLY, Boolean.TRUE);
            }
            if (!this.associatedProfileUri.isEmpty()) {
                body.put("associatedProfileInfo", this.buildProfileInfo(this.associatedProfileUri));
            }
        } else {
            List<Individual> associatedInds;
            body.put(PARAMETER_EMAIL_ADDRESS, this.userAccount.getEmailAddress());
            body.put(PARAMETER_EXTERNAL_AUTH_ID, this.userAccount.getExternalAuthId());
            body.put(PARAMETER_FIRST_NAME, this.userAccount.getFirstName());
            body.put(PARAMETER_LAST_NAME, this.userAccount.getLastName());
            body.put("selectedRoles", this.userAccount.getPermissionSetUris());
            body.put(PARAMETER_NEW_PROFILE_CLASS_URI, "");
            if (this.userAccount.isExternalAuthOnly()) {
                body.put(PARAMETER_EXTERNAL_AUTH_ONLY, Boolean.TRUE);
            }
            if (!(associatedInds = SelfEditingConfiguration.getBean((ServletRequest)this.vreq).getAssociatedIndividuals(this.indDao, this.userAccount)).isEmpty()) {
                body.put("associatedProfileInfo", this.buildProfileInfo(associatedInds.get(0).getURI()));
            }
        }
        if (!this.isRootUser()) {
            body.put("roles", this.buildListOfSelectableRoles());
            body.put("externalAuthPermitted", Boolean.TRUE);
        }
        body.put("profileTypes", this.buildProfileTypesList());
        body.put("formUrls", this.buildUrlsMapWithEditUrl());
        if (!this.errorCode.isEmpty()) {
            body.put(this.errorCode, Boolean.TRUE);
        }
        if (this.matchingIsEnabled) {
            body.put("showAssociation", Boolean.TRUE);
        }
        this.strategy.addMoreBodyValues(body);
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private Map<String, String> buildUrlsMapWithEditUrl() {
        Map<String, String> map = this.buildUrlsMap();
        map.put("edit", UserAccountsEditPage.editAccountUrl(this.userAccount.getUri()));
        return map;
    }

    public void updateAccount() {
        this.userAccount.setEmailAddress(this.emailAddress);
        this.userAccount.setFirstName(this.firstName);
        this.userAccount.setLastName(this.lastName);
        this.userAccount.setExternalAuthId(this.externalAuthId);
        if (this.externalAuthOnly) {
            this.userAccount.setMd5Password("");
            this.userAccount.setOldPassword("");
            this.userAccount.setPasswordChangeRequired(false);
            this.userAccount.setPasswordLinkExpires(0L);
        }
        if (this.isRootUser()) {
            this.userAccount.setPermissionSetUris(Collections.emptySet());
            this.userAccount.setExternalAuthOnly(false);
        } else {
            this.userAccount.setPermissionSetUris(this.selectedRoleUris);
            this.userAccount.setExternalAuthOnly(this.externalAuthOnly);
        }
        this.strategy.setAdditionalProperties(this.userAccount);
        this.userAccountsDao.updateUserAccount(this.userAccount);
        if (this.matchingIsEnabled) {
            if (!this.newProfileClassUri.isEmpty()) {
                try {
                    String newProfileUri;
                    this.associatedProfileUri = newProfileUri = UserAccountsProfileCreator.createProfile(this.indDao, this.dpsDao, this.newProfileClassUri, this.userAccount);
                }
                catch (InsertException e) {
                    log.error((Object)("Failed to create new profile of class '" + this.newProfileClassUri + "' for user '" + this.userAccount.getEmailAddress() + "'"));
                }
            }
            SelfEditingConfiguration.getBean((ServletRequest)this.vreq).associateIndividualWithUserAccount(this.indDao, this.dpsDao, this.userAccount, this.associatedProfileUri);
        }
        this.strategy.notifyUser();
    }

    public boolean wasPasswordEmailSent() {
        return this.strategy.wasPasswordEmailSent();
    }

    public UserAccount getUpdatedAccount() {
        return this.userAccount;
    }

    boolean isExternalAuthOnly() {
        return this.externalAuthOnly;
    }
}

