/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.AbstractDumpRestoreAction;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpQuad;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpRestoreController;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpTriple;
import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.NquadsParser;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestoreModelsAction
extends AbstractDumpRestoreAction {
    private static final Log log = LogFactory.getLog(RestoreModelsAction.class);
    private static final String DEFAULT_GRAPH_URI = "__default__";
    private final FileItem sourceFile = this.getFileItem("sourceFile");
    private final ModelAccess.WhichService which = this.getEnumFromParameter(ModelAccess.WhichService.class, "which");
    private final boolean purge;
    private final SelfLimitingTripleBuckets bnodeBuckets;
    private final SelfLimitingTripleBuckets easyBuckets;
    private long tripleCount;

    RestoreModelsAction(HttpServletRequest req, HttpServletResponse resp) throws DumpRestoreController.BadRequestException {
        super(req);
        this.purge = null != req.getParameter("purge");
        this.bnodeBuckets = new SelfLimitingTripleBuckets(this, 1000000);
        this.easyBuckets = new SelfLimitingTripleBuckets(this, 10000);
    }

    private FileItem getFileItem(String key) throws DumpRestoreController.BadRequestException {
        FileItem fileItem = new VitroRequest(this.req).getFileItem(key);
        if (fileItem == null) {
            throw new DumpRestoreController.BadRequestException("Request has no file item named '" + key + "'");
        }
        return fileItem;
    }

    long restoreModels() throws IOException, RDFServiceException {
        this.purgeIfRequested();
        return this.doTheRestore();
    }

    private void purgeIfRequested() throws RDFServiceException {
        if (!this.purge) {
            return;
        }
        log.info((Object)("Purging the " + this.which + " models."));
        RDFService rdfService = this.getRdfService(this.which);
        RDFServiceDataset dataset = new RDFServiceDataset(rdfService);
        for (String graphUri : rdfService.getGraphURIs()) {
            Model m = dataset.getNamedModel(graphUri);
            log.info((Object)("Remove " + m.size() + " triples from " + graphUri));
            m.removeAll();
        }
        log.info((Object)"Purge is complete.");
    }

    private long doTheRestore() throws IOException, RDFServiceException {
        log.info((Object)("Restoring the " + this.which + " models."));
        long lineCount = 0L;
        try (InputStream is = this.sourceFile.getInputStream();
             NquadsParser p = new NquadsParser(is);){
            for (DumpQuad line : p) {
                this.bucketize(line);
                if (++lineCount % 10000L != 0L) continue;
                log.info((Object)("read " + lineCount + " lines."));
            }
            this.emptyBuckets();
        }
        log.info((Object)"Restore is complete.");
        return lineCount;
    }

    private void bucketize(DumpQuad quad) throws IOException, RDFServiceException {
        DumpTriple triple = quad.getTriple();
        if (triple.getS().isBlank() || triple.getO().isBlank()) {
            this.bnodeBuckets.add(quad.getG().getValue(), triple);
        } else {
            this.easyBuckets.add(quad.getG().getValue(), triple);
        }
    }

    private void emptyBuckets() throws IOException, RDFServiceException {
        for (String key : this.easyBuckets.getKeys()) {
            this.processTriples(key, this.easyBuckets.getTriples(key));
        }
        for (String key : this.bnodeBuckets.getKeys()) {
            this.processTriples(key, this.bnodeBuckets.getTriples(key));
        }
    }

    private void processTriples(String graphUri, Collection<DumpTriple> triples) throws IOException, RDFServiceException {
        if (graphUri.equals(DEFAULT_GRAPH_URI)) {
            graphUri = null;
        }
        RDFService rdfService = this.getRdfService(this.which);
        ChangeSet change = rdfService.manufactureChangeSet();
        change.addAddition(this.serialize(triples), RDFService.ModelSerializationFormat.NTRIPLE, graphUri);
        rdfService.changeSetUpdate(change);
        this.tripleCount += (long)triples.size();
        log.info((Object)("processed " + this.tripleCount + " triples."));
    }

    private InputStream serialize(Collection<DumpTriple> triples) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
        for (DumpTriple triple : triples) {
            w.write(triple.toNtriples());
        }
        ((Writer)w).close();
        return new ByteArrayInputStream(out.toByteArray());
    }

    private static class SelfLimitingTripleBuckets {
        private final RestoreModelsAction parent;
        private final int sizeLimit;
        private final Map<String, List<DumpTriple>> map = new HashMap<String, List<DumpTriple>>();

        public SelfLimitingTripleBuckets(RestoreModelsAction parent, int sizeLimit) {
            this.parent = parent;
            this.sizeLimit = sizeLimit;
        }

        public void add(String key, DumpTriple triple) throws IOException, RDFServiceException {
            if (!this.map.containsKey(key = this.nonNull(key, RestoreModelsAction.DEFAULT_GRAPH_URI))) {
                this.map.put(key, new ArrayList());
            }
            this.map.get(key).add(triple);
            if (this.map.get(key).size() > this.sizeLimit) {
                this.parent.processTriples(key, this.map.remove(key));
            }
        }

        public Set<String> getKeys() {
            return this.map.keySet();
        }

        public List<DumpTriple> getTriples(String key) {
            if (this.map.containsKey(key = this.nonNull(key, RestoreModelsAction.DEFAULT_GRAPH_URI))) {
                return this.map.get(key);
            }
            return Collections.emptyList();
        }

        private String nonNull(String value, String defaultValue) {
            return value == null ? defaultValue : value;
        }
    }
}

