/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstanceIface;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectPropertyStatementRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)ObjectPropertyStatementRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.DO_BACK_END_EDITING.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        EditProcessObject epo = super.createEpo(request);
        epo.setBeanClass(PropertyInstanceIface.class);
        Class[] classarray = new Class[]{PropertyInstanceIface.class};
        try {
            epo.setInsertMethod(PropertyInstanceDao.class.getMethod("insertProp", classarray));
            epo.setUpdateMethod(epo.getInsertMethod());
        }
        catch (NoSuchMethodException nsme) {
            log.error((Object)("Unable to find " + PropertyInstanceDao.class.getName() + ".insertProp(" + PropertyInstanceIface.class.getName() + ")"));
        }
        try {
            epo.setDeleteMethod(PropertyInstanceDao.class.getMethod("deletePropertyInstance", classarray));
        }
        catch (NoSuchMethodException nsme) {
            log.error((Object)("Unable to find " + PropertyInstanceDao.class.getName() + ".deletePropertyInstance(" + PropertyInstanceIface.class.getName() + ")"));
        }
        String action = "insert";
        PropertyInstanceDao piDao = vreq.getUnfilteredWebappDaoFactory().getPropertyInstanceDao();
        epo.setDataAccessObject(piDao);
        ObjectPropertyDao pDao = vreq.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        IndividualDao eDao = vreq.getUnfilteredWebappDaoFactory().getIndividualDao();
        VClassDao vcDao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        PropertyInstance objectForEditing = null;
        if (!epo.getUseRecycledBean()) {
            objectForEditing = new PropertyInstance();
            this.populateBeanFromParams(objectForEditing, (HttpServletRequest)vreq);
            if (vreq.getParameter("multiplexedParam") != null) {
                action = "update";
            }
            epo.setOriginalBean(objectForEditing);
        } else {
            objectForEditing = (PropertyInstance)epo.getNewBean();
        }
        FormObject foo = new FormObject();
        ObjectProperty p = pDao.getObjectPropertyByURI(objectForEditing.getPropertyURI());
        if (p != null) {
            foo.getValues().put("Prop", p.getDomainPublic());
        } else {
            foo.getValues().put("Prop", "The property must be specified.");
        }
        HashMap<String, List<Option>> optionMap = new HashMap<String, List<Option>>();
        String domainEntityName = "";
        String rangeEntityName = "";
        Individual domainEntity = eDao.getIndividualByURI(objectForEditing.getSubjectEntURI());
        LinkedList<Option> domainOptionList = new LinkedList<Option>();
        Individual subjectInd = eDao.getIndividualByURI(objectForEditing.getSubjectEntURI());
        if (subjectInd != null) {
            Option option = new Option(subjectInd.getURI(), subjectInd.getName());
        }
        domainOptionList.add(new Option(domainEntity.getURI(), domainEntity.getName(), true));
        optionMap.put("SubjectEntURI", domainOptionList);
        List<VClass> possibleClasses = vcDao.getVClassesForProperty(domainEntity.getVClassURI(), objectForEditing.getPropertyURI());
        Iterator<VClass> possIt = possibleClasses.iterator();
        HashSet<Individual> possIndSet = new HashSet<Individual>();
        while (possIt.hasNext()) {
            VClass possClass = possIt.next();
            List<Individual> possibleIndividuals = eDao.getIndividualsByVClass(possClass);
            possIndSet.addAll(possibleIndividuals);
        }
        LinkedList<Individual> indList = new LinkedList<Individual>();
        indList.addAll(possIndSet);
        this.sortForPickList(indList, vreq);
        LinkedList<Option> objectEntOptionList = new LinkedList<Option>();
        for (Individual objInd : indList) {
            Option objIndOpt = new Option(objInd.getURI(), objInd.getName());
            if (objectForEditing.getObjectEntURI() != null && objectForEditing.getObjectEntURI().equals(objInd.getURI())) {
                objIndOpt.setSelected(true);
            }
            objectEntOptionList.add(objIndOpt);
        }
        if (objectEntOptionList.size() == 0) {
            objectEntOptionList.add(new Option("", "There are no individuals yet defined that could fill this role."));
        }
        optionMap.put("ObjectEntURI", objectEntOptionList);
        foo.setOptionLists(optionMap);
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(objectForEditing, action, foo);
        RequestDispatcher rd = request.getRequestDispatcher("/templates/page/basicPage.jsp");
        request.setAttribute("bodyJsp", (Object)"/templates/edit/formBasic.jsp");
        request.setAttribute("formJsp", (Object)"/templates/edit/specific/ents2ents_retry_domainSide.jsp");
        request.setAttribute("scripts", (Object)"/templates/edit/formBasic.js");
        request.setAttribute("title", (Object)"Object Property Instance Editing Form");
        request.setAttribute("_action", (Object)action);
        request.setAttribute("unqualifiedClassName", (Object)"ObjectPropertyStatement");
        this.setRequestAttributes(request, epo);
        try {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error((Object)"ObjectPropertyStatementRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }
}

