/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Properties2PropertiesOperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)Properties2PropertiesOperationController.class.getName());
    private static final boolean ADD = false;
    private static final boolean REMOVE = true;

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        block21: {
            if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
                return;
            }
            String defaultLandingPage = this.getDefaultLandingPage(req);
            try {
                String referer;
                VitroRequest request = new VitroRequest(req);
                HashMap epoHash = null;
                EditProcessObject epo = null;
                try {
                    epoHash = (HashMap)request.getSession().getAttribute("epoHash");
                    epo = (EditProcessObject)epoHash.get(request.getParameter("_epoKey"));
                }
                catch (NullPointerException e) {
                    try {
                        response.sendRedirect(defaultLandingPage);
                    }
                    catch (IOException f) {
                        log.error((Object)f, (Throwable)f);
                        throw new RuntimeException(f);
                    }
                    return;
                }
                if (epo == null) {
                    log.debug((Object)"null epo");
                    try {
                        response.sendRedirect(defaultLandingPage);
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    return;
                }
                String modeStr = request.getParameter("opMode");
                modeStr = modeStr == null ? "" : modeStr;
                String operationStr = request.getParameter("operation");
                boolean operation = false;
                if ("add".equals(operationStr)) {
                    operation = false;
                } else if ("remove".equals(operationStr)) {
                    operation = true;
                } else {
                    throw new IllegalArgumentException("request parameter 'operation' must have value 'add' or 'remove'");
                }
                if (request.getParameter("_cancel") == null) {
                    this.doEdit(modeStr, operation, request);
                }
                if ((referer = epo.getReferer()) == null) {
                    try {
                        response.sendRedirect(defaultLandingPage);
                        break block21;
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                try {
                    response.sendRedirect(referer);
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"Unable to perform edit operation: ", (Throwable)e);
                throw e;
            }
            catch (Error err) {
                log.error((Object)"Unable to perform edit operation: ", (Throwable)err);
                throw err;
            }
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String defaultLandingPage = this.getDefaultLandingPage(request);
        try {
            response.sendRedirect(defaultLandingPage);
        }
        catch (IOException e) {
            log.error((Object)"Unable to redirect to default landing page", (Throwable)e);
        }
    }

    private void doEdit(String modeStr, boolean operation, VitroRequest request) {
        ObjectPropertyDao opDao = request.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        if (operation) {
            String[] subpropertyURIstrs = request.getParameterValues("SubpropertyURI");
            if (subpropertyURIstrs != null && subpropertyURIstrs.length > 1) {
                String superpropertyURIstr = request.getParameter("SuperpropertyURI");
                if (superpropertyURIstr != null) {
                    for (int i = 0; i < subpropertyURIstrs.length; ++i) {
                        if (modeStr.equals("equivalentProperty")) {
                            opDao.removeEquivalentProperty(superpropertyURIstr, subpropertyURIstrs[i]);
                            continue;
                        }
                        opDao.removeSuperproperty(subpropertyURIstrs[i], superpropertyURIstr);
                    }
                }
            } else {
                String subpropertyURIstr = subpropertyURIstrs[0];
                String[] superpropertyURIstrs = request.getParameterValues("SuperpropertyURI");
                if (superpropertyURIstrs != null) {
                    for (int i = 0; i < superpropertyURIstrs.length; ++i) {
                        if (modeStr.equals("equivalentProperty")) {
                            opDao.removeEquivalentProperty(subpropertyURIstr, superpropertyURIstrs[i]);
                            continue;
                        }
                        opDao.removeSuperproperty(subpropertyURIstr, superpropertyURIstrs[i]);
                    }
                }
            }
        } else if (!operation) {
            if (modeStr.equals("equivalentProperty")) {
                opDao.addEquivalentProperty(request.getParameter("SuperpropertyURI"), request.getParameter("SubpropertyURI"));
            } else {
                opDao.addSuperproperty(request.getParameter("SubpropertyURI"), request.getParameter("SuperpropertyURI"));
            }
        }
    }
}

