/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeletePropertyController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(DeletePropertyController.class);

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        String errorMessage = this.handleErrors(vreq);
        if (errorMessage != null) {
            return this.doErrorMessage(errorMessage);
        }
        if (EditConfigurationUtils.isObjectProperty(EditConfigurationUtils.getPredicateUri(vreq), vreq)) {
            this.processObjectProperty(vreq);
        } else {
            this.processDataProperty(vreq);
        }
        String redirectUrl = this.getRedirectUrl(vreq);
        return new RedirectResponseValues(redirectUrl, 303);
    }

    private String getRedirectUrl(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        int hashIndex = predicateUri.lastIndexOf("#");
        String localName = predicateUri.substring(hashIndex + 1);
        String redirectUrl = "/entity?uri=" + URLEncoder.encode(subjectUri);
        return redirectUrl + "#" + URLEncoder.encode(localName);
    }

    private String handleErrors(VitroRequest vreq) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        if (wdf == null) {
            return "could not get a WebappDaoFactory";
        }
        Individual subject = EditConfigurationUtils.getSubjectIndividual(vreq);
        if (subject == null) {
            return "could not find subject " + EditConfigurationUtils.getSubjectUri(vreq);
        }
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        if (EditConfigurationUtils.isObjectProperty(predicateUri, vreq)) {
            ObjectProperty prop = EditConfigurationUtils.getObjectProperty(vreq);
            if (prop == null) {
                return "In delete property controller, could not find object property " + predicateUri;
            }
        } else {
            DataProperty prop = this.getDataProperty(vreq);
            if (prop == null) {
                return "In delete property controller, could not find data property " + predicateUri;
            }
        }
        return null;
    }

    private DataProperty getDataProperty(VitroRequest vreq) {
        String editorUri = N3EditUtils.getEditorUri((HttpServletRequest)vreq);
        WebappDaoFactory wdf = vreq.getWebappDaoFactory().getUserAwareDaoFactory(editorUri);
        DataProperty prop = wdf.getDataPropertyDao().getDataPropertyByURI(EditConfigurationUtils.getPredicateUri(vreq));
        return prop;
    }

    private TemplateResponseValues doErrorMessage(String errorMessage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorMessage", errorMessage);
        return new TemplateResponseValues("error-message.ftl", map);
    }

    private void processDataProperty(VitroRequest vreq) {
        this.deleteDataPropertyStatement(vreq);
    }

    private void deleteDataPropertyStatement(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        int dataHash = EditConfigurationUtils.getDataHash(vreq);
        DataPropertyStatement dps = EditConfigurationUtils.getDataPropertyStatement(vreq, vreq.getSession(), dataHash, predicateUri);
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        if (dps != null) {
            this.logDataPropertyDeletionMessages(dps);
            this.processDataPropertyStatement(dps, subjectUri, predicateUri);
            wdf.getDataPropertyStatementDao().deleteDataPropertyStatement(dps);
        }
    }

    private void processDataPropertyStatement(DataPropertyStatement dps, String subjectUri, String predicateUri) {
        if (dps.getIndividualURI() == null || dps.getIndividualURI().trim().length() == 0) {
            log.debug((Object)"adding missing subjectURI to DataPropertyStatement");
            dps.setIndividualURI(subjectUri);
        }
        if (dps.getDatapropURI() == null || dps.getDatapropURI().trim().length() == 0) {
            log.debug((Object)"adding missing datapropUri to DataPropertyStatement");
            dps.setDatapropURI(predicateUri);
        }
    }

    private void logDataPropertyDeletionMessages(DataPropertyStatement dps) {
        log.debug((Object)("attempting to delete dataPropertyStatement: subjectURI <" + dps.getIndividualURI() + ">"));
        log.debug((Object)("predicateURI <" + dps.getDatapropURI() + ">"));
        log.debug((Object)("literal \"" + dps.getData() + "\""));
        log.debug((Object)("lang @" + (dps.getLanguage() == null ? "null" : dps.getLanguage())));
        log.debug((Object)("datatype ^^" + (dps.getDatatypeURI() == null ? "null" : dps.getDatatypeURI())));
    }

    private void processObjectProperty(VitroRequest vreq) {
        ObjectProperty prop = EditConfigurationUtils.getObjectProperty(vreq);
        if (prop.getStubObjectRelation() || this.hasDeleteObjectUri(vreq)) {
            this.deleteObjectIndividual(vreq);
        }
        if (!this.hasDeleteObjectUri(vreq)) {
            this.deleteObjectPropertyStatement(vreq);
        }
    }

    private void deleteObjectPropertyStatement(VitroRequest vreq) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        wdf.getPropertyInstanceDao().deleteObjectPropertyStatement(subjectUri, predicateUri, objectUri);
    }

    private Individual getObjectIndividualForDeletion(VitroRequest vreq, String objectUri) {
        Individual object = EditConfigurationUtils.getIndividual(vreq, objectUri);
        if (object == null) {
            WebappDaoFactory wadf = ModelAccess.on(vreq.getSession().getServletContext()).getWebappDaoFactory();
            object = wadf.getIndividualDao().getIndividualByURI(objectUri);
        }
        return object;
    }

    private void deleteObjectIndividual(VitroRequest vreq) {
        Individual object;
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        if (this.hasDeleteObjectUri(vreq)) {
            objectUri = this.getDeleteObjectUri(vreq);
        }
        if ((object = this.getObjectIndividualForDeletion(vreq, objectUri)) != null) {
            log.warn((Object)("Deleting individual " + object.getName() + "since property has been set to force range object deletion or has been set to delete a specific object"));
            WebappDaoFactory wdf = vreq.getWebappDaoFactory();
            wdf.getIndividualDao().deleteIndividual(object);
        } else {
            log.error((Object)("could not find object as request attribute or in model " + objectUri));
        }
    }

    private String getDeleteObjectUri(VitroRequest vreq) {
        return vreq.getParameter("deleteObjectUri");
    }

    private boolean hasDeleteObjectUri(VitroRequest vreq) {
        String deleteObjectUri = this.getDeleteObjectUri(vreq);
        return deleteObjectUri != null && !deleteObjectUri.isEmpty();
    }
}

