/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.GetSearchIndividualsByVClasses;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewService;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewServiceSetup;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.IndividualTemplateModelBuilder;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetRenderedSearchIndividualsByVClass
extends GetSearchIndividualsByVClasses {
    private static final Log log = LogFactory.getLog(GetRenderedSearchIndividualsByVClass.class);

    protected GetRenderedSearchIndividualsByVClass(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected JSONObject process() throws Exception {
        JSONObject rObj = null;
        List<String> vclassIds = super.getVclassIds(this.vreq);
        String vclassId = null;
        vclassId = vclassIds.size() > 1 ? vclassIds.get(1) : vclassIds.get(0);
        this.vreq.setAttribute("displayType", vclassId);
        rObj = super.process();
        this.addShortViewRenderings(rObj);
        return rObj;
    }

    private void addShortViewRenderings(JSONObject rObj) throws JSONException {
        JSONArray individuals = rObj.getJSONArray("individuals");
        String vclassName = rObj.getJSONObject("vclass").getString("name");
        for (int i = 0; i < individuals.length(); ++i) {
            JSONObject individual = individuals.getJSONObject(i);
            individual.put("shortViewHtml", this.renderShortView(individual.getString("URI"), vclassName));
        }
    }

    private String renderShortView(String individualUri, String vclassName) {
        IndividualDao iDao = this.vreq.getWebappDaoFactory().getIndividualDao();
        Individual individual = iDao.getIndividualByURI(individualUri);
        HashMap<String, Object> modelMap = new HashMap<String, Object>();
        modelMap.put("individual", IndividualTemplateModelBuilder.build(individual, this.vreq));
        modelMap.put("vclass", vclassName);
        ShortViewService svs = ShortViewServiceSetup.getService(this.ctx);
        return svs.renderShortView(individual, ShortViewService.ShortViewContext.BROWSE, modelMap, this.vreq);
    }
}

