/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.CannotCreateException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.ibm.icu.text.Collator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceModelMaker
implements ModelMaker {
    private static final Log log = LogFactory.getLog(RDFServiceModelMaker.class);
    private RDFService service;
    private RDFServiceDataset dataset;

    public RDFServiceModelMaker(RDFService service) {
        this.service = service;
        this.dataset = new RDFServiceDataset(service);
    }

    public void close() {
        this.dataset.close();
    }

    public Model createModel(String name) {
        Model model = this.getModel(name);
        if (model == null) {
            throw new CannotCreateException(name);
        }
        return model;
    }

    public Model createModel(String name, boolean strict) {
        if (this.hasModel(name) && strict) {
            throw new AlreadyExistsException(name);
        }
        return this.createModel(name);
    }

    public GraphMaker getGraphMaker() {
        throw new UnsupportedOperationException("GraphMaker not supported by " + this.getClass().getName());
    }

    private Set<String> getModelNames() {
        try {
            TreeSet<String> names = new TreeSet<String>((Comparator<String>)Collator.getInstance());
            names.addAll(this.service.getGraphURIs());
            return names;
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasModel(String name) {
        return this.getModelNames().contains(name);
    }

    public ExtendedIterator<String> listModels() {
        return WrappedIterator.create(this.getModelNames().iterator());
    }

    public Model openModel(String name, boolean strict) {
        if (strict && !this.hasModel(name)) {
            throw new DoesNotExistException(name);
        }
        return this.getModel(name);
    }

    public void removeModel(String name) {
        Model m = this.getModel(name);
        m.removeAll(null, null, null);
    }

    public Model createDefaultModel() {
        return this.dataset.getDefaultModel();
    }

    public Model createFreshModel() {
        throw new UnsupportedOperationException("createFreshModel not supported by " + this.getClass().getName());
    }

    public Model openModel(String name) {
        Model m = this.getModel(name);
        if (m == null) {
            throw new DoesNotExistException(name);
        }
        return m;
    }

    public Model openModelIfPresent(String name) {
        if (this.hasModel(name)) {
            return this.getModel(name);
        }
        return null;
    }

    public Model getModel(String name, ModelReader loadIfNotAbsent) {
        Model m = this.getModel(name);
        if (m == null) {
            throw new CannotCreateException(name);
        }
        return m;
    }

    public Model getModel(String name) {
        if (name == null) {
            return null;
        }
        return this.dataset.getNamedModel(name);
    }

    public String toString() {
        return "RDFServiceModelMaker[service=" + this.service + "]";
    }
}

