/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.modelaccess.adapters;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.AbstractModelMakerDecorator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.MemoryMappedModel;
import java.util.HashMap;
import java.util.Map;

public class MemoryMappingModelMaker
extends AbstractModelMakerDecorator {
    private final Map<String, Model> mappedModels = new HashMap<String, Model>();

    public MemoryMappingModelMaker(ModelMaker inner, String ... modelUrisForMapping) {
        super(inner);
        for (String name : modelUrisForMapping) {
            this.mappedModels.put(name, this.createMemoryMapping(name));
        }
    }

    private Model createMemoryMapping(String name) {
        return new MemoryMappedModel(super.openModel(name), name);
    }

    private boolean isMapped(String name) {
        return this.mappedModels.containsKey(name);
    }

    private Model getMapped(String name) {
        return this.mappedModels.get(name);
    }

    @Override
    public Model openModel(String name) {
        return this.isMapped(name) ? this.getMapped(name) : super.openModel(name);
    }

    @Override
    public Model openModelIfPresent(String name) {
        return this.isMapped(name) ? this.getMapped(name) : super.openModelIfPresent(name);
    }

    @Override
    public Model getModel(String name) {
        return this.isMapped(name) ? this.getMapped(name) : super.getModel(name);
    }

    @Override
    public Model getModel(String name, ModelReader loadIfAbsent) {
        return this.isMapped(name) ? this.getMapped(name) : super.getModel(name, loadIfAbsent);
    }

    @Override
    public Model createModel(String name, boolean strict) {
        if (this.isMapped(name)) {
            if (strict) {
                throw new AlreadyExistsException(name);
            }
            return this.getMapped(name);
        }
        return super.createModel(name, strict);
    }

    @Override
    public Model createModel(String name) {
        return this.isMapped(name) ? this.getMapped(name) : super.createModel(name);
    }

    @Override
    public Model openModel(String name, boolean strict) {
        return this.isMapped(name) ? this.getMapped(name) : super.openModel(name, strict);
    }

    @Override
    public void removeModel(String name) {
        if (this.isMapped(name)) {
            Model m = this.mappedModels.remove(name);
            m.close();
        }
        super.removeModel(name);
    }
}

