/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.sparql;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.ChangeSetImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.ResultSetIterators;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.jena.riot.RDFDataMgr;

public class RDFServiceSparql
extends RDFServiceImpl
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceImpl.class);
    protected String readEndpointURI;
    protected String updateEndpointURI;
    private static final int CHUNK_SIZE = 5000;
    protected HttpClient httpClient;
    protected boolean rebuildGraphURICache = true;
    private List<String> graphURIs = null;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;
    private static final boolean WHERE_CLAUSE = true;

    public RDFServiceSparql(String readEndpointURI, String updateEndpointURI, String defaultWriteGraphURI) {
        this.readEndpointURI = readEndpointURI;
        this.updateEndpointURI = updateEndpointURI;
        this.httpClient = HttpClientFactory.getHttpClient();
        if (RDFServiceSparql.class.getName().equals(this.getClass().getName())) {
            this.testConnection();
        }
    }

    protected void testConnection() {
        try {
            this.sparqlSelectQuery("SELECT ?s WHERE { ?s a <http://vitro.mannlib.cornell.edu/ns/vitro/nonsense/> }", RDFService.ResultFormat.JSON);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to connect to endpoint at " + this.readEndpointURI, e);
        }
    }

    public RDFServiceSparql(String readEndpointURI, String updateEndpointURI) {
        this(readEndpointURI, updateEndpointURI, null);
    }

    public RDFServiceSparql(String endpointURI) {
        this(endpointURI, endpointURI, null);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        if (changeSet.getPreconditionQuery() != null && !this.isPreconditionSatisfied(changeSet.getPreconditionQuery(), changeSet.getPreconditionQueryType())) {
            return false;
        }
        try {
            for (Object o : changeSet.getPreChangeEvents()) {
                this.notifyListenersOfEvent(o);
            }
            for (ModelChange modelChange : changeSet.getModelChanges()) {
                if (!modelChange.getSerializedModel().markSupported()) {
                    byte[] bytes = IOUtils.toByteArray((InputStream)modelChange.getSerializedModel());
                    modelChange.setSerializedModel(new ByteArrayInputStream(bytes));
                }
                modelChange.getSerializedModel().mark(Integer.MAX_VALUE);
                this.performChange(modelChange);
            }
            this.notifyListenersOfChanges(changeSet);
            for (Object o : changeSet.getPostChangeEvents()) {
                this.notifyListenersOfEvent(o);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RDFServiceException(e);
        }
        finally {
            this.rebuildGraphURICache = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlConstructQuery(String queryStr, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model model = ModelFactory.createDefaultModel();
        Query query = this.createQuery(queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.readEndpointURI, (Query)query);){
            qe.execConstruct(model);
        }
        ByteArrayOutputStream serializedModel = new ByteArrayOutputStream();
        model.write((OutputStream)serializedModel, RDFServiceSparql.getSerializationFormatString(resultFormat));
        ByteArrayInputStream result = new ByteArrayInputStream(serializedModel.toByteArray());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sparqlConstructQuery(String queryStr, Model model) throws RDFServiceException {
        Query query = this.createQuery(queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.readEndpointURI, (Query)query);){
            qe.execConstruct(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlDescribeQuery(String queryStr, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model model = ModelFactory.createDefaultModel();
        Query query = this.createQuery(queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.readEndpointURI, (Query)query);){
            qe.execDescribe(model);
        }
        ByteArrayOutputStream serializedModel = new ByteArrayOutputStream();
        model.write((OutputStream)serializedModel, RDFServiceSparql.getSerializationFormatString(resultFormat));
        ByteArrayInputStream result = new ByteArrayInputStream(serializedModel.toByteArray());
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream sparqlSelectQuery(String queryStr, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        try {
            HttpGet meth = new HttpGet(new URIBuilder(this.readEndpointURI).addParameter("query", queryStr).build());
            meth.addHeader("Accept", "application/sparql-results+xml");
            HttpContext context = this.getContext((HttpRequestBase)meth);
            HttpResponse response = context != null ? this.httpClient.execute((HttpUriRequest)meth, context) : this.httpClient.execute((HttpUriRequest)meth);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode > 399) {
                    log.error((Object)("response " + statusCode + " to query. \n"));
                    log.debug((Object)("update string: \n" + queryStr));
                    throw new RDFServiceException("Unable to perform SPARQL SELECT");
                }
                try (InputStream in = response.getEntity().getContent();){
                    ByteArrayInputStream result;
                    ResultSet resultSet = ResultSetFactory.fromXML((InputStream)in);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    switch (resultFormat) {
                        case CSV: {
                            ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)resultSet);
                            break;
                        }
                        case TEXT: {
                            ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)resultSet);
                            break;
                        }
                        case JSON: {
                            ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)resultSet);
                            break;
                        }
                        case XML: {
                            ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)resultSet);
                            break;
                        }
                        default: {
                            throw new RDFServiceException("unrecognized result format");
                        }
                    }
                    ByteArrayInputStream byteArrayInputStream = result = new ByteArrayInputStream(outputStream.toByteArray());
                    return byteArrayInputStream;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sparqlSelectQuery(String queryStr, ResultSetConsumer consumer) throws RDFServiceException {
        try {
            HttpGet meth = new HttpGet(new URIBuilder(this.readEndpointURI).addParameter("query", queryStr).build());
            meth.addHeader("Accept", "application/sparql-results+xml");
            HttpContext context = this.getContext((HttpRequestBase)meth);
            HttpResponse response = context != null ? this.httpClient.execute((HttpUriRequest)meth, context) : this.httpClient.execute((HttpUriRequest)meth);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode > 399) {
                    log.error((Object)("response " + statusCode + " to query. \n"));
                    log.debug((Object)("update string: \n" + queryStr));
                    throw new RDFServiceException("Unable to perform SPARQL UPDATE");
                }
                try (InputStream in = response.getEntity().getContent();){
                    consumer.processResultSet(ResultSetFactory.fromXML((InputStream)in));
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sparqlAskQuery(String queryStr) throws RDFServiceException {
        Query query = this.createQuery(queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.readEndpointURI, (Query)query);){
            boolean bl = qe.execAsk();
            return bl;
        }
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        if (this.graphURIs == null || this.rebuildGraphURICache) {
            this.graphURIs = this.getGraphURIsFromSparqlQuery();
            this.rebuildGraphURICache = false;
        }
        return this.graphURIs;
    }

    private List<String> getGraphURIsFromSparqlQuery() throws RDFServiceException {
        String fastJenaQuery = "SELECT DISTINCT ?g WHERE { GRAPH ?g {} } ORDER BY ?g";
        String standardQuery = "SELECT DISTINCT ?g WHERE { GRAPH ?g { ?s ?p ?o } }";
        List<Object> graphURIs = new ArrayList();
        try {
            graphURIs = this.getGraphURIsFromSparqlQuery(fastJenaQuery);
        }
        catch (Exception e) {
            log.debug((Object)"Unable to use non-standard ARQ query for graph list", (Throwable)e);
        }
        if (graphURIs.isEmpty()) {
            graphURIs = this.getGraphURIsFromSparqlQuery(standardQuery);
            Collections.sort(graphURIs);
        }
        return graphURIs;
    }

    private List<String> getGraphURIsFromSparqlQuery(String queryString) throws RDFServiceException {
        final ArrayList<String> graphURIs = new ArrayList<String>();
        try {
            this.sparqlSelectQuery(queryString, new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    Resource n;
                    if (qs != null && (n = qs.getResource("g")) != null && n.isResource()) {
                        graphURIs.add(n.getURI());
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RDFServiceException("Unable to list graph URIs", e);
        }
        return graphURIs;
    }

    @Override
    public void getGraphMetadata() throws RDFServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultWriteGraphURI() throws RDFServiceException {
        return this.defaultWriteGraphURI;
    }

    @Override
    public synchronized void registerListener(ChangeListener changeListener) throws RDFServiceException {
        if (!this.registeredListeners.contains(changeListener)) {
            this.registeredListeners.add(changeListener);
        }
    }

    @Override
    public synchronized void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.registeredListeners.remove(changeListener);
    }

    @Override
    public ChangeSet manufactureChangeSet() {
        return new ChangeSetImpl();
    }

    protected String getReadEndpointURI() {
        return this.readEndpointURI;
    }

    protected String getUpdateEndpointURI() {
        return this.updateEndpointURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUpdate(String updateString) throws RDFServiceException {
        try {
            HttpPost meth = new HttpPost(this.updateEndpointURI);
            meth.addHeader("Content-Type", "application/x-www-form-urlencoded");
            meth.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("update", updateString))));
            HttpContext context = this.getContext((HttpRequestBase)meth);
            HttpResponse response = context != null ? this.httpClient.execute((HttpUriRequest)meth, context) : this.httpClient.execute((HttpUriRequest)meth);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode > 399) {
                    log.error((Object)("response " + response.getStatusLine() + " to update. \n"));
                    throw new RDFServiceException("Unable to perform SPARQL UPDATE");
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (Exception e) {
            throw new RDFServiceException("Unable to perform change set update", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModel(Model model, String graphURI) throws RDFServiceException {
        try {
            long start = System.currentTimeMillis();
            this.verbModel(model, graphURI, "INSERT");
            log.info((Object)(System.currentTimeMillis() - start + " ms to insert " + model.size() + " triples"));
        }
        finally {
            this.rebuildGraphURICache = true;
        }
    }

    public void deleteModel(Model model, String graphURI) throws RDFServiceException {
        try {
            this.verbModel(model, graphURI, "DELETE");
        }
        finally {
            this.rebuildGraphURICache = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verbModel(Model model, String graphURI, String verb) throws RDFServiceException {
        Model m = ModelFactory.createDefaultModel();
        int count = 0;
        try (StmtIterator stmtIt = model.listStatements();){
            while (stmtIt.hasNext()) {
                m.add(stmtIt.nextStatement());
                if (++count % 5000 != 0 && stmtIt.hasNext()) continue;
                StringWriter sw = new StringWriter();
                m.write((Writer)sw, "N-TRIPLE");
                StringBuffer updateStringBuff = new StringBuffer();
                updateStringBuff.append(verb + " DATA { " + (graphURI != null ? "GRAPH <" + graphURI + "> { " : ""));
                updateStringBuff.append(sw);
                updateStringBuff.append((graphURI != null ? " } " : "") + " }");
                String updateString = updateStringBuff.toString();
                this.executeUpdate(updateString);
                m.removeAll();
            }
        }
    }

    @Override
    protected boolean isPreconditionSatisfied(String query, RDFService.SPARQLQueryType queryType) throws RDFServiceException {
        Model model = ModelFactory.createDefaultModel();
        switch (queryType) {
            case DESCRIBE: {
                model.read(this.sparqlDescribeQuery(query, RDFService.ModelSerializationFormat.N3), null);
                return !model.isEmpty();
            }
            case CONSTRUCT: {
                model.read(this.sparqlConstructQuery(query, RDFService.ModelSerializationFormat.N3), null);
                return !model.isEmpty();
            }
            case SELECT: {
                return this.sparqlSelectQueryHasResults(query);
            }
            case ASK: {
                return this.sparqlAskQuery(query);
            }
        }
        throw new RDFServiceException("unrecognized SPARQL query type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean sparqlSelectQueryHasResults(String queryStr) throws RDFServiceException {
        Query query = this.createQuery(queryStr);
        try (QueryExecution qe = QueryExecutionFactory.sparqlService((String)this.readEndpointURI, (Query)query);){
            ResultSet resultSet = qe.execSelect();
            boolean bl = resultSet.hasNext();
            return bl;
        }
    }

    private void performChange(ModelChange modelChange) throws RDFServiceException {
        Model model = this.parseModel(modelChange);
        Model[] separatedModel = this.separateStatementsWithBlankNodes(model);
        if (modelChange.getOperation() == ModelChange.Operation.ADD) {
            this.addModel(separatedModel[1], modelChange.getGraphURI());
            this.addBlankNodesWithSparqlUpdate(separatedModel[0], modelChange.getGraphURI());
        } else if (modelChange.getOperation() == ModelChange.Operation.REMOVE) {
            this.deleteModel(separatedModel[1], modelChange.getGraphURI());
            this.removeBlankNodesWithSparqlUpdate(separatedModel[0], modelChange.getGraphURI());
        } else {
            log.error((Object)"unrecognized operation type");
        }
    }

    private void addBlankNodesWithSparqlUpdate(Model model, String graphURI) throws RDFServiceException {
        this.updateBlankNodesWithSparqlUpdate(model, graphURI, true);
    }

    private void removeBlankNodesWithSparqlUpdate(Model model, String graphURI) throws RDFServiceException {
        this.updateBlankNodesWithSparqlUpdate(model, graphURI, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBlankNodesWithSparqlUpdate(Model model, String graphURI, boolean add) throws RDFServiceException {
        ArrayList<Statement> blankNodeStatements = new ArrayList<Statement>();
        StmtIterator stmtIt = model.listStatements();
        while (stmtIt.hasNext()) {
            Statement stmt = stmtIt.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) continue;
            blankNodeStatements.add(stmt);
        }
        if (blankNodeStatements.size() == 0) {
            return;
        }
        Model blankNodeModel = ModelFactory.createDefaultModel();
        blankNodeModel.add(blankNodeStatements);
        log.debug((Object)("update model size " + model.size()));
        log.debug((Object)("blank node model size " + blankNodeModel.size()));
        if (!add && blankNodeModel.size() == 1L) {
            log.warn((Object)("Deleting single triple with blank node: " + blankNodeModel));
            log.warn((Object)"This likely indicates a problem; excessive data may be deleted.");
        }
        Query rootFinderQuery = QueryFactory.create((String)"SELECT DISTINCT ?s WHERE { ?s ?p ?o OPTIONAL { ?ss ?pp ?s } FILTER (!isBlank(?s) || !bound(?ss)) }");
        try (QueryExecution qe = QueryExecutionFactory.create((Query)rootFinderQuery, (Model)blankNodeModel);){
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                Resource s = qs.getResource("s");
                String treeFinder = this.makeDescribe(s);
                Query treeFinderQuery = QueryFactory.create((String)treeFinder);
                try (QueryExecution qee = QueryExecutionFactory.create((Query)treeFinderQuery, (Model)blankNodeModel);){
                    Model tree = qee.execDescribe();
                    if (s.isAnon()) {
                        if (add) {
                            this.addModel(tree, graphURI);
                            continue;
                        }
                        this.removeUsingSparqlUpdate(tree, graphURI);
                        continue;
                    }
                    StmtIterator sit = tree.listStatements(s, null, (RDFNode)null);
                    while (sit.hasNext()) {
                        Statement stmt = sit.nextStatement();
                        RDFNode n = stmt.getObject();
                        Model m2 = ModelFactory.createDefaultModel();
                        if (n.isResource()) {
                            Resource s2 = (Resource)n;
                            String smallerTree = this.makeDescribe(s2);
                            Query smallerTreeQuery = QueryFactory.create((String)smallerTree);
                            try (QueryExecution qe3 = QueryExecutionFactory.create((Query)smallerTreeQuery, (Model)tree);){
                                qe3.execDescribe(m2);
                            }
                        }
                        m2.add(stmt);
                        if (add) {
                            this.addModel(m2, graphURI);
                            continue;
                        }
                        this.removeUsingSparqlUpdate(m2, graphURI);
                    }
                }
            }
        }
    }

    private void removeUsingSparqlUpdate(Model model, String graphURI) throws RDFServiceException {
        StmtIterator stmtIt = model.listStatements();
        if (!stmtIt.hasNext()) {
            stmtIt.close();
            return;
        }
        StringBuffer queryBuff = new StringBuffer();
        if (graphURI != null) {
            queryBuff.append("WITH <" + graphURI + "> \n");
        }
        queryBuff.append("DELETE { \n");
        List stmts = stmtIt.toList();
        this.sort(stmts);
        this.addStatementPatterns(stmts, queryBuff, false);
        queryBuff.append("} WHERE { \n");
        stmtIt = model.listStatements();
        stmts = stmtIt.toList();
        this.sort(stmts);
        this.addStatementPatterns(stmts, queryBuff, true);
        queryBuff.append("} \n");
        if (log.isDebugEnabled()) {
            log.debug((Object)queryBuff.toString());
        }
        this.executeUpdate(queryBuff.toString());
    }

    private List<Statement> sort(List<Statement> stmts) {
        ArrayList<Statement> output = new ArrayList<Statement>();
        int originalSize = stmts.size();
        if (originalSize == 1) {
            return stmts;
        }
        List<Statement> remaining = stmts;
        ConcurrentLinkedQueue<Resource> subjQueue = new ConcurrentLinkedQueue<Resource>();
        for (Statement stmt : remaining) {
            if (!stmt.getSubject().isURIResource()) continue;
            subjQueue.add(stmt.getSubject());
            break;
        }
        if (subjQueue.isEmpty()) {
            throw new RuntimeException("No named subject in statement patterns");
        }
        while (remaining.size() > 0) {
            if (subjQueue.isEmpty()) {
                subjQueue.add(remaining.get(0).getSubject());
            }
            while (!subjQueue.isEmpty()) {
                Resource subj = (Resource)subjQueue.poll();
                ArrayList<Statement> temp = new ArrayList<Statement>();
                for (Statement stmt : remaining) {
                    if (stmt.getSubject().equals((Object)subj)) {
                        output.add(stmt);
                        if (!stmt.getObject().isResource()) continue;
                        subjQueue.add((Resource)stmt.getObject());
                        continue;
                    }
                    temp.add(stmt);
                }
                remaining = temp;
            }
        }
        if (output.size() != originalSize) {
            throw new RuntimeException("original list size was " + originalSize + " but sorted size is " + output.size());
        }
        return output;
    }

    private void addStatementPatterns(List<Statement> stmts, StringBuffer patternBuff, boolean whereClause) {
        for (Statement stmt : stmts) {
            Triple t = stmt.asTriple();
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getSubject(), null));
            patternBuff.append(" ");
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getPredicate(), null));
            patternBuff.append(" ");
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getObject(), null));
            patternBuff.append(" .\n");
            if (!whereClause) continue;
            if (t.getSubject().isBlank()) {
                patternBuff.append("    FILTER(isBlank(" + SparqlGraph.sparqlNodeDelete(t.getSubject(), null)).append(")) \n");
            }
            if (!t.getObject().isBlank()) continue;
            patternBuff.append("    FILTER(isBlank(" + SparqlGraph.sparqlNodeDelete(t.getObject(), null)).append(")) \n");
        }
    }

    private String makeDescribe(Resource s) {
        StringBuffer query = new StringBuffer("DESCRIBE <");
        if (s.isAnon()) {
            query.append("_:" + s.getId().toString());
        } else {
            query.append(s.getURI());
        }
        query.append(">");
        return query.toString();
    }

    private Model parseModel(ModelChange modelChange) {
        Model model = ModelFactory.createDefaultModel();
        model.read(modelChange.getSerializedModel(), null, RDFServiceSparql.getSerializationFormatString(modelChange.getSerializationFormat()));
        return model;
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        String query = "SELECT * WHERE { GRAPH ?g {?s ?p ?o}}";
        this.serialize(outputStream, query);
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        String query = "SELECT * WHERE { GRAPH <" + graphURI + "> {?s ?p ?o}}";
        this.serialize(outputStream, query);
    }

    private void serialize(OutputStream outputStream, String query) throws RDFServiceException {
        InputStream resultStream = this.sparqlSelectQuery(query, RDFService.ResultFormat.JSON);
        ResultSet resultSet = ResultSetFactory.fromJSON((InputStream)resultStream);
        if (resultSet.getResultVars().contains("g")) {
            ResultSetIterators.ResultSetQuadsIterator quads = new ResultSetIterators.ResultSetQuadsIterator(resultSet);
            RDFDataMgr.writeQuads((OutputStream)outputStream, (Iterator)quads);
        } else {
            ResultSetIterators.ResultSetTriplesIterator triples = new ResultSetIterators.ResultSetTriplesIterator(resultSet);
            RDFDataMgr.writeTriples((OutputStream)outputStream, (Iterator)triples);
        }
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        Model fileModel = RDFServiceUtils.parseModel(serializedGraph, serializationFormat);
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        return fileModel.isIsomorphicWith(fromTripleStoreModel);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        return graph.isIsomorphicWith(fromTripleStoreModel);
    }

    protected HttpContext getContext(HttpRequestBase request) {
        UsernamePasswordCredentials credentials = this.getCredentials();
        if (credentials != null) {
            try {
                request.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)request, null));
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(AuthScope.ANY, (Credentials)this.getCredentials());
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.auth.credentials-provider", (Object)provider);
                return context;
            }
            catch (AuthenticationException e) {
                log.error((Object)"Unable to set credentials");
            }
        }
        return new BasicHttpContext();
    }

    protected UsernamePasswordCredentials getCredentials() {
        return null;
    }
}

