/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.IndexingUriFinder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdditionalURIsForObjectProperties
implements IndexingUriFinder,
ContextModelsUser {
    protected static final Log log = LogFactory.getLog(AdditionalURIsForObjectProperties.class);
    protected RDFService rdfService;
    protected static final String prefixs = "prefix owl:  <http://www.w3.org/2002/07/owl#> \nprefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  \nprefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> \n";
    protected final String QUERY_FOR_RELATED = "prefix owl:  <http://www.w3.org/2002/07/owl#> \nprefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  \nprefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?related WHERE { \n  ?uri ?p ?related  \n   filter( isURI( ?related ) && ?p != rdf:type )  \n}";

    @Override
    public void setContextModels(ContextModelAccess models) {
        this.rdfService = models.getRDFService();
    }

    @Override
    public List<String> findAdditionalURIsToIndex(Statement stmt) {
        if (stmt == null) {
            return Collections.emptyList();
        }
        if (stmt.getObject().isLiteral()) {
            return this.doDataPropertyStmt(stmt);
        }
        return this.doObjectPropertyStmt(stmt);
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public void endIndexing() {
    }

    protected List<String> doObjectPropertyStmt(Statement stmt) {
        if (stmt.getObject().isURIResource()) {
            return Collections.singletonList(((Resource)stmt.getObject().as(Resource.class)).getURI());
        }
        return Collections.emptyList();
    }

    protected List<String> doDataPropertyStmt(Statement stmt) {
        if (RDFS.label.equals(stmt.getPredicate())) {
            if (stmt.getSubject().isURIResource()) {
                return this.allIndividualsRelatedByObjectPropertyStmts(stmt.getSubject().getURI());
            }
            log.debug((Object)"ignored bnode");
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected List<String> allIndividualsRelatedByObjectPropertyStmts(String uri) {
        ArrayList<String> additionalUris = new ArrayList<String>();
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        Resource uriResource = ResourceFactory.createResource((String)uri);
        initialBinding.add("uri", (RDFNode)uriResource);
        ResultSet results = QueryUtils.getQueryResults("prefix owl:  <http://www.w3.org/2002/07/owl#> \nprefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  \nprefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?related WHERE { \n  ?uri ?p ?related  \n   filter( isURI( ?related ) && ?p != rdf:type )  \n}", (QuerySolution)initialBinding, this.rdfService);
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            Iterator iter = soln.varNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                RDFNode node = soln.get(name);
                if (node != null) {
                    if (node.isURIResource()) {
                        additionalUris.add(((Resource)node.as(Resource.class)).getURI());
                        continue;
                    }
                    log.warn((Object)("value from query for var " + name + "  was not a URIResource, it was " + node));
                    continue;
                }
                log.warn((Object)("value for query for var " + name + " was null"));
            }
        }
        return additionalUris;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

