/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.widgets;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LoginInProcessFlag;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.login.LoginProcessBean;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.User;
import edu.cornell.mannlib.vitro.webapp.web.widgets.Widget;
import freemarker.core.Environment;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.utility.DeepUnwrap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginWidget
extends Widget {
    private static final Log log = LogFactory.getLog(LoginWidget.class);
    private static final String EXTERNAL_AUTH_SETUP_URL = "/loginExternalAuth";

    @Override
    protected Widget.WidgetTemplateValues process(Environment env, Map params, HttpServletRequest request, ServletContext context) {
        Widget.WidgetTemplateValues values = null;
        try {
            LoginProcessBean.State state = this.getCurrentLoginState(request);
            log.debug((Object)("State on exit: " + (Object)((Object)state)));
            TemplateHashModel dataModel = env.getDataModel();
            switch (state) {
                case LOGGED_IN: {
                    if (request.getServletPath().equals(UrlBuilder.Route.LOGIN.path())) {
                        values = this.showMessageToLoggedInUser(request);
                        break;
                    }
                    return null;
                }
                case FORCED_PASSWORD_CHANGE: {
                    values = this.showPasswordChangeScreen(request);
                    break;
                }
                default: {
                    values = this.showLoginScreen(request, dataModel.get("siteName").toString());
                }
            }
            values.put("urls", dataModel.get("urls"));
            values.put("currentServlet", dataModel.get("currentServlet"));
            Map dm = (Map)DeepUnwrap.permissiveUnwrap((TemplateModel)dataModel);
            User user = (User)dm.get("user");
            values.put("user", user);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            values = this.showError(e);
        }
        return values;
    }

    private Widget.WidgetTemplateValues showLoginScreen(HttpServletRequest request, String siteName) {
        String errorMessage;
        String infoMessage;
        LoginProcessBean bean = LoginProcessBean.getBean(request);
        log.trace((Object)("Going to login screen: " + bean));
        Widget.WidgetTemplateValues values = new Widget.WidgetTemplateValues(Macro.LOGIN.toString());
        values.put(TemplateVariable.FORM_ACTION.toString(), this.getAuthenticateUrl(request));
        values.put(TemplateVariable.LOGIN_NAME.toString(), bean.getUsername());
        boolean showExternalAuth = StringUtils.isNotBlank((String)ConfigurationProperties.getBean((ServletRequest)request).getProperty("externalAuth.netIdHeaderName"));
        if (showExternalAuth) {
            values.put(TemplateVariable.EXTERNAL_AUTH_URL.toString(), UrlBuilder.getUrl(EXTERNAL_AUTH_SETUP_URL));
        }
        if (!(infoMessage = bean.getInfoMessageAndClear()).isEmpty()) {
            values.put(TemplateVariable.INFO_MESSAGE.toString(), infoMessage);
        }
        if (!(errorMessage = bean.getErrorMessageAndClear()).isEmpty()) {
            values.put(TemplateVariable.ERROR_MESSAGE.toString(), errorMessage);
        }
        values.put(TemplateVariable.SITE_NAME.toString(), siteName);
        return values;
    }

    private Widget.WidgetTemplateValues showMessageToLoggedInUser(HttpServletRequest request) {
        return new Widget.WidgetTemplateValues(Macro.ALREADY_LOGGED_IN.toString());
    }

    private Widget.WidgetTemplateValues showPasswordChangeScreen(HttpServletRequest request) {
        LoginProcessBean bean = LoginProcessBean.getBean(request);
        log.trace((Object)("Going to password change screen: " + bean));
        Widget.WidgetTemplateValues values = new Widget.WidgetTemplateValues(Macro.FORCE_PASSWORD_CHANGE.toString());
        values.put(TemplateVariable.FORM_ACTION.toString(), this.getAuthenticateUrl(request));
        values.put(TemplateVariable.CANCEL_URL.toString(), this.getCancelUrl(request));
        values.put(TemplateVariable.MINIMUM_PASSWORD_LENGTH.toString(), 6);
        values.put(TemplateVariable.MAXIMUM_PASSWORD_LENGTH.toString(), 12);
        String errorMessage = bean.getErrorMessageAndClear();
        if (!errorMessage.isEmpty()) {
            values.put(TemplateVariable.ERROR_MESSAGE.toString(), errorMessage);
        }
        return values;
    }

    private Widget.WidgetTemplateValues showError(Exception e) {
        Widget.WidgetTemplateValues values = new Widget.WidgetTemplateValues(Macro.SERVER_ERROR.toString());
        values.put(TemplateVariable.ERROR_MESSAGE.toString(), "Internal server error:<br /> " + e);
        return values;
    }

    private LoginProcessBean.State getCurrentLoginState(HttpServletRequest request) {
        if (LoginStatusBean.getBean(request).isLoggedIn()) {
            return LoginProcessBean.State.LOGGED_IN;
        }
        if (this.isOutdatedLoginProcessBean(request)) {
            LoginProcessBean.removeBean(request);
        }
        return LoginProcessBean.getBean(request).getState();
    }

    private boolean isOutdatedLoginProcessBean(HttpServletRequest request) {
        boolean inProcess = LoginInProcessFlag.checkAndReset(request);
        if (!inProcess) {
            log.debug((Object)"The process bean is outdated. Discard it.");
        }
        return !inProcess;
    }

    private String getAuthenticateUrl(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return contextPath + "/authenticate";
    }

    private String getCancelUrl(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String urlParams = "?cancel=true";
        return contextPath + "/authenticate" + urlParams;
    }

    private static enum TemplateVariable {
        LOGIN_NAME("loginName"),
        FORM_ACTION("formAction"),
        INFO_MESSAGE("infoMessage"),
        ERROR_MESSAGE("errorMessage"),
        EXTERNAL_AUTH_NAME("externalAuthName"),
        EXTERNAL_AUTH_URL("externalAuthUrl"),
        CANCEL_URL("cancelUrl"),
        SITE_NAME("siteName"),
        MINIMUM_PASSWORD_LENGTH("minimumPasswordLength"),
        MAXIMUM_PASSWORD_LENGTH("maximumPasswordLength");

        private final String variableName;

        private TemplateVariable(String variableName) {
            this.variableName = variableName;
        }

        public String toString() {
            return this.variableName;
        }
    }

    private static enum Macro {
        LOGIN("loginForm"),
        FORCE_PASSWORD_CHANGE("forcePasswordChange"),
        ALREADY_LOGGED_IN("alreadyLoggedIn"),
        SERVER_ERROR("error");

        private final String macroName;

        private Macro(String macroName) {
            this.macroName = macroName;
        }

        public String toString() {
            return this.macroName;
        }
    }
}

