/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.impl;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.filestorage.impl.FileStorageHelper;
import edu.cornell.mannlib.vitro.webapp.filestorage.impl.FileStorageImpl;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileAlreadyExistsException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileStorageImplTest
extends AbstractTestClass {
    private static final List<String> EMPTY_NAMESPACES = Collections.emptyList();
    private static File tempDir;
    private static FileStorageImpl generalFs;

    @BeforeClass
    public static void createSomeDirectories() throws IOException {
        tempDir = FileStorageImplTest.createTempDirectory(FileStorageImplTest.class.getSimpleName());
        generalFs = FileStorageImplTest.createFileStorage("general", new String[0]);
    }

    @AfterClass
    public static void cleanUp() {
        if (tempDir != null) {
            FileStorageImplTest.purgeDirectoryRecursively(tempDir);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void baseDirDoesntExist() throws IOException {
        File baseDir = new File(tempDir, "doesntExist");
        new FileStorageImpl(baseDir, EMPTY_NAMESPACES);
    }

    @Test(expected=IllegalStateException.class)
    public void partialInitializationRoot() throws IOException {
        File baseDir = new File(tempDir, "partialWithRoot");
        baseDir.mkdir();
        new File(baseDir, "file_storage_root").mkdir();
        new FileStorageImpl(baseDir, EMPTY_NAMESPACES);
    }

    @Test(expected=IllegalStateException.class)
    public void partialInitializationNamespaces() throws IOException {
        File baseDir = new File(tempDir, "partialWithNamespaces");
        baseDir.mkdir();
        new File(baseDir, "file_storage_namespaces.properties").createNewFile();
        new FileStorageImpl(baseDir, EMPTY_NAMESPACES);
    }

    @Test
    public void notInitializedNoNamespaces() throws IOException {
        File baseDir = new File(tempDir, "emptyNoNamespaces");
        baseDir.mkdir();
        FileStorageImpl fs = new FileStorageImpl(baseDir, new ArrayList());
        Assert.assertEquals((String)"baseDir", (Object)baseDir, (Object)fs.getBaseDir());
        this.assertEqualSets("namespaces", new String[0], fs.getNamespaces().values());
    }

    @Test
    public void notInitializedNamespaces() throws IOException {
        String[] namespaces = new String[]{"ns1", "ns2"};
        String dirName = "emptyWithNamespaces";
        FileStorageImpl fs = FileStorageImplTest.createFileStorage(dirName, namespaces);
        Assert.assertEquals((String)"baseDir", (Object)new File(tempDir, dirName), (Object)fs.getBaseDir());
        this.assertEqualSets("namespaces", namespaces, fs.getNamespaces().values());
    }

    @Test
    public void initializedOK() throws IOException {
        FileStorageImplTest.createFileStorage("initializeTwiceTheSame", "ns1", "ns2");
        FileStorageImplTest.createFileStorage("initializeTwiceTheSame", "ns2", "ns1");
    }

    @Test
    public void namespaceDisappears() throws IOException {
        FileStorageImplTest.createFileStorage("namespaceDisappears", "ns1", "ns2");
        FileStorageImpl fs = FileStorageImplTest.createFileStorage("namespaceDisappears", "ns2");
        this.assertEqualSets("namespaces", new String[]{"ns1", "ns2"}, fs.getNamespaces().values());
    }

    @Test
    public void namespaceChanged() throws IOException {
        FileStorageImplTest.setLoggerLevel(FileStorageImpl.class, Level.ERROR);
        FileStorageImplTest.createFileStorage("namespaceChanges", "ns1", "ns2");
        FileStorageImpl fs = FileStorageImplTest.createFileStorage("namespaceChanges", "ns3", "ns1");
        this.assertEqualSets("namespaces", new String[]{"ns1", "ns2", "ns3"}, fs.getNamespaces().values());
    }

    @Test
    public void createFileOriginal() throws IOException {
        String id = "createOriginal";
        String filename = "someName.txt";
        String contents = "these contents";
        ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes());
        generalFs.createFile(id, filename, (InputStream)bytes);
        this.assertFileContents(generalFs, id, filename, contents);
    }

    @Test
    public void createFileOverwrite() throws IOException {
        String id = "createOverwrite";
        String filename = "someName.txt";
        String contents1 = "these contents";
        ByteArrayInputStream bytes1 = new ByteArrayInputStream(contents1.getBytes());
        String contents2 = "a different string";
        ByteArrayInputStream bytes2 = new ByteArrayInputStream(contents2.getBytes());
        generalFs.createFile(id, filename, (InputStream)bytes1);
        generalFs.createFile(id, filename, (InputStream)bytes2);
        this.assertFileContents(generalFs, id, filename, contents2);
    }

    @Test
    public void createFileConflictingName() throws IOException {
        String id = "createConflict";
        String filename1 = "someName.txt";
        String filename2 = "secondFileName.txt";
        String contents = "these contents";
        ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes());
        generalFs.createFile(id, filename1, (InputStream)bytes);
        try {
            generalFs.createFile(id, filename2, (InputStream)bytes);
            Assert.fail((String)"Expected FileAlreadyExistsException.");
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void getFilenameExists() throws IOException {
        String id = "filenameExists";
        String filename = "theName.txt";
        String contents = "the contents";
        ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes());
        generalFs.createFile(id, filename, (InputStream)bytes);
        Assert.assertEquals((String)"filename", (Object)filename, (Object)generalFs.getFilename(id));
    }

    @Test
    public void getFilenameDoesntExist() throws IOException {
        Assert.assertNull((String)"null filename", (Object)generalFs.getFilename("neverHeardOfIt"));
    }

    @Test
    public void getInputStreamFound() throws IOException {
        String id = "inputStreamExists";
        String filename = "myFile";
        String contents = "Some stuff to put into my file.";
        ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes());
        generalFs.createFile(id, filename, (InputStream)bytes);
        this.assertFileContents(generalFs, id, filename, contents);
        Assert.assertEquals((String)"getInputStream", (Object)contents, (Object)FileStorageImplTest.readAll(generalFs.getInputStream(id, filename)));
    }

    @Test(expected=FileNotFoundException.class)
    public void getInputStreamNotFound() throws IOException {
        generalFs.getInputStream("notFound", "nothing");
    }

    @Test
    public void deleteFileExists() throws IOException {
        String id = "deleteMe";
        String filename = "deadFile";
        String contents = "Some stuff to put into my file.";
        ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes());
        generalFs.createFile(id, filename, (InputStream)bytes);
        generalFs.deleteFile(id);
        Assert.assertNull((String)"deleted filename", (Object)generalFs.getFilename(id));
    }

    @Test
    public void deleteFileDoesntExist() throws IOException {
        generalFs.deleteFile("totallyBogus");
    }

    @Test
    public void exerciseWindowsExclusions() throws FileAlreadyExistsException, IOException {
        String id = "nul";
        String filename = "COM1";
        String contents = "Windows doesn't like certain names.";
        ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes());
        generalFs.createFile(id, filename, (InputStream)bytes);
        this.assertFileContents(generalFs, id, filename, contents);
        Assert.assertEquals((String)"filename", (Object)filename, (Object)generalFs.getFilename(id));
        Assert.assertEquals((String)"getInputStream", (Object)contents, (Object)FileStorageImplTest.readAll(generalFs.getInputStream(id, filename)));
    }

    private static FileStorageImpl createFileStorage(String dirName, String ... namespaces) throws IOException {
        File baseDir = new File(tempDir, dirName);
        baseDir.mkdir();
        return new FileStorageImpl(baseDir, Arrays.asList(namespaces));
    }

    private <T> void assertEqualSets(String message, T[] expected, Collection<T> actual) {
        HashSet<T> actualSet;
        HashSet<T> expectedSet = new HashSet<T>(Arrays.asList(expected));
        if (expectedSet.size() != expected.length) {
            Assert.fail((String)("message: expected array contains duplicate elements: " + Arrays.deepToString(expected)));
        }
        if ((actualSet = new HashSet<T>(actual)).size() != actual.size()) {
            Assert.fail((String)("message: actual collection contains duplicate elements: " + actual));
        }
        Assert.assertEquals((String)message, expectedSet, actualSet);
    }

    private void assertFileContents(FileStorageImpl fs, String id, String filename, String expectedContents) throws IOException {
        File rootDir = new File(fs.getBaseDir(), "file_storage_root");
        File path = FileStorageHelper.getFullPath((File)rootDir, (String)id, (String)filename, (Map)fs.getNamespaces());
        Assert.assertTrue((String)("file exists: " + path), (boolean)path.exists());
        String actualContents = FileStorageImplTest.readFile(path);
        Assert.assertEquals((String)"file contents", (Object)expectedContents, (Object)actualContents);
    }
}

