/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import java.util.HashSet;
import java.util.Set;

public class SimpleReasonerTBoxHelper
extends AbstractTestClass {
    private static String URI_THING = "http://www.w3.org/2002/07/owl#Thing";

    protected OntModel createTBoxModel() {
        OntModel tBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        this.createClass(tBox, URI_THING, "OWL Thing");
        return tBox;
    }

    protected OntClass createClass(OntModel tBox, String uri, String label) {
        OntClass s = tBox.createClass(uri);
        s.setLabel(label, "en-US");
        s.addEquivalentClass((Resource)s);
        s.addSubClass((Resource)s);
        this.thing(tBox).addSubClass((Resource)s);
        return s;
    }

    private OntClass thing(OntModel tBox) {
        return tBox.getOntClass(URI_THING);
    }

    protected void setEquivalent(OntClass c1, OntClass c2) {
        this.setEquivalentClasses(this.equivalences(c1), this.equivalences(c2));
        this.setEquivalentClasses(this.equivalences(c2), this.equivalences(c1));
        c1.addEquivalentClass((Resource)c2);
        c2.addEquivalentClass((Resource)c1);
        this.copySubClasses(c1, c2);
        this.copySubClasses(c2, c1);
        this.copySuperClasses(c1, c2);
        this.copySuperClasses(c2, c1);
    }

    private void setEquivalentClasses(Set<OntClass> equivalences1, Set<OntClass> equivalences2) {
        for (OntClass c1 : equivalences1) {
            for (OntClass c2 : equivalences2) {
                c1.addEquivalentClass((Resource)c2);
            }
        }
    }

    private void copySubClasses(OntClass c1, OntClass c2) {
        for (OntClass sub : c1.listSubClasses().toList()) {
            c2.addSubClass((Resource)sub);
        }
    }

    private void copySuperClasses(OntClass c1, OntClass c2) {
        for (OntClass sup : c1.listSuperClasses().toList()) {
            c2.addSuperClass((Resource)sup);
        }
    }

    private Set<OntClass> equivalences(OntClass c1) {
        return new HashSet<OntClass>(c1.listEquivalentClasses().toList());
    }

    protected void addSubclass(OntClass parent, OntClass child) {
        this.addSubclass(this.equivalences(parent), this.equivalences(child));
    }

    private void addSubclass(Set<OntClass> equivalentParents, Set<OntClass> equivalentChildren) {
        for (OntClass parent : equivalentParents) {
            for (OntClass child : equivalentChildren) {
                parent.addSubClass((Resource)child);
                for (OntClass ancestor : parent.listSuperClasses().toList()) {
                    ancestor.addSubClass((Resource)child);
                }
                for (OntClass descendant : child.listSubClasses().toList()) {
                    parent.addSubClass((Resource)descendant);
                }
            }
        }
    }

    protected void removeSubclass(OntClass parent, OntClass child) {
        this.removeSubclass(this.equivalences(parent), this.equivalences(child));
    }

    private void removeSubclass(Set<OntClass> equivalentParents, Set<OntClass> equivalentChildren) {
        for (OntClass parent : equivalentParents) {
            for (OntClass child : equivalentChildren) {
                parent.removeSubClass((Resource)child);
                for (OntClass ancestor : parent.listSuperClasses().toList()) {
                    ancestor.removeSubClass((Resource)child);
                }
                for (OntClass descendant : child.listSubClasses().toList()) {
                    parent.removeSubClass((Resource)descendant);
                }
            }
        }
    }

    protected ObjectProperty createObjectProperty(OntModel tBox, String uri, String label) {
        ObjectProperty p = tBox.createObjectProperty(uri);
        p.setLabel(label, "en-US");
        p.addEquivalentProperty((Property)p);
        p.addSubProperty((Property)p);
        return p;
    }

    protected void setEquivalent(OntProperty p1, OntProperty p2) {
        this.setEquivalentProperty(this.equivalences(p1), this.equivalences(p2));
        this.setEquivalentProperty(this.equivalences(p2), this.equivalences(p1));
        this.copyInverses(p1, p2);
        this.copyInverses(p2, p1);
    }

    private void setEquivalentProperty(Set<OntProperty> equivalences1, Set<OntProperty> equivalences2) {
        for (OntProperty p1 : equivalences1) {
            for (OntProperty p2 : equivalences2) {
                p1.addEquivalentProperty((Property)p2);
            }
        }
    }

    private void copyInverses(OntProperty p1, OntProperty p2) {
        for (OntProperty inv : p1.listInverse().toList()) {
            p2.addInverseOf((Property)inv);
        }
    }

    protected void setInverse(OntProperty p1, OntProperty p2) {
        this.setInverse(this.equivalences(p1), this.equivalences(p2));
        this.setInverse(this.equivalences(p2), this.equivalences(p1));
    }

    private void setInverse(Set<OntProperty> equivalences1, Set<OntProperty> equivalences2) {
        for (OntProperty p1 : equivalences1) {
            for (OntProperty p2 : equivalences2) {
                p1.addInverseOf((Property)p2);
            }
        }
    }

    protected void removeInverse(OntProperty p1, OntProperty p2) {
        this.removeInverse(this.equivalences(p1), this.equivalences(p2));
        this.removeInverse(this.equivalences(p2), this.equivalences(p1));
    }

    private void removeInverse(Set<OntProperty> equivalences1, Set<OntProperty> equivalences2) {
        for (OntProperty p1 : equivalences1) {
            for (OntProperty p2 : equivalences2) {
                p1.removeInverseProperty((Property)p2);
            }
        }
    }

    private Set<OntProperty> equivalences(OntProperty p) {
        return new HashSet<OntProperty>(p.listEquivalentProperties().toSet());
    }
}

