/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.SparqlQueryDataGetter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class DataGetterUtilsTest
extends AbstractTestClass {
    OntModel displayModel;
    VitroRequest vreq;
    String testDataGetterURI_1 = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#query1data";
    String pageURI_1 = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SPARQLPage";
    String pageX = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#pageX";
    String dataGetterX = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#pageDataGetterX";

    @Before
    public void setUp() throws Exception {
        DataGetterUtilsTest.setLoggerLevel(RDFDefaultErrorHandler.class, Level.OFF);
        Model model = ModelFactory.createDefaultModel();
        InputStream in = DataGetterUtilsTest.class.getResourceAsStream("resources/dataGetterTest.n3");
        model.read(in, "", "N3");
        this.displayModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        this.vreq = new VitroRequest((HttpServletRequest)new HttpServletRequestStub());
    }

    @Test
    public void testGetJClassForDataGetterURI() throws IllegalAccessException {
        String fullJavaClassName = DataGetterUtils.getJClassForDataGetterURI((Model)this.displayModel, (String)this.testDataGetterURI_1);
        Assert.assertNotNull((Object)fullJavaClassName);
        Assert.assertTrue((String)"java class name should not be empty", (!StringUtils.isEmpty((String)fullJavaClassName) ? 1 : 0) != 0);
        Assert.assertEquals((Object)SparqlQueryDataGetter.class.getName(), (Object)fullJavaClassName);
    }

    @Test
    public void testDataGetterForURI() throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        DataGetter dg = DataGetterUtils.dataGetterForURI((VitroRequest)this.vreq, (Model)this.displayModel, (String)this.testDataGetterURI_1);
        Assert.assertNotNull((Object)dg);
    }

    @Test
    public void testGetDataGettersForPage() throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        List dgList = DataGetterUtils.getDataGettersForPage((VitroRequest)this.vreq, (Model)this.displayModel, (String)this.pageURI_1);
        Assert.assertNotNull((Object)dgList);
        Assert.assertTrue((String)"List of DataGetters was empty, it should not be.", (dgList.size() > 0 ? 1 : 0) != 0);
    }
}

