/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.controller.MultipartRequestWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.text.Collator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroRequest
extends HttpServletRequestWrapper {
    static final Log log = LogFactory.getLog(VitroRequest.class);
    public static final String SPECIAL_WRITE_MODEL = "specialWriteModel";
    public static final String ID_FOR_WRITE_MODEL = "idForWriteModel";
    public static final String ID_FOR_TBOX_MODEL = "idForTboxModel";
    public static final String ID_FOR_ABOX_MODEL = "idForAboxModel";
    public static final String ID_FOR_DISPLAY_MODEL = "idForDisplayModel";
    private HttpServletRequest _req;

    public VitroRequest(HttpServletRequest _req) {
        super(_req);
        this._req = _req;
    }

    public RDFService getRDFService() {
        return ModelAccess.on((HttpServletRequest)this).getRDFService(new ModelAccess.RdfServiceOption[0]);
    }

    public RDFService getUnfilteredRDFService() {
        return ModelAccess.on((HttpServletRequest)this).getRDFService(ModelAccess.CONTENT, ModelAccess.LANGUAGE_NEUTRAL);
    }

    public WebappDaoFactory getWebappDaoFactory() {
        return ModelAccess.on((HttpServletRequest)this).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]);
    }

    public WebappDaoFactory getUnfilteredWebappDaoFactory() {
        return ModelAccess.on((HttpServletRequest)this).getWebappDaoFactory(ModelAccess.POLICY_NEUTRAL);
    }

    public WebappDaoFactory getUnfilteredAssertionsWebappDaoFactory() {
        return ModelAccess.on((HttpServletRequest)this).getWebappDaoFactory(ModelAccess.POLICY_NEUTRAL, ModelAccess.ASSERTIONS_ONLY);
    }

    public Dataset getDataset() {
        return ModelAccess.on((HttpServletRequest)this).getDataset(ModelAccess.CONTENT);
    }

    public Dataset getUnfilteredDataset() {
        return ModelAccess.on((HttpServletRequest)this).getDataset(ModelAccess.CONTENT, ModelAccess.LANGUAGE_NEUTRAL);
    }

    public OntModel getWriteModel() {
        if (this.getAttribute(SPECIAL_WRITE_MODEL) != null) {
            return (OntModel)this.getAttribute(SPECIAL_WRITE_MODEL);
        }
        return this.getJenaOntModel();
    }

    public OntModelSelector getOntModelSelector() {
        return ModelAccess.on((HttpServletRequest)this).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]);
    }

    public OntModel getJenaOntModel() {
        return ModelAccess.on((HttpServletRequest)this).getOntModel("vitro:jenaOntModel", new ModelAccess.LanguageOption[0]);
    }

    public OntModel getDisplayModel() {
        return ModelAccess.on((HttpServletRequest)this).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata", new ModelAccess.LanguageOption[0]);
    }

    public String getIdForDisplayModel() {
        return (String)this.getAttribute(ID_FOR_DISPLAY_MODEL);
    }

    public String getNameForABOXModel() {
        return (String)this.getAttribute(ID_FOR_ABOX_MODEL);
    }

    public String getNameForTBOXModel() {
        return (String)this.getAttribute(ID_FOR_TBOX_MODEL);
    }

    public String getNameForWriteModel() {
        return (String)this.getAttribute(ID_FOR_WRITE_MODEL);
    }

    public ApplicationBean getAppBean() {
        return this.getWebappDaoFactory().getApplicationDao().getApplicationBean();
    }

    public String getClientAddr() {
        String xff = this.getHeader("x-forwarded-for");
        return xff == null || xff.trim().isEmpty() ? this.getRemoteAddr() : xff;
    }

    public Map<String, String[]> getParameterMap() {
        return this._req.getParameterMap();
    }

    public String getParameter(String name) {
        return this._req.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this._req.getParameterValues(name);
    }

    public OntModel getLanguageNeutralUnionFullModel() {
        return ModelAccess.on((HttpServletRequest)this).getOntModel("vitro:jenaOntModel", ModelAccess.LANGUAGE_NEUTRAL);
    }

    public void setCollator(Collator collator) {
        this.setAttribute("collator", collator);
    }

    public Collator getCollator() {
        return (Collator)this.getAttribute("collator");
    }

    public WebappDaoFactory getLanguageNeutralWebappDaoFactory() {
        return ModelAccess.on((HttpServletRequest)this).getWebappDaoFactory(ModelAccess.LANGUAGE_NEUTRAL, ModelAccess.POLICY_NEUTRAL);
    }

    public boolean isMultipart() {
        return this.getAttribute(MultipartRequestWrapper.ATTRIBUTE_IS_MULTIPART) != null;
    }

    public Map<String, List<FileItem>> getFiles() {
        Map map = (Map)this.getAttribute(MultipartRequestWrapper.ATTRIBUTE_FILE_ITEM_MAP);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public FileItem getFileItem(String name) {
        Map<String, List<FileItem>> map = this.getFiles();
        List<FileItem> items = map.get(name);
        if (items == null) {
            return null;
        }
        for (FileItem item : items) {
            if (item.getSize() <= 0L) continue;
            return item;
        }
        return null;
    }

    public boolean hasFileSizeException() {
        return this.getFileSizeException() != null;
    }

    public FileUploadException getFileSizeException() {
        Object e = this.getAttribute(MultipartRequestWrapper.ATTRIBUTE_FILE_SIZE_EXCEPTION);
        if (e instanceof FileUploadException) {
            return (FileUploadException)((Object)e);
        }
        return null;
    }
}

