/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.ActiveIdentifierBundleFactories;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.BasicAuthenticator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;

public abstract class Authenticator {
    private static final String FACTORY_ATTRIBUTE_NAME = AuthenticatorFactory.class.getName();
    public static final int LOGGED_IN_TIMEOUT_INTERVAL = 3600;
    public static final int PRIVILEGED_TIMEOUT_INTERVAL = 28800;

    public static Authenticator getInstance(HttpServletRequest request) {
        ServletContext ctx = request.getSession().getServletContext();
        Object attribute = ctx.getAttribute(FACTORY_ATTRIBUTE_NAME);
        if (!(attribute instanceof AuthenticatorFactory)) {
            Authenticator.setAuthenticatorFactory(new BasicAuthenticator.Factory(), ctx);
            attribute = ctx.getAttribute(FACTORY_ATTRIBUTE_NAME);
        }
        AuthenticatorFactory factory = (AuthenticatorFactory)attribute;
        return factory.getInstance(request);
    }

    public static void setAuthenticatorFactory(AuthenticatorFactory factory, ServletContext ctx) {
        ctx.setAttribute(FACTORY_ATTRIBUTE_NAME, (Object)factory);
    }

    public abstract UserAccount getAccountForExternalAuth(String var1);

    public abstract UserAccount getAccountForInternalAuth(String var1);

    public abstract boolean isUserPermittedToLogin(UserAccount var1);

    public abstract boolean isCurrentPassword(UserAccount var1, String var2);

    public abstract void recordNewPassword(UserAccount var1, String var2);

    public abstract boolean accountRequiresEditing(UserAccount var1);

    public abstract List<String> getAssociatedIndividualUris(UserAccount var1);

    public abstract void recordLoginAgainstUserAccount(UserAccount var1, LoginStatusBean.AuthenticationSource var2) throws LoginNotPermitted;

    public abstract void recordUserIsLoggedOut();

    public static String applyMd5Encoding(String raw) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(raw.getBytes());
            char[] hexChars = Hex.encodeHex((byte[])digest);
            return new String(hexChars).toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isValidEmailAddress(String emailAddress) {
        try {
            InternetAddress a = new InternetAddress(emailAddress, true);
            return emailAddress.indexOf(64) != -1;
        }
        catch (AddressException e) {
            return false;
        }
    }

    public static IdentifierBundle getIdsForUserAccount(HttpServletRequest req, UserAccount userAccount) {
        return ActiveIdentifierBundleFactories.getUserIdentifierBundle(req, userAccount);
    }

    public static class LoginNotPermitted
    extends Exception {
    }

    public static interface AuthenticatorFactory {
        public Authenticator getInstance(HttpServletRequest var1);
    }
}

