/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individuallist;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.IndividualListController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualListResults {
    private static final Log log = LogFactory.getLog(IndividualListResults.class);
    public static final IndividualListResults EMPTY = new IndividualListResults();
    private final long totalCount;
    private final List<Individual> entities;
    private final String alpha;
    private final boolean showPages;
    private final List<IndividualListController.PageRecord> pages;

    public IndividualListResults(long totalCount, List<Individual> entities, String alpha, boolean showPages, List<IndividualListController.PageRecord> pages) {
        this.totalCount = totalCount;
        this.entities = entities;
        this.alpha = alpha;
        this.showPages = showPages;
        this.pages = pages;
    }

    private IndividualListResults() {
        this(0L, Collections.emptyList(), "", false, Collections.emptyList());
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public String getAlpha() {
        return this.alpha;
    }

    public List<Individual> getEntities() {
        return this.entities;
    }

    public List<IndividualListController.PageRecord> getPages() {
        return this.pages;
    }

    public boolean isShowPages() {
        return this.showPages;
    }

    public Map<String, Object> asFreemarkerMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("showPages", this.showPages);
        m.put("pages", this.pages);
        m.put("alpha", this.alpha);
        m.put("totalCount", this.totalCount);
        m.put("entities", this.entities);
        return m;
    }
}

