/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerStatus;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataPropertyDaoJena
extends PropertyDaoJena
implements DataPropertyDao {
    protected static final Log log = LogFactory.getLog((String)DataPropertyDaoJena.class.getName());
    private boolean DIRECT = true;
    private boolean INDIRECT = !this.DIRECT;
    protected static final List<String> EXCLUDED_NAMESPACES = Arrays.asList("http://www.w3.org/2002/07/owl#", "http://vitro.mannlib.cornell.edu/ns/vitro/public#");
    protected static final String PROPERTY_FILTERS;
    protected static final String DATA_PROPERTY_QUERY_STRING;
    protected static final String LIST_VIEW_CONFIG_FILE_QUERY_STRING = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#>SELECT ?property ?filename WHERE { \n    ?property display:listViewConfigFile ?filename . \n}";
    protected static Query listViewConfigFileQuery;
    Map<DataProperty, String> customListViewConfigFileMap = null;

    public DataPropertyDaoJena(RDFService rdfService, DatasetWrapperFactory dwf, WebappDaoFactoryJena wadf) {
        super(rdfService, dwf, wadf);
    }

    @Override
    public void deleteDataProperty(DataProperty dtp) {
        this.deleteDataProperty(dtp.getURI());
    }

    @Override
    public void deleteDataProperty(String URI2) {
        this.deleteDataProperty(URI2, this.getOntModelSelector().getTBoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean annotateDataPropertyAsExternalIdentifier(String dataPropertyURI) {
        OntModel ontModel = this.getOntModelSelector().getTBoxModel();
        ontModel.enterCriticalSection(false);
        try {
            OntResource ind = ontModel.getOntResource(dataPropertyURI);
            if (ind != null) {
                ontModel.add((Resource)ind, (Property)this.DATAPROPERTY_ISEXTERNALID, "TRUE");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataProperty(String URI2, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
            DatatypeProperty dp = ontModel.getDatatypeProperty(URI2);
            if (dp != null) {
                ResIterator restIt = ontModel.listSubjectsWithProperty(OWL.onProperty, (RDFNode)dp);
                while (restIt.hasNext()) {
                    Resource restRes = (Resource)restIt.next();
                    if (!restRes.canAs(OntResource.class)) continue;
                    OntResource restOntRes = (OntResource)restRes.as(OntResource.class);
                    this.smartRemove(restOntRes, ontModel);
                }
                this.removeRulesMentioningResource((Resource)dp, ontModel);
                dp.remove();
            }
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        this.removeABoxStatementsWithPredicate(URI2);
    }

    @Override
    public void fillDataPropertiesForIndividual(Individual entity) {
        if (entity == null) {
            return;
        }
        ArrayList<DataProperty> dataprops = new ArrayList<DataProperty>();
        dataprops.addAll(this.getDataPropertyStatements(entity.getDataPropertyStatements()));
        entity.setDatatypePropertyList(dataprops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataProperty> getDataPropertyStatements(List<DataPropertyStatement> dataPropertyStmts) {
        if (dataPropertyStmts == null || dataPropertyStmts.isEmpty()) {
            return new ArrayList<DataProperty>();
        }
        HashMap<String, DataProperty> hash = new HashMap<String, DataProperty>();
        for (DataPropertyStatement dataPropertyStmt : dataPropertyStmts) {
            if (hash.containsKey(dataPropertyStmt.getDatapropURI())) {
                DataProperty p = (DataProperty)hash.get(dataPropertyStmt.getDatapropURI());
                p.addDataPropertyStatement(dataPropertyStmt);
                continue;
            }
            OntModel ontModel = this.getOntModelSelector().getTBoxModel();
            ontModel.enterCriticalSection(true);
            try {
                OntProperty op = ontModel.getOntProperty(dataPropertyStmt.getDatapropURI());
                if (op == null) continue;
                DataProperty p = this.datapropFromOntProperty(op);
                hash.put(p.getURI(), p);
                p.addDataPropertyStatement(dataPropertyStmt);
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
        ArrayList<DataProperty> dataprops = new ArrayList<DataProperty>(hash.values());
        Collections.sort(dataprops, new DataPropertyRanker());
        return dataprops;
    }

    private DataProperty datapropFromOntProperty(OntProperty op) {
        OntResource rRes;
        if (op == null) {
            return null;
        }
        if (op.getURI() == null) {
            return null;
        }
        DataProperty dp = new DataProperty();
        dp.setURI(op.getURI());
        dp.setNamespace(op.getNameSpace());
        dp.setLocalName(op.getLocalName());
        dp.setLocalNameWithPrefix(this.getWebappDaoFactory().makeLocalNameWithPrefix(dp));
        dp.setName(op.getLocalName());
        dp.setPublicName(this.getLabelOrId((OntResource)op));
        dp.setPickListName(this.getWebappDaoFactory().makePickListName(dp));
        OntResource dRes = op.getDomain();
        if (dRes != null) {
            dp.setDomainClassURI(dRes.isAnon() ? this.PSEUDO_BNODE_NS + dRes.getId().toString() : dRes.getURI());
        }
        if ((rRes = op.getRange()) != null) {
            dp.setRangeDatatypeURI(rRes.getURI());
        }
        if (op.isFunctionalProperty()) {
            dp.setFunctional(true);
        }
        dp.setExample(this.getPropertyStringValue((OntResource)op, (Property)this.EXAMPLE_ANNOT));
        dp.setDescription(this.getPropertyStringValue((OntResource)op, (Property)this.DESCRIPTION_ANNOT));
        dp.setPublicDescription(this.getPropertyStringValue((OntResource)op, (Property)this.PUBLIC_DESCRIPTION_ANNOT));
        dp.setDisplayTier(this.getWebappDaoFactory().getJenaBaseDao().getPropertyNonNegativeIntValue((OntResource)op, (Property)this.DISPLAY_RANK_ANNOT));
        dp.setDisplayLimit(this.getWebappDaoFactory().getJenaBaseDao().getPropertyNonNegativeIntValue((OntResource)op, (Property)this.DISPLAY_LIMIT));
        StmtIterator it = op.listProperties((Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT);
        BaseResourceBean.RoleLevel hiddenRoleLevel = null;
        while (it.hasNext()) {
            BaseResourceBean.RoleLevel roleFromModel;
            Resource res;
            RDFNode obj;
            Statement stmt = it.nextStatement();
            if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || hiddenRoleLevel != null && roleFromModel.compareTo(hiddenRoleLevel) <= 0) continue;
            hiddenRoleLevel = roleFromModel;
        }
        dp.setHiddenFromDisplayBelowRoleLevel(hiddenRoleLevel);
        it = op.listProperties((Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT);
        BaseResourceBean.RoleLevel prohibitedRoleLevel = null;
        while (it.hasNext()) {
            BaseResourceBean.RoleLevel roleFromModel;
            Resource res;
            RDFNode obj;
            Statement stmt = it.nextStatement();
            if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || prohibitedRoleLevel != null && roleFromModel.compareTo(prohibitedRoleLevel) <= 0) continue;
            prohibitedRoleLevel = roleFromModel;
        }
        dp.setProhibitedFromUpdateBelowRoleLevel(prohibitedRoleLevel);
        it = op.listProperties((Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT);
        BaseResourceBean.RoleLevel publishRoleLevel = null;
        while (it.hasNext()) {
            BaseResourceBean.RoleLevel roleFromModel;
            Resource res;
            RDFNode obj;
            Statement stmt = it.nextStatement();
            if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || publishRoleLevel != null && roleFromModel.compareTo(publishRoleLevel) <= 0) continue;
            publishRoleLevel = roleFromModel;
        }
        dp.setHiddenFromPublishBelowRoleLevel(publishRoleLevel);
        dp.setCustomEntryForm(this.getPropertyStringValue((OntResource)op, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT));
        dp.setExternalId(this.getOntModelSelector().getTBoxModel().contains((Resource)op, (Property)this.DATAPROPERTY_ISEXTERNALID, "TRUE"));
        Resource groupRes = (Resource)op.getPropertyValue((Property)this.PROPERTY_INPROPERTYGROUPANNOT);
        if (groupRes != null) {
            dp.setGroupURI(groupRes.getURI());
        }
        return dp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllDataProperties() {
        ArrayList<DataProperty> allDataprops = new ArrayList<DataProperty>();
        OntModel ontModel = this.getOntModelSelector().getTBoxModel();
        try {
            ontModel.enterCriticalSection(true);
            try (ExtendedIterator dataprops = ontModel.listDatatypeProperties();){
                while (dataprops.hasNext()) {
                    DatatypeProperty jDataprop = (DatatypeProperty)dataprops.next();
                    DataProperty dataprop = this.datapropFromOntProperty((OntProperty)jDataprop);
                    if (dataprop == null || this.NONUSER_NAMESPACES.contains(dataprop.getNamespace())) continue;
                    allDataprops.add(dataprop);
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
        catch (ProfileException profileException) {
            // empty catch block
        }
        return allDataprops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllExternalIdDataProperties() {
        ArrayList<DataProperty> allDataprops = new ArrayList<DataProperty>();
        OntModel ontModel = this.getOntModelSelector().getTBoxModel();
        ontModel.enterCriticalSection(true);
        try (ExtendedIterator dataprops = ontModel.listDatatypeProperties();){
            while (dataprops.hasNext()) {
                DatatypeProperty jDataprop = (DatatypeProperty)dataprops.next();
                DataProperty dataprop = this.datapropFromOntProperty((OntProperty)jDataprop);
                if (dataprop == null || !ontModel.contains((Resource)jDataprop, (Property)this.DATAPROPERTY_ISEXTERNALID, (RDFNode)ResourceFactory.createTypedLiteral((Object)true))) continue;
                allDataprops.add(dataprop);
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        if (allDataprops.size() < 0) {
            return null;
        }
        return allDataprops;
    }

    @Override
    public List<DataProperty> getDataPropertiesForVClass(String vclassURI) {
        return this.getDatapropsForClass(vclassURI);
    }

    public List<DataProperty> getDatapropsForClass(String vclassURI) {
        return this.filterAndConvertToDataProperties(this.getAllPropInstByVClass(vclassURI));
    }

    @Override
    public Collection<DataProperty> getAllPossibleDatapropsForIndividual(String individualURI) {
        return this.filterAndConvertToDataProperties(this.getAllPossiblePropInstForIndividual(individualURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataProperty> filterAndConvertToDataProperties(List<PropertyInstance> propInsts) {
        ArrayList<DataProperty> dataprops = new ArrayList<DataProperty>();
        for (PropertyInstance propInst : propInsts) {
            OntModel tboxModel = this.getOntModel();
            tboxModel.enterCriticalSection(true);
            boolean add = false;
            try {
                add = propInst.getPropertyURI() != null && tboxModel.contains(tboxModel.getResource(propInst.getPropertyURI()), RDF.type, (RDFNode)OWL.DatatypeProperty);
            }
            finally {
                tboxModel.leaveCriticalSection();
            }
            if (!add) continue;
            DataProperty dataprop = this.getDataPropertyByURI(propInst.getPropertyURI());
            dataprop.setRangeDatatypeURI(propInst.getRangeClassURI());
            dataprops.add(dataprop);
        }
        return dataprops;
    }

    protected boolean reasoningAvailable() {
        TBoxReasonerStatus status = ApplicationUtils.instance().getTBoxReasonerModule().getStatus();
        return status.isConsistent() && !status.isInErrorState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequiredDatatypeURI(Individual individual, DataProperty dataprop, List<String> vclassURIs) {
        OntModel ontModel = this.getOntModelSelector().getTBoxModel();
        String datatypeURI = dataprop.getRangeDatatypeURI();
        ontModel.enterCriticalSection(true);
        try {
            ResIterator restIt = ontModel.listSubjectsWithProperty(OWL.onProperty, (RDFNode)ontModel.getResource(dataprop.getURI()));
            block3: while (restIt.hasNext()) {
                AllValuesFromRestriction avfrest;
                Restriction rest;
                Resource restRes = (Resource)restIt.next();
                if (!restRes.canAs(Restriction.class) || !(rest = (Restriction)restRes.as(Restriction.class)).isAllValuesFromRestriction() || (avfrest = rest.asAllValuesFromRestriction()).getAllValuesFrom() == null) continue;
                if (!individual.isAnonymous() && ontModel.contains(ontModel.getResource(individual.getURI()), RDF.type, (RDFNode)rest)) {
                    datatypeURI = this.convertRequiredDatatypeURI(avfrest.getAllValuesFrom().getURI());
                    break;
                }
                ArrayList equivOrSubResources = new ArrayList();
                equivOrSubResources.addAll(ontModel.listSubjectsWithProperty(RDFS.subClassOf, (RDFNode)rest).toList());
                equivOrSubResources.addAll(ontModel.listSubjectsWithProperty(OWL.equivalentClass, (RDFNode)rest).toList());
                for (Resource equivOrSubRes : equivOrSubResources) {
                    if (equivOrSubRes.isAnon() || !vclassURIs.contains(equivOrSubRes.getURI())) continue;
                    datatypeURI = this.convertRequiredDatatypeURI(avfrest.getAllValuesFrom().getURI());
                    continue block3;
                }
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return datatypeURI;
    }

    private String convertRequiredDatatypeURI(String datatypeURI) {
        return RDFS.Literal.getURI().equals(datatypeURI) ? null : datatypeURI;
    }

    @Override
    public String getRequiredDatatypeURI(Individual individual, DataProperty dataprop) {
        return this.getRequiredDatatypeURI(individual, dataprop, this.getVClassURIs(individual));
    }

    private List<String> getVClassURIs(Individual individual) {
        ArrayList<String> vclassURIs = null;
        if (this.reasoningAvailable()) {
            vclassURIs = new ArrayList();
            for (VClass vc : individual.getVClasses(this.INDIRECT)) {
                if (vc.getURI() == null) continue;
                vclassURIs.add(vc.getURI());
            }
        } else {
            vclassURIs = this.getSupertypeURIs(individual);
        }
        return vclassURIs;
    }

    protected List<String> getSupertypeURIs(Individual ind) {
        ArrayList<String> supertypeURIs = new ArrayList<String>();
        if (ind.getVClasses() != null) {
            for (VClass vc : ind.getVClasses(this.DIRECT)) {
                String vcURI = vc.getURI();
                if (vcURI == null) continue;
                supertypeURIs.add(vcURI);
                supertypeURIs.addAll(this.getWebappDaoFactory().getVClassDao().getAllSuperClassURIs(vcURI));
            }
        } else if (ind.getVClassURI() != null) {
            supertypeURIs.add(ind.getVClassURI());
            supertypeURIs.addAll(this.getWebappDaoFactory().getVClassDao().getAllSuperClassURIs(ind.getVClassURI()));
        }
        return supertypeURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataProperty getDataPropertyByURI(String dataPropertyURI) {
        OntModel tboxModel = this.getOntModelSelector().getTBoxModel();
        tboxModel.enterCriticalSection(true);
        try {
            DataProperty dataProperty = this.datapropFromOntProperty((OntProperty)tboxModel.getDatatypeProperty(dataPropertyURI));
            return dataProperty;
        }
        finally {
            tboxModel.leaveCriticalSection();
        }
    }

    @Override
    public String insertDataProperty(DataProperty dtp) throws InsertException {
        return this.insertDataProperty(dtp, this.getOntModelSelector().getTBoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertDataProperty(DataProperty dtp, OntModel ontModel) throws InsertException {
        ontModel.enterCriticalSection(false);
        try {
            Resource rangeResource;
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
            String errMsgStr = this.getWebappDaoFactory().checkURIForEditableEntity(dtp.getURI());
            if (errMsgStr != null) {
                throw new InsertException(errMsgStr);
            }
            DatatypeProperty jDataprop = ontModel.createDatatypeProperty(dtp.getURI());
            if (dtp.getPublicName() != null && dtp.getPublicName().length() > 0) {
                jDataprop.setLabel(dtp.getPublicName(), this.getDefaultLanguage());
            } else {
                jDataprop.removeAll(RDFS.label);
            }
            jDataprop.removeAll(RDFS.domain);
            if (dtp.getDomainClassURI() != null && dtp.getDomainClassURI().length() > 0) {
                jDataprop.setDomain(ontModel.getResource(dtp.getDomainClassURI()));
            }
            if (dtp.getRangeDatatypeURI() != null && !dtp.getRangeDatatypeURI().equals("") && (rangeResource = ontModel.getResource(dtp.getRangeDatatypeURI())) != null) {
                jDataprop.setRange(rangeResource);
            }
            if (dtp.getFunctional()) {
                ontModel.add((Resource)jDataprop, RDF.type, (RDFNode)OWL.FunctionalProperty);
            }
            this.addPropertyStringValue((Resource)jDataprop, (Property)this.EXAMPLE, dtp.getExample(), (Model)ontModel);
            this.addPropertyStringValue((Resource)jDataprop, (Property)this.DESCRIPTION_ANNOT, dtp.getDescription(), (Model)ontModel);
            this.addPropertyStringValue((Resource)jDataprop, (Property)this.PUBLIC_DESCRIPTION_ANNOT, dtp.getPublicDescription(), (Model)ontModel);
            this.addPropertyNonNegativeIntValue((Resource)jDataprop, (Property)this.DISPLAY_RANK_ANNOT, dtp.getDisplayTier(), (Model)ontModel);
            this.addPropertyNonNegativeIntValue((Resource)jDataprop, (Property)this.DISPLAY_LIMIT, dtp.getDisplayLimit(), (Model)ontModel);
            jDataprop.removeAll((Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT);
            if (this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT != null && dtp.getHiddenFromDisplayBelowRoleLevel() != null) {
                jDataprop.addProperty((Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, (RDFNode)ResourceFactory.createResource((String)dtp.getHiddenFromDisplayBelowRoleLevel().getURI()));
            }
            jDataprop.removeAll((Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT);
            if (this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT != null && dtp.getProhibitedFromUpdateBelowRoleLevel() != null) {
                jDataprop.addProperty((Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, (RDFNode)ResourceFactory.createResource((String)dtp.getProhibitedFromUpdateBelowRoleLevel().getURI()));
            }
            jDataprop.removeAll((Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT);
            if (this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT != null && dtp.getHiddenFromPublishBelowRoleLevel() != null) {
                jDataprop.addProperty((Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, (RDFNode)ResourceFactory.createResource((String)dtp.getHiddenFromPublishBelowRoleLevel().getURI()));
            }
            try {
                if (dtp.getGroupURI() != null && dtp.getGroupURI().length() > 0) {
                    String badURIErrorStr = this.checkURI(dtp.getGroupURI());
                    if (badURIErrorStr == null) {
                        jDataprop.addProperty((Property)this.PROPERTY_INPROPERTYGROUPANNOT, (RDFNode)ontModel.getResource(dtp.getGroupURI()));
                    } else {
                        log.error((Object)badURIErrorStr);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("error linking data property " + dtp.getURI() + " to property group"));
            }
            this.addPropertyStringValue((Resource)jDataprop, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, dtp.getCustomEntryForm(), (Model)ontModel);
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        return dtp.getURI();
    }

    @Override
    public void updateDataProperty(DataProperty dtp) {
        this.updateDataProperty(dtp, this.getOntModelSelector().getTBoxModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataProperty(DataProperty dtp, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
            DatatypeProperty jDataprop = ontModel.getDatatypeProperty(dtp.getURI());
            this.updateRDFSLabel((OntResource)jDataprop, dtp.getPublicName());
            this.updatePropertyResourceURIValue((Resource)jDataprop, RDFS.domain, dtp.getDomainClassURI(), (Model)ontModel);
            this.updatePropertyResourceURIValue((Resource)jDataprop, RDFS.range, dtp.getRangeDatatypeURI(), (Model)ontModel);
            if (dtp.getFunctional()) {
                if (!ontModel.contains((Resource)jDataprop, RDF.type, (RDFNode)OWL.FunctionalProperty)) {
                    ontModel.add((Resource)jDataprop, RDF.type, (RDFNode)OWL.FunctionalProperty);
                }
            } else if (ontModel.contains((Resource)jDataprop, RDF.type, (RDFNode)OWL.FunctionalProperty)) {
                ontModel.remove((Resource)jDataprop, RDF.type, (RDFNode)OWL.FunctionalProperty);
            }
            this.updatePropertyStringValue((Resource)jDataprop, (Property)this.EXAMPLE, dtp.getExample(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)jDataprop, (Property)this.DESCRIPTION_ANNOT, dtp.getDescription(), (Model)ontModel);
            this.updatePropertyStringValue((Resource)jDataprop, (Property)this.PUBLIC_DESCRIPTION_ANNOT, dtp.getPublicDescription(), (Model)ontModel);
            this.updatePropertyNonNegativeIntValue((Resource)jDataprop, (Property)this.DISPLAY_RANK_ANNOT, dtp.getDisplayTier(), (Model)ontModel);
            this.updatePropertyNonNegativeIntValue((Resource)jDataprop, (Property)this.DISPLAY_LIMIT, dtp.getDisplayLimit(), (Model)ontModel);
            if (dtp.getHiddenFromDisplayBelowRoleLevel() != null) {
                this.updatePropertyResourceURIValue((Resource)jDataprop, (Property)this.HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT, dtp.getHiddenFromDisplayBelowRoleLevel().getURI(), (Model)ontModel);
            }
            if (dtp.getProhibitedFromUpdateBelowRoleLevel() != null) {
                this.updatePropertyResourceURIValue((Resource)jDataprop, (Property)this.PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT, dtp.getProhibitedFromUpdateBelowRoleLevel().getURI(), (Model)ontModel);
            }
            if (dtp.getHiddenFromPublishBelowRoleLevel() != null) {
                this.updatePropertyResourceURIValue((Resource)jDataprop, (Property)this.HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT, dtp.getHiddenFromPublishBelowRoleLevel().getURI(), (Model)ontModel);
            }
            if (dtp.getGroupURI() != null) {
                this.updatePropertyResourceURIValue((Resource)jDataprop, (Property)this.PROPERTY_INPROPERTYGROUPANNOT, dtp.getGroupURI(), (Model)ontModel);
            }
            this.updatePropertyStringValue((Resource)jDataprop, (Property)this.PROPERTY_CUSTOMENTRYFORMANNOT, dtp.getCustomEntryForm(), (Model)ontModel);
            this.getOntModel().getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataProperty> getRootDataProperties() {
        ArrayList<DataProperty> rootProperties = new ArrayList<DataProperty>();
        OntModel ontModel = this.getOntModelSelector().getTBoxModel();
        ontModel.enterCriticalSection(true);
        try (ExtendedIterator propIt = ontModel.listDatatypeProperties();){
            while (propIt.hasNext()) {
                DatatypeProperty op = (DatatypeProperty)propIt.next();
                boolean isRoot = false;
                ExtendedIterator parentIt = op.listSuperProperties();
                if (parentIt != null) {
                    ArrayList<RDFNode> parentList = new ArrayList<RDFNode>();
                    NodeIterator parentNodeIt = op.listPropertyValues(RDFS.subPropertyOf);
                    while (parentNodeIt.hasNext()) {
                        RDFNode parentNode = (RDFNode)parentNodeIt.next();
                        if (!parentNode.canAs(Property.class)) continue;
                        parentList.add(parentNode.as(Property.class));
                    }
                    if (parentList.size() == 0) {
                        isRoot = true;
                    } else {
                        isRoot = true;
                        for (Property property : parentList) {
                            if (property.equals(op) || ontModel.contains((Resource)op, OWL.equivalentProperty, (RDFNode)property) && !ontModel.contains((Resource)property, OWL.equivalentProperty, (RDFNode)op)) continue;
                            isRoot = false;
                        }
                    }
                } else {
                    isRoot = true;
                }
                if (!isRoot || this.NONUSER_NAMESPACES.contains(op.getNameSpace())) continue;
                rootProperties.add(this.datapropFromOntProperty((OntProperty)op));
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        if (rootProperties.size() == 0) {
            return null;
        }
        return rootProperties;
    }

    @Override
    public List<DataProperty> getDataPropertyList(Individual subject) {
        return this.getDataPropertyList(subject.getURI());
    }

    @Override
    public List<DataProperty> getDataPropertyList(String subjectUri) {
        String queryString = QueryUtils.subUriForQueryVar(DATA_PROPERTY_QUERY_STRING, "subject", subjectUri);
        log.debug((Object)queryString);
        Query query = null;
        try {
            query = QueryFactory.create((String)queryString);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for query string " + th.getMessage()));
            log.error((Object)queryString);
            return null;
        }
        log.debug((Object)("Data property query string:\n" + query));
        final ArrayList<DataProperty> properties = new ArrayList<DataProperty>();
        this.getPropertyQueryResults(queryString, new ResultSetConsumer(){

            @Override
            protected void processQuerySolution(QuerySolution qs) {
                Resource resource = qs.getResource("property");
                String uri = resource.getURI();
                DataProperty property = DataPropertyDaoJena.this.getDataPropertyByURI(uri);
                if (property != null) {
                    properties.add(property);
                }
            }
        });
        return properties;
    }

    @Override
    public String getCustomListViewConfigFileName(DataProperty dp) {
        if (this.customListViewConfigFileMap == null) {
            this.customListViewConfigFileMap = new HashMap<DataProperty, String>();
            OntModel displayModel = this.getOntModelSelector().getDisplayModel();
            QueryExecution qexec = QueryExecutionFactory.create((Query)listViewConfigFileQuery, (Model)displayModel);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.next();
                String propertyUri = soln.getResource("property").getURI();
                DataProperty prop = this.getDataPropertyByURI(propertyUri);
                if (prop == null) {
                    if (dp.getURI().equals(propertyUri)) {
                        log.warn((Object)("Can't find property for uri " + propertyUri));
                        continue;
                    }
                    log.debug((Object)("Can't find property for uri " + propertyUri));
                    continue;
                }
                String filename = soln.getLiteral("filename").getLexicalForm();
                this.customListViewConfigFileMap.put(prop, filename);
            }
            qexec.close();
        }
        return this.customListViewConfigFileMap.get(dp);
    }

    static {
        ArrayList<String> namespaceFilters = new ArrayList<String>();
        for (String namespace : EXCLUDED_NAMESPACES) {
            namespaceFilters.add("( !regex(str(?property), \"^" + namespace + "\" ))");
        }
        PROPERTY_FILTERS = StringUtils.join(namespaceFilters, (String)" && ");
        DATA_PROPERTY_QUERY_STRING = PREFIXES + "\n" + "SELECT DISTINCT ?property WHERE { \n" + "   ?subject ?property ?object . \n" + "   FILTER ( \n" + "       isLiteral(?object) && \n" + "       ( !regex(str(?property), \"^" + "http://vitro.mannlib.cornell.edu/ns/vitro/role#public" + "\" )) && \n" + "       ( !regex(str(?property), \"^" + "http://www.w3.org/2002/07/owl#" + "\" )) && \n" + "       ( ?property = <" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#moniker" + "> || !regex(str(?property), \"^" + "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#" + "\" )) \n" + "   ) \n" + "}";
        listViewConfigFileQuery = null;
        try {
            listViewConfigFileQuery = QueryFactory.create((String)LIST_VIEW_CONFIG_FILE_QUERY_STRING);
        }
        catch (Throwable th) {
            log.error((Object)("could not create SPARQL query for LIST_VIEW_CONFIG_FILE_QUERY_STRING " + th.getMessage()));
            log.error((Object)LIST_VIEW_CONFIG_FILE_QUERY_STRING);
        }
    }

    private class DataPropertyRanker
    implements Comparator<DataProperty> {
        private DataPropertyRanker() {
        }

        @Override
        public int compare(DataProperty dp1, DataProperty dp2) {
            int diff = dp1.getDisplayTier() - dp2.getDisplayTier();
            if (diff == 0) {
                return dp1.getPublicName().compareTo(dp2.getPublicName());
            }
            return diff;
        }
    }
}

