/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.ontology.update.AtomicOntologyChange;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeLogger;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeRecord;
import edu.cornell.mannlib.vitro.webapp.ontology.update.KnowledgeBaseUpdater;
import edu.cornell.mannlib.vitro.webapp.ontology.update.TBoxUpdater;
import edu.cornell.mannlib.vitro.webapp.ontology.update.UpdateSettings;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ABoxUpdater {
    private final Log log = LogFactory.getLog(ABoxUpdater.class);
    private OntModel oldTboxModel;
    private OntModel newTboxModel;
    private Dataset dataset;
    private RDFService rdfService;
    private OntModel newTBoxAnnotationsModel;
    private TBoxUpdater tboxUpdater;
    private ChangeLogger logger;
    private ChangeRecord record;
    private OntClass OWL_THING = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createClass(OWL.Thing.getURI());

    public ABoxUpdater(UpdateSettings settings, ChangeLogger logger, ChangeRecord record) {
        this.oldTboxModel = settings.getOldTBoxModel();
        this.newTboxModel = settings.getNewTBoxModel();
        RDFService rdfService = settings.getRDFService();
        this.dataset = new RDFServiceDataset(rdfService);
        this.rdfService = rdfService;
        this.newTBoxAnnotationsModel = settings.getNewTBoxAnnotationsModel();
        this.logger = logger;
        this.record = record;
        this.tboxUpdater = new TBoxUpdater(settings, logger, record);
    }

    public void processClassChanges(List<AtomicOntologyChange> changes) throws IOException {
        block5: for (AtomicOntologyChange change : changes) {
            switch (change.getAtomicChangeType()) {
                case ADD: {
                    this.addClass(change);
                    continue block5;
                }
                case DELETE: {
                    if ("Delete".equals(change.getNotes())) {
                        this.deleteIndividualsOfType(change);
                        continue block5;
                    }
                    this.renameClassToParent(change);
                    continue block5;
                }
                case RENAME: {
                    this.renameClass(change);
                    continue block5;
                }
            }
            this.logger.logError("unexpected change type indicator: " + (Object)((Object)change.getAtomicChangeType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameClass(AtomicOntologyChange change) throws IOException {
        Iterator graphIt = this.dataset.listNames();
        while (graphIt.hasNext()) {
            String graph = (String)graphIt.next();
            if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph)) continue;
            Model aboxModel = this.dataset.getNamedModel(graph);
            aboxModel.enterCriticalSection(false);
            try {
                Model additions = ModelFactory.createDefaultModel();
                Model retractions = ModelFactory.createDefaultModel();
                Resource oldClass = ResourceFactory.createResource((String)change.getSourceURI());
                Resource newClass = ResourceFactory.createResource((String)change.getDestinationURI());
                StmtIterator iter = aboxModel.listStatements(oldClass, (Property)null, (RDFNode)null);
                int removeCount = 0;
                while (iter.hasNext()) {
                    Statement oldStatement = (Statement)iter.next();
                    ++removeCount;
                    retractions.add(oldStatement);
                }
                if (removeCount > 0) {
                    this.logger.log("Removed " + removeCount + " subject reference" + (removeCount > 1 ? "s" : "") + " to the " + oldClass.getURI() + " class");
                }
                iter = aboxModel.listStatements((Resource)null, RDF.type, (RDFNode)oldClass);
                int renameCount = 0;
                while (iter.hasNext()) {
                    ++renameCount;
                    Statement oldStatement = (Statement)iter.next();
                    Statement newStatement = ResourceFactory.createStatement((Resource)oldStatement.getSubject(), (Property)RDF.type, (RDFNode)newClass);
                    retractions.add(oldStatement);
                    additions.add(newStatement);
                }
                if (renameCount > 0) {
                    this.logger.log("Retyped " + renameCount + " individual" + (renameCount > 1 ? "s" : "") + " from type " + oldClass.getURI() + " to type " + newClass.getURI());
                }
                aboxModel.remove(retractions);
                this.record.recordRetractions(retractions);
                aboxModel.add(additions);
                this.record.recordAdditions(additions);
            }
            finally {
                aboxModel.leaveCriticalSection();
            }
        }
    }

    public void addClass(AtomicOntologyChange change) throws IOException {
        OntClass addedClass = this.newTboxModel.getOntClass(change.getDestinationURI());
        if (addedClass == null) {
            this.logger.logError("didn't find the added class " + change.getDestinationURI() + " in the new model.");
            return;
        }
        List classList = addedClass.listSuperClasses(true).toList();
        ArrayList<OntClass> namedClassList = new ArrayList<OntClass>();
        for (OntClass ontClass : classList) {
            if (ontClass.isAnon()) continue;
            namedClassList.add(ontClass);
        }
        if (namedClassList.isEmpty()) {
            namedClassList.add(this.OWL_THING);
        }
        for (OntClass parentOfAddedClass : namedClassList) {
            if (parentOfAddedClass.equals(OWL.Thing)) continue;
            Iterator graphIt = this.dataset.listNames();
            while (graphIt.hasNext()) {
                Model aboxModel;
                StmtIterator stmtIter;
                int count;
                String graph = (String)graphIt.next();
                if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph) || (count = (stmtIter = (aboxModel = this.dataset.getNamedModel(graph)).listStatements(null, RDF.type, (RDFNode)parentOfAddedClass)).toList().size()) <= 0) continue;
                this.logger.log("There " + (count > 1 ? "are" : "is") + " " + count + " individual" + (count > 1 ? "s" : "") + " in the model that " + (count > 1 ? "are" : "is") + " of type " + parentOfAddedClass.getURI() + "," + " and a new subclass of that class has been added: " + addedClass.getURI() + ". " + "Please review " + (count > 1 ? "these" : "this") + " individual" + (count > 1 ? "s" : "") + " to see whether " + (count > 1 ? "they" : "it") + " should be of type: " + addedClass.getURI());
            }
        }
    }

    public void renameClassToParent(AtomicOntologyChange change) throws IOException {
        OntClass deletedClass = this.oldTboxModel.getOntClass(change.getSourceURI());
        if (deletedClass == null) {
            this.logger.log("WARNING: didn't find the deleted class " + change.getSourceURI() + " in the old model. Skipping updates for this deletion");
            return;
        }
        List classList = deletedClass.listSuperClasses(true).toList();
        ArrayList<OntClass> namedClassList = new ArrayList<OntClass>();
        for (OntClass ontClass : classList) {
            if (ontClass.isAnon()) continue;
            namedClassList.add(ontClass);
        }
        OntClass parent = !namedClassList.isEmpty() ? (OntClass)namedClassList.get(0) : this.OWL_THING;
        OntClass replacementClass = this.newTboxModel.getOntClass(parent.getURI());
        while (replacementClass == null) {
            if ((parent = parent.getSuperClass()) == null) {
                replacementClass = this.OWL_THING;
                continue;
            }
            replacementClass = this.newTboxModel.getOntClass(parent.getURI());
        }
        this.logger.log("Class " + deletedClass.getURI() + " has been deleted. Any references to it in the knowledge base have been changed to " + replacementClass.getURI());
        AtomicOntologyChange chg = new AtomicOntologyChange(deletedClass.getURI(), replacementClass.getURI(), AtomicOntologyChange.AtomicChangeType.RENAME, change.getNotes());
        this.renameClass(chg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndividualsOfType(AtomicOntologyChange change) throws IOException {
        OntClass deletedClass = this.oldTboxModel.getOntClass(change.getSourceURI());
        if (deletedClass == null) {
            this.logger.log("WARNING: didn't find the deleted class " + change.getSourceURI() + " in the old model. Skipping updates for this deletion");
            return;
        }
        Iterator graphIt = this.dataset.listNames();
        while (graphIt.hasNext()) {
            String graph = (String)graphIt.next();
            if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph)) continue;
            Model aboxModel = this.dataset.getNamedModel(graph);
            aboxModel.enterCriticalSection(false);
            try {
                int count = 0;
                int refCount = 0;
                StmtIterator iter = aboxModel.listStatements((Resource)null, RDF.type, (RDFNode)deletedClass);
                while (iter.hasNext()) {
                    ++count;
                    Statement typeStmt = (Statement)iter.next();
                    refCount = this.deleteIndividual(typeStmt.getSubject());
                }
                if (count <= 0) continue;
                this.logger.log("Removed " + count + " individual" + (count > 1 ? "s" : "") + " of type " + deletedClass.getURI() + " (refs = " + refCount + ")");
            }
            finally {
                aboxModel.leaveCriticalSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteIndividual(Resource individual) throws IOException {
        Model retractions = ModelFactory.createDefaultModel();
        int refCount = 0;
        Iterator graphIt = this.dataset.listNames();
        while (graphIt.hasNext()) {
            String graph = (String)graphIt.next();
            if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph)) continue;
            Model aboxModel = this.dataset.getNamedModel(graph);
            aboxModel.enterCriticalSection(false);
            try {
                StmtIterator iter = aboxModel.listStatements(individual, (Property)null, (RDFNode)null);
                while (iter.hasNext()) {
                    Statement subjstmt = (Statement)iter.next();
                    retractions.add(subjstmt);
                }
                iter = aboxModel.listStatements((Resource)null, (Property)null, (RDFNode)individual);
                while (iter.hasNext()) {
                    Statement objstmt = (Statement)iter.next();
                    retractions.add(objstmt);
                    ++refCount;
                }
                aboxModel.remove(retractions);
                this.record.recordRetractions(retractions);
            }
            finally {
                aboxModel.leaveCriticalSection();
            }
        }
        return refCount;
    }

    public void processPropertyChanges(List<AtomicOntologyChange> changes) throws IOException {
        for (AtomicOntologyChange propChangeObj : changes) {
            this.log.debug((Object)("processing " + propChangeObj));
            try {
                if (propChangeObj.getAtomicChangeType() == null) {
                    this.log.error((Object)("Missing change type; skipping " + propChangeObj));
                    continue;
                }
                switch (propChangeObj.getAtomicChangeType()) {
                    case ADD: {
                        this.log.debug((Object)"add");
                        this.addProperty(propChangeObj);
                        break;
                    }
                    case DELETE: {
                        this.log.debug((Object)"delete");
                        this.deleteProperty(propChangeObj);
                        break;
                    }
                    case RENAME: {
                        this.log.debug((Object)"rename");
                        this.renameProperty(propChangeObj);
                        break;
                    }
                    default: {
                        this.log.debug((Object)"unknown");
                        this.logger.logError("unexpected change type indicator: " + (Object)((Object)propChangeObj.getAtomicChangeType()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProperty(AtomicOntologyChange propObj) throws IOException {
        OntProperty addedProperty = this.newTboxModel.getOntProperty(propObj.getDestinationURI());
        if (addedProperty == null) {
            this.logger.logError("Unable to find property " + propObj.getDestinationURI() + " in new TBox");
            return;
        }
        OntProperty inverseOfAddedProperty = addedProperty.getInverseOf();
        if (inverseOfAddedProperty != null) {
            Model additions = ModelFactory.createDefaultModel();
            Iterator graphIt = this.dataset.listNames();
            while (graphIt.hasNext()) {
                String graph = (String)graphIt.next();
                if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph)) continue;
                Model aboxModel = this.dataset.getNamedModel(graph);
                aboxModel.enterCriticalSection(false);
                try {
                    StmtIterator iter = aboxModel.listStatements((Resource)null, (Property)inverseOfAddedProperty, (RDFNode)null);
                    while (iter.hasNext()) {
                        Statement stmt = (Statement)iter.next();
                        if (stmt.getObject().isResource()) {
                            Statement newStmt = ResourceFactory.createStatement((Resource)stmt.getObject().asResource(), (Property)addedProperty, (RDFNode)stmt.getSubject());
                            additions.add(newStmt);
                            continue;
                        }
                        this.logger.log("WARNING: expected the object of this statement to be a Resource but it is not. No inverse has been asserted: " + ABoxUpdater.stmtString(stmt));
                    }
                    aboxModel.add(additions);
                    this.record.recordAdditions(additions);
                    if (additions.size() <= 0L) continue;
                    this.logger.log("Added " + additions.size() + " statement" + (additions.size() > 1L ? "s" : "") + " with predicate " + addedProperty.getURI() + " (as an inverse to existing  " + inverseOfAddedProperty.getURI() + " statement" + (additions.size() > 1L ? "s" : "") + ")");
                }
                finally {
                    aboxModel.leaveCriticalSection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperty(AtomicOntologyChange propObj) throws IOException {
        OntProperty parent;
        OntProperty deletedProperty = this.oldTboxModel.getOntProperty(propObj.getSourceURI());
        if (deletedProperty == null && "Prop".equals(propObj.getNotes())) {
            deletedProperty = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM).createOntProperty(propObj.getSourceURI());
        }
        if (deletedProperty == null) {
            this.logger.log("WARNING: didn't find deleted property " + propObj.getSourceURI() + " in oldTBoxModel");
            return;
        }
        OntProperty replacementProperty = null;
        if (!propObj.getNotes().equals("Delete") && (parent = deletedProperty.getSuperProperty()) != null) {
            replacementProperty = this.newTboxModel.getOntProperty(parent.getURI());
            while (replacementProperty == null && (parent = parent.getSuperProperty()) != null) {
                replacementProperty = this.newTboxModel.getOntProperty(parent.getURI());
            }
        }
        Iterator graphIt = this.dataset.listNames();
        while (graphIt.hasNext()) {
            String graph = (String)graphIt.next();
            if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph)) continue;
            Model aboxModel = this.dataset.getNamedModel(graph);
            Model deletePropModel = ModelFactory.createDefaultModel();
            if (replacementProperty == null) {
                boolean plural;
                aboxModel.enterCriticalSection(false);
                try {
                    deletePropModel.add(aboxModel.listStatements((Resource)null, (Property)deletedProperty, (RDFNode)null));
                    aboxModel.remove(deletePropModel);
                }
                finally {
                    aboxModel.leaveCriticalSection();
                }
                this.record.recordRetractions(deletePropModel);
                boolean bl = plural = deletePropModel.size() > 1L;
                if (deletePropModel.size() <= 0L) continue;
                this.logger.log("Removed " + deletePropModel.size() + " statement" + (plural ? "s" : "") + " with predicate " + propObj.getSourceURI());
                continue;
            }
            AtomicOntologyChange chg = new AtomicOntologyChange(deletedProperty.getURI(), replacementProperty.getURI(), AtomicOntologyChange.AtomicChangeType.RENAME, propObj.getNotes());
            this.renameProperty(chg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameProperty(AtomicOntologyChange propObj) throws IOException {
        this.logger.log("Processing a property rename from: " + propObj.getSourceURI() + " to " + propObj.getDestinationURI());
        OntProperty oldProperty = this.oldTboxModel.getOntProperty(propObj.getSourceURI());
        OntProperty newProperty = this.newTboxModel.getOntProperty(propObj.getDestinationURI());
        if (oldProperty == null) {
            this.logger.logError("didn't find the " + propObj.getSourceURI() + " property in the old TBox");
            return;
        }
        if (newProperty == null) {
            this.logger.logError("didn't find the " + propObj.getDestinationURI() + " property in the new TBox");
            return;
        }
        long start = System.currentTimeMillis();
        Iterator graphIt = this.dataset.listNames();
        while (graphIt.hasNext()) {
            String graph = (String)graphIt.next();
            if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph)) continue;
            Model aboxModel = this.dataset.getNamedModel(graph);
            Model renamePropAddModel = ModelFactory.createDefaultModel();
            Model renamePropRetractModel = ModelFactory.createDefaultModel();
            this.log.debug((Object)("renaming " + oldProperty.getURI() + " in graph " + graph));
            aboxModel.enterCriticalSection(false);
            try {
                start = System.currentTimeMillis();
                start = System.currentTimeMillis();
                renamePropRetractModel.add(aboxModel.listStatements((Resource)null, (Property)oldProperty, (RDFNode)null));
                this.log.debug((Object)(System.currentTimeMillis() - start + " to list " + renamePropRetractModel.size() + " old statements"));
                start = System.currentTimeMillis();
                StmtIterator stmItr = renamePropRetractModel.listStatements();
                while (stmItr.hasNext()) {
                    Statement tempStatement = stmItr.nextStatement();
                    renamePropAddModel.add(tempStatement.getSubject(), (Property)newProperty, tempStatement.getObject());
                }
                this.log.debug((Object)(System.currentTimeMillis() - start + " to make new statements"));
                start = System.currentTimeMillis();
                aboxModel.remove(renamePropRetractModel);
                this.log.debug((Object)(System.currentTimeMillis() - start + " to retract old statements"));
                start = System.currentTimeMillis();
                aboxModel.add(renamePropAddModel);
                this.log.debug((Object)(System.currentTimeMillis() - start + " to add new statements"));
            }
            finally {
                aboxModel.leaveCriticalSection();
            }
            this.record.recordAdditions(renamePropAddModel);
            this.record.recordRetractions(renamePropRetractModel);
            if (renamePropRetractModel.size() <= 0L) continue;
            this.logger.log("Changed " + renamePropRetractModel.size() + " statement" + (renamePropRetractModel.size() > 1L ? "s" : "") + " with predicate " + propObj.getSourceURI() + " to use " + propObj.getDestinationURI() + " instead");
        }
        this.tboxUpdater.renameProperty(propObj);
    }

    public void logChanges(Statement oldStatement, Statement newStatement) throws IOException {
        this.logChange(oldStatement, false);
        this.logChange(newStatement, true);
    }

    public void logChange(Statement statement, boolean add) throws IOException {
        this.logger.log((add ? "Added" : "Removed") + ABoxUpdater.stmtString(statement));
    }

    public static String stmtString(Statement statement) {
        return " [subject = " + statement.getSubject().getURI() + "] [property = " + statement.getPredicate().getURI() + "] [object = " + (statement.getObject().isLiteral() ? ((Literal)statement.getObject()).getLexicalForm() + " (Literal)" : ((Resource)statement.getObject()).getURI() + " (Resource)") + "]";
    }

    public static String stmtString(Resource subject, Property predicate, RDFNode object) {
        return " [subject = " + subject.getURI() + "] [property = " + predicate.getURI() + "] [object = " + (object.isLiteral() ? ((Literal)object).getLexicalForm() + " (Literal)" : ((Resource)object).getURI() + " (Resource)") + "]";
    }
}

