/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine;

import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.searchengine.SearchEngineLogger;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstrumentedSearchEngineWrapper
implements SearchEngine {
    private static final Log log = LogFactory.getLog(InstrumentedSearchEngineWrapper.class);
    private SearchEngine innerEngine;
    private volatile Application.Component.LifecycleState lifecycleState = Application.Component.LifecycleState.NEW;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#wraps")
    public void setInnerEngine(SearchEngine inner) {
        if (this.innerEngine != null) {
            throw new IllegalStateException("Configuration includes multiple SearchEngine instancess: " + this.innerEngine + ", and " + inner);
        }
        this.innerEngine = inner;
    }

    @Validation
    public void validate() throws Exception {
        if (this.innerEngine == null) {
            throw new IllegalStateException("Configuration did not include a wrapped SearchEngine.");
        }
    }

    private void confirmActive() {
        if (this.lifecycleState == Application.Component.LifecycleState.NEW) {
            throw new IllegalStateException("Search engine has not been started.");
        }
        if (this.lifecycleState == Application.Component.LifecycleState.STOPPED) {
            throw new IllegalStateException("Search engine has stopped.");
        }
    }

    @Override
    public void startup(Application application, ComponentStartupStatus css) {
        if (application == null) {
            throw new NullPointerException("application may not be null.");
        }
        switch (this.lifecycleState) {
            case NEW: {
                this.innerEngine.startup(application, css);
                this.lifecycleState = Application.Component.LifecycleState.ACTIVE;
                break;
            }
            case STOPPED: {
                throw new IllegalStateException("startup called when already STOPPED");
            }
            default: {
                try {
                    throw new IllegalStateException();
                }
                catch (Exception e) {
                    log.warn((Object)"startup called when already ACTIVE", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void shutdown(Application application) {
        if (application == null) {
            throw new NullPointerException("application may not be null.");
        }
        switch (this.lifecycleState) {
            case ACTIVE: {
                this.innerEngine.shutdown(application);
                this.lifecycleState = Application.Component.LifecycleState.STOPPED;
                break;
            }
            default: {
                try {
                    throw new IllegalStateException();
                }
                catch (Exception e) {
                    log.warn((Object)("shutdown called when state was " + (Object)((Object)this.lifecycleState)), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void ping() throws SearchEngineException {
        this.confirmActive();
        this.innerEngine.ping();
    }

    @Override
    public SearchInputDocument createInputDocument() {
        this.confirmActive();
        return this.innerEngine.createInputDocument();
    }

    @Override
    public void add(SearchInputDocument ... docs) throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doAdd(docs);){
            this.confirmActive();
            this.innerEngine.add(docs);
        }
    }

    @Override
    public void add(Collection<SearchInputDocument> docs) throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doAdd(docs);){
            this.confirmActive();
            this.innerEngine.add(docs);
        }
    }

    @Override
    public void commit() throws SearchEngineException {
        this.confirmActive();
        this.innerEngine.commit();
    }

    @Override
    public void commit(boolean wait) throws SearchEngineException {
        this.confirmActive();
        this.innerEngine.commit(wait);
    }

    @Override
    public void deleteById(String ... ids) throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doDeleteById(ids);){
            this.confirmActive();
            this.innerEngine.deleteById(ids);
        }
    }

    @Override
    public void deleteById(Collection<String> ids) throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doDeleteById(ids);){
            this.confirmActive();
            this.innerEngine.deleteById(ids);
        }
    }

    @Override
    public void deleteByQuery(String query) throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doDeleteByQuery(query);){
            this.confirmActive();
            this.innerEngine.deleteByQuery(query);
        }
    }

    @Override
    public SearchQuery createQuery() {
        this.confirmActive();
        return this.innerEngine.createQuery();
    }

    @Override
    public SearchQuery createQuery(String queryText) {
        this.confirmActive();
        return this.innerEngine.createQuery(queryText);
    }

    @Override
    public SearchResponse query(SearchQuery query) throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doQuery(query);){
            this.confirmActive();
            SearchResponse response = this.innerEngine.query(query);
            l.setSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
    }

    @Override
    public int documentCount() throws SearchEngineException {
        try (SearchEngineLogger l = SearchEngineLogger.doCountQuery();){
            this.confirmActive();
            int count = this.innerEngine.documentCount();
            l.setSearchResponse(new SearchResponseForDocumentCount(count));
            int n = count;
            return n;
        }
    }

    private static class SearchResponseForDocumentCount
    implements SearchResponse {
        private final int count;

        public SearchResponseForDocumentCount(int count) {
            this.count = count;
        }

        @Override
        public SearchResultDocumentList getResults() {
            return new EmptyDocumentListWithCount();
        }

        @Override
        public Map<String, Map<String, List<String>>> getHighlighting() {
            return Collections.emptyMap();
        }

        @Override
        public SearchFacetField getFacetField(String name) {
            return null;
        }

        @Override
        public List<SearchFacetField> getFacetFields() {
            return Collections.emptyList();
        }

        private class EmptyDocumentListWithCount
        implements SearchResultDocumentList {
            private EmptyDocumentListWithCount() {
            }

            @Override
            public Iterator<SearchResultDocument> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public long getNumFound() {
                return SearchResponseForDocumentCount.this.count;
            }

            @Override
            public SearchResultDocument get(int i) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
        }
    }
}

