/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecuteDataRetrieval {
    static final Log log = LogFactory.getLog(ExecuteDataRetrieval.class);
    Individual individual = null;
    VitroRequest vreq = null;
    Model displayModel = null;

    public ExecuteDataRetrieval(VitroRequest vreq, Model displayModel, Individual individual) {
        this.individual = individual;
        this.vreq = vreq;
        this.displayModel = displayModel;
    }

    public List<DataGetter> retrieveDataGetters() {
        HashSet<DataGetter> dataGetters = new HashSet<DataGetter>();
        List<VClass> vclasses = this.individual.getVClasses();
        try {
            for (VClass v : vclasses) {
                String classURI = v.getURI();
                dataGetters.addAll(DataGetterUtils.getDataGettersForClass(this.vreq, this.displayModel, classURI));
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in retrieving datagetters for vclasses", (Throwable)ex);
        }
        ArrayList<DataGetter> dgList = new ArrayList<DataGetter>(dataGetters);
        return dgList;
    }

    public void executeDataGetters(Map<String, Object> mapForTemplate) throws Exception {
        List<DataGetter> dgList = this.retrieveDataGetters();
        mapForTemplate.put("individualURI", this.individual.getURI());
        for (DataGetter dg : dgList) {
            Map<String, Object> moreData = dg.getData(mapForTemplate);
            if (moreData == null) continue;
            mapForTemplate.putAll(moreData);
        }
    }
}

