/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparql;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.RdfServiceQueryContext;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SelectQueryHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SelectQueryRunner {
    private static final Log log = LogFactory.getLog(SelectQueryRunner.class);

    private SelectQueryRunner() {
    }

    public static SelectQueryHolder selectQuery(String queryString) {
        return new SelectQueryHolder(queryString);
    }

    public static SelectQueryContext createQueryContext(RDFService rdfService, String queryString) {
        return SelectQueryRunner.createQueryContext(rdfService, SelectQueryRunner.selectQuery(queryString));
    }

    public static SelectQueryContext createQueryContext(RDFService rdfService, SelectQueryHolder query) {
        return new RdfServiceQueryContext(rdfService, query);
    }

    static class StringResultsMappingImpl
    extends ArrayList<Map<String, String>>
    implements StringResultsMapping {
        StringResultsMappingImpl() {
        }

        @Override
        public List<String> flatten() {
            ArrayList<String> flat = new ArrayList<String>();
            for (Map map : this) {
                flat.addAll(map.values());
            }
            return flat;
        }

        @Override
        public Set<String> flattenToSet() {
            return new HashSet<String>(this.flatten());
        }
    }

    public static interface StringResultsMapping
    extends List<Map<String, String>> {
        public List<String> flatten();

        public Set<String> flattenToSet();
    }

    public static interface ExecutingSelectQueryContext {
        public StringResultsMapping getStringFields(String ... var1);
    }

    public static interface SelectQueryContext {
        public SelectQueryContext bindVariableToUri(String var1, String var2);

        public ExecutingSelectQueryContext execute();
    }
}

