/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.methods;

import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTemplateMethodModel
implements TemplateMethodModel {
    private static final Log log = LogFactory.getLog(BaseTemplateMethodModel.class);

    public abstract Map<String, Object> help(String var1);

    protected String mergeToHelpTemplate(Map<String, Object> map, Environment env) {
        return BaseTemplateMethodModel.processTemplateToString("help-method.ftl", map, env);
    }

    public static String processTemplateToString(String templateName, Map<String, Object> map, Environment env) {
        Template template = BaseTemplateMethodModel.getTemplate(templateName, env);
        StringWriter sw = new StringWriter();
        try {
            template.process(map, (Writer)sw);
        }
        catch (TemplateException e) {
            log.error((Object)"Template Exception creating processing environment", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IOException creating processing environment", (Throwable)e);
        }
        return sw.toString();
    }

    private static Template getTemplate(String templateName, Environment env) {
        Template template = null;
        try {
            template = env.getConfiguration().getTemplate(templateName);
        }
        catch (IOException e) {
            log.error((Object)("Cannot get template " + templateName), (Throwable)e);
        }
        return template;
    }
}

