/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.PropertyListConfig;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.CollatedObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyDataPostProcessor;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyStatementTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.UncollatedObjectPropertyTemplateModel;
import freemarker.cache.TemplateLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ObjectPropertyTemplateModel
extends PropertyTemplateModel {
    private static final Log log = LogFactory.getLog(ObjectPropertyTemplateModel.class);
    private static final String TYPE = "object";
    private static final String EDIT_PATH = "editRequestDispatch";
    private static final String IMAGE_UPLOAD_PATH = "/uploadImages";
    private static final String END_DATE_TIME_VARIABLE = "dateTimeEnd";
    private static final Pattern ORDER_BY_END_DATE_TIME_PATTERN = Pattern.compile("ORDER\\s+BY\\s+((DESC\\()?\\?subclass\\)?\\s+)?DESC\\s*\\(\\s*\\?dateTimeEnd\\)", 2);
    private static final String KEY_SUBJECT = "subject";
    private static final String KEY_PROPERTY = "property";
    private static final String DEFAULT_LIST_VIEW_QUERY_OBJECT_VARIABLE_NAME = "object";
    private static final Pattern SUBJECT_PROPERTY_OBJECT_PATTERN = Pattern.compile("\\?subject\\s+\\?property\\s+\\?(\\w+)");
    private PropertyListConfig config;
    private String objectKey;
    private String sortDirection;
    private String publicDescription;
    private int displayLimit;

    ObjectPropertyTemplateModel(ObjectProperty op, Individual subject, VitroRequest vreq, boolean editing) throws InvalidConfigurationException {
        super(op, subject, vreq, op.getDomainPublic());
        this.sortDirection = op.getDomainEntitySortDirection();
        this.domainUri = op.getDomainVClassURI();
        this.rangeUri = op.getRangeVClassURI();
        this.publicDescription = op.getPublicDescription();
        this.displayLimit = op.getDomainDisplayLimit();
        try {
            this.config = new PropertyListConfig(this, this.getFreemarkerTemplateLoader(), vreq, op, editing);
        }
        catch (InvalidConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        this.objectKey = this.getQueryObjectVariableName();
        if (editing) {
            this.setAddUrl(op);
        }
    }

    protected void setAddUrl(Property property) {
        String rangeUri;
        if (property.isAddLinkSuppressed()) {
            return;
        }
        AddObjectPropertyStatement action = new AddObjectPropertyStatement(this.vreq.getJenaOntModel(), this.subjectUri, property, RequestedAction.SOME_URI);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{action})) {
            return;
        }
        String string = rangeUri = property instanceof ObjectProperty ? ((ObjectProperty)property).getRangeVClassURI() : "data";
        if (this.propertyUri.equals("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage")) {
            this.addUrl = ObjectPropertyTemplateModel.getImageUploadUrl(this.subjectUri, "add");
        } else {
            UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.propertyUri);
            if (this.domainUri != null) {
                params.put("domainUri", this.domainUri);
            }
            if (rangeUri != null) {
                params.put("rangeUri", rangeUri);
            }
            params.putAll(UrlBuilder.getModelParams(this.vreq));
            this.addUrl = UrlBuilder.getUrl(EDIT_PATH, params);
        }
    }

    protected TemplateLoader getFreemarkerTemplateLoader() {
        return FreemarkerConfiguration.getConfig((HttpServletRequest)this.vreq).getTemplateLoader();
    }

    protected List<Map<String, String>> getStatementData() {
        ObjectPropertyStatementDao opDao = this.vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        return opDao.getObjectPropertyStatementsForIndividualByProperty(this.subjectUri, this.propertyUri, this.objectKey, this.domainUri, this.rangeUri, this.getSelectQuery(), this.getConstructQueries(), this.sortDirection);
    }

    protected abstract boolean isEmpty();

    @Override
    protected int getPropertyDisplayTier(Property p) {
        Integer displayTier = ((ObjectProperty)p).getDomainDisplayTier();
        return displayTier != null ? displayTier : -1;
    }

    @Override
    protected UrlBuilder.Route getPropertyEditRoute() {
        return UrlBuilder.Route.OBJECT_PROPERTY_EDIT;
    }

    @Override
    public int getDisplayLimit() {
        return this.displayLimit;
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    public ConfigError checkQuery(String queryString) {
        if (StringUtils.isBlank((String)queryString)) {
            return ConfigError.NO_SELECT_QUERY;
        }
        return null;
    }

    private String getSelectQuery() {
        return this.config.getSelectQuery();
    }

    private Set<String> getConstructQueries() {
        return this.config.getConstructQueries();
    }

    protected String getTemplateName() {
        return this.config.getTemplateName();
    }

    protected boolean hasDefaultListView() {
        return this.config.isDefaultListView();
    }

    protected static String getImageUploadUrl(String subjectUri, String action) {
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("entityUri", subjectUri, "action", action);
        return UrlBuilder.getUrl(IMAGE_UPLOAD_PATH, params);
    }

    private String getQueryObjectVariableName() {
        String object = null;
        if (this.hasDefaultListView()) {
            object = "object";
            log.debug((Object)("Using default list view for property " + this.propertyUri + ", so query object = '" + object + "'"));
        } else {
            String queryString = this.getSelectQuery();
            Matcher m = SUBJECT_PROPERTY_OBJECT_PATTERN.matcher(queryString);
            if (m.find()) {
                object = m.group(1);
                log.debug((Object)("Query object for property " + this.propertyUri + " = '" + object + "'"));
            }
        }
        return object;
    }

    public static ObjectPropertyTemplateModel getObjectPropertyTemplateModel(ObjectProperty op, Individual subject, VitroRequest vreq, boolean editing, List<ObjectProperty> populatedObjectPropertyList) {
        if (op.getCollateBySubclass()) {
            try {
                return new CollatedObjectPropertyTemplateModel(op, subject, vreq, editing, populatedObjectPropertyList);
            }
            catch (InvalidConfigurationException e) {
                log.warn((Object)e.getMessage());
            }
        }
        try {
            return new UncollatedObjectPropertyTemplateModel(op, subject, vreq, editing, populatedObjectPropertyList);
        }
        catch (InvalidConfigurationException e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    protected void postprocess(List<Map<String, String>> data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data for property " + this.getUri() + " before postprocessing"));
            this.logData(data);
        }
        ObjectPropertyDataPostProcessor postprocessor = this.config.getPostprocessor();
        log.debug((Object)("Using postprocessor " + postprocessor.getClass().getName() + " for property " + this.getUri()));
        postprocessor.process(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data for property " + this.getUri() + " after postprocessing"));
            this.logData(data);
        }
    }

    protected void logData(List<Map<String, String>> data) {
        if (log.isDebugEnabled()) {
            int count = 1;
            for (Map<String, String> map : data) {
                log.debug((Object)("List item " + count));
                ++count;
                for (String key : map.keySet()) {
                    log.debug((Object)(key + ": " + map.get(key)));
                }
            }
        }
    }

    protected void removeDuplicates(List<Map<String, String>> data) {
        String objectVariableName = this.getObjectKey();
        if (objectVariableName == null) {
            log.error((Object)("Cannot remove duplicate statements for property " + this.getUri() + " because no object found to dedupe."));
            return;
        }
        ArrayList<String> foundObjects = new ArrayList<String>();
        log.debug((Object)("Removing duplicates from property: " + this.getUri()));
        Iterator<Map<String, String>> dataIterator = data.iterator();
        while (dataIterator.hasNext()) {
            Map<String, String> map = dataIterator.next();
            String objectValue = map.get(objectVariableName);
            if (foundObjects.contains(objectValue)) {
                dataIterator.remove();
                continue;
            }
            foundObjects.add(objectValue);
        }
    }

    protected void postprocessStatementList(List<ObjectPropertyStatementTemplateModel> statements) {
        this.moveNullEndDateTimesToTop(statements);
    }

    protected void moveNullEndDateTimesToTop(List<ObjectPropertyStatementTemplateModel> statements) {
        String queryString = this.getSelectQuery();
        Matcher m = ORDER_BY_END_DATE_TIME_PATTERN.matcher(queryString);
        if (!m.find()) {
            return;
        }
        ArrayList<ObjectPropertyStatementTemplateModel> tempList = new ArrayList<ObjectPropertyStatementTemplateModel>();
        Iterator<ObjectPropertyStatementTemplateModel> iterator = statements.iterator();
        while (iterator.hasNext()) {
            ObjectPropertyStatementTemplateModel stmt = iterator.next();
            String dateTimeEnd = (String)stmt.get(END_DATE_TIME_VARIABLE);
            if (dateTimeEnd != null) continue;
            if (statements.indexOf(stmt) == 0) break;
            tempList.add(stmt);
            iterator.remove();
        }
        statements.addAll(0, tempList);
    }

    protected String getObjectKey() {
        return this.objectKey;
    }

    @Override
    public String getType() {
        return "object";
    }

    public String getTemplate() {
        return this.getTemplateName();
    }

    public abstract boolean isCollatedBySubclass();

    public static enum ConfigError {
        NO_SELECT_QUERY("Missing select query specification"),
        NO_SUBCLASS_SELECT("Query does not select a subclass variable"),
        NO_SUBCLASS_ORDER_BY("Query does not sort first by subclass variable"),
        NO_TEMPLATE("Missing template specification"),
        TEMPLATE_NOT_FOUND("Specified template does not exist");

        String message;

        private ConfigError(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

