/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.testing;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractTestClass {
    private static final PatternLayout patternLayout = new PatternLayout("%p %d{yyyy-MM-dd' 'HH:mm:ss.SSS} [%t] (%c{1}) %m%n");
    private static final PrintStream originalSysout = System.out;
    private static final PrintStream originalSyserr = System.err;
    private final ByteArrayOutputStream capturedSysout = new ByteArrayOutputStream();
    private final ByteArrayOutputStream capturedSyserr = new ByteArrayOutputStream();
    private static Properties originalSystemProperties = (Properties)System.getProperties().clone();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    @After
    public void initializeLogging() {
        LogManager.resetConfiguration();
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)patternLayout));
        Logger.getRootLogger().setLevel(Level.INFO);
    }

    protected static void setLoggerLevel(Class<?> clazz, Level level) {
        Logger.getLogger(clazz).setLevel(level);
    }

    protected static void setLoggerLevel(String category, Level level) {
        Logger.getLogger((String)category).setLevel(level);
    }

    protected void captureLogOutput(Class<?> clazz, Writer writer, boolean suppress) {
        PatternLayout layout = new PatternLayout("%p %m%n");
        ConsoleAppender appender = new ConsoleAppender();
        appender.setWriter(writer);
        appender.setLayout((Layout)layout);
        Logger logger = Logger.getLogger(clazz);
        logger.removeAllAppenders();
        logger.setAdditivity(!suppress);
        logger.addAppender((Appender)appender);
    }

    @Before
    @After
    public void restoreOutputStreams() {
        System.setOut(originalSysout);
        System.setErr(originalSyserr);
        this.capturedSysout.reset();
        this.capturedSyserr.reset();
    }

    protected void suppressSysout() {
        System.setOut(new PrintStream(this.capturedSysout, true));
    }

    protected void suppressSyserr() {
        System.setErr(new PrintStream(this.capturedSyserr, true));
    }

    protected String getSysoutForTest() {
        return this.capturedSysout.toString();
    }

    protected String getSyserrForTest() {
        return this.capturedSyserr.toString();
    }

    @Before
    @After
    public void restoreSystemProperties() {
        System.setProperties((Properties)originalSystemProperties.clone());
    }

    protected static void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            final StringBuffer message = new StringBuffer("Unable to delete directory '" + file.getPath() + "'\n");
            file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    message.append("   contains file '" + pathname + "'\n");
                    return true;
                }
            });
            Assert.fail((String)message.toString().trim());
        } else {
            Assert.fail((String)("Unable to delete file '" + file.getPath() + "'"));
        }
    }

    protected static void purgeDirectory(File directory) {
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (!file.isDirectory()) continue;
                Assert.fail((String)("Directory '" + directory + "' contains at least one nested directory."));
            }
            for (File file : files) {
                AbstractTestClass.deleteFile(file);
            }
            AbstractTestClass.deleteFile(directory);
        }
    }

    protected static void purgeDirectoryRecursively(File directory) {
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    AbstractTestClass.purgeDirectoryRecursively(file);
                    continue;
                }
                AbstractTestClass.deleteFile(file);
            }
            AbstractTestClass.deleteFile(directory);
        }
    }

    protected static File createTempDirectory(String name) throws IOException {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"), name);
        if (tempDirectory.exists()) {
            AbstractTestClass.purgeDirectoryRecursively(tempDirectory);
        }
        if (!tempDirectory.mkdir()) {
            throw new IOException("failed to create temp directory '" + tempDirectory.getPath() + "'");
        }
        return tempDirectory;
    }

    protected void expectException(Class<? extends Throwable> type, String messageSubstring) {
        this.exception.expect(type);
        this.exception.expectMessage(messageSubstring);
    }

    protected void expectException(Class<? extends Throwable> type, Matcher<String> messageMatcher) {
        this.exception.expect(type);
        this.exception.expectMessage(messageMatcher);
    }

    protected void expectExceptionCause(Class<? extends Throwable> type, String messageSubstring) {
        this.exception.expectCause(Matchers.instanceOf(type));
        this.exception.expectCause(Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)messageSubstring)));
    }

    protected void expectExceptionCause(Class<? extends Throwable> type, Matcher<String> messageMatcher) {
        this.exception.expectCause(Matchers.instanceOf(type));
        this.exception.expectCause(Matchers.hasProperty((String)"message", messageMatcher));
    }

    protected void expectException(Class<? extends Throwable> clazz, String messageSubstring, Class<? extends Throwable> causeClazz, String causeMessageSubstring) {
        this.expectException(clazz, messageSubstring);
        this.expectExceptionCause(causeClazz, causeMessageSubstring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File createFile(File directory, String filename, String contents) throws IOException {
        Writer writer = null;
        try {
            File file = new File(directory, filename);
            if (file.exists()) {
                throw new IOException("File '" + file.getPath() + "' already exists.");
            }
            file.createNewFile();
            writer = new FileWriter(file);
            writer.write(contents);
            File file2 = file;
            return file2;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static String readFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("file '" + file.getPath() + "' ('" + file.getAbsolutePath() + "') does not exist.");
        }
        FileReader fileReader = new FileReader(file);
        String result = AbstractTestClass.readAll(fileReader);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readAll(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder();
        BufferedReader buffered = new BufferedReader(reader);
        char[] chunk = new char[4096];
        try {
            int howMany;
            while (-1 != (howMany = buffered.read(chunk))) {
                result.append(chunk, 0, howMany);
            }
        }
        finally {
            reader.close();
        }
        return result.toString();
    }

    protected static String readAll(InputStream stream) throws IOException {
        return AbstractTestClass.readAll(new InputStreamReader(stream));
    }

    protected static URL url(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void assertEquivalentXmlDocs(String string1, String string2) {
        String out2;
        String out1 = this.launderXmlDocument(string1);
        if (!out1.equals(out2 = this.launderXmlDocument(string2))) {
            Assert.fail((String)("XML documents are not equivalent: expected <" + string1 + "> but was <" + string2 + ">"));
        }
    }

    private String launderXmlDocument(String docString) {
        StringWriter result = new StringWriter();
        try {
            DocumentBuilderFactory bFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = bFactory.newDocumentBuilder();
            TransformerFactory xFactory = TransformerFactory.newInstance();
            Transformer xformer = xFactory.newTransformer();
            StringReader reader = new StringReader(docString);
            Document doc = builder.parse(new InputSource(reader));
            xformer.transform(new DOMSource(doc), new StreamResult(result));
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)e.toString());
        }
        catch (SAXException e) {
            Assert.fail((String)e.toString());
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
        catch (TransformerException e) {
            Assert.fail((String)e.toString());
        }
        return result.toString().replaceAll(">\\s+<", "><");
    }

    protected <T extends Comparable<T>> void assertEqualSets(String label, Set<T> expected, Set<T> actual) {
        if (expected.equals(actual)) {
            return;
        }
        TreeSet<T> missing = new TreeSet<T>(expected);
        missing.removeAll(actual);
        TreeSet<T> extras = new TreeSet<T>(actual);
        extras.removeAll(expected);
        String message = label;
        if (!missing.isEmpty()) {
            message = message + ", missing: " + missing;
        }
        if (!extras.isEmpty()) {
            message = message + ", extra: " + extras;
        }
        Assert.assertEquals((String)message, expected, actual);
    }

    protected <T> Set<T> buildSet(T ... array) {
        return new HashSet<T>(Arrays.asList(array));
    }

    protected OntModel readModelFromFile(String relativePath, String rdfType) throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(relativePath);
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, rdfType);
        stream.close();
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        ontModel.prepare();
        return ontModel;
    }
}

