/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class PolicyHelper_ModelsTest
extends AbstractTestClass {
    private static final String PRIMARY_RESOURCE_URI = "http://primaryResource";
    private static final String OTHER_RESOURCE_URI = "http://otherResource";
    private static final String FRIEND_PREDICATE_URI = "http://friend";
    private static final String SOME_PREDICATE_URI = "http://something";
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    private Model additions;
    private Model retractions;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        PolicyHelper_ModelsTest.setLoggerLevel(ServletPolicyList.class, Level.WARN);
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new MySimplePolicy());
    }

    @Test
    public void rejectNullRequest() {
        PolicyHelper_ModelsTest.setLoggerLevel(PolicyHelper.class, Level.ERROR);
        this.req = null;
        this.additions = this.model(new Statement[0]);
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("reject null request", false);
    }

    @Test
    public void rejectNullAdditions() {
        PolicyHelper_ModelsTest.setLoggerLevel(PolicyHelper.class, Level.ERROR);
        this.additions = null;
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("reject null additions", false);
    }

    @Test
    public void rejectNullRetractions() {
        PolicyHelper_ModelsTest.setLoggerLevel(PolicyHelper.class, Level.ERROR);
        this.additions = this.model(new Statement[0]);
        this.retractions = null;
        this.assertAuthorized("reject null retractions", false);
    }

    @Test
    public void rejectNullOntModel() {
        PolicyHelper_ModelsTest.setLoggerLevel(PolicyHelper.class, Level.ERROR);
        this.additions = this.model(new Statement[0]);
        this.retractions = this.model(new Statement[0]);
        this.ontModel = null;
        this.assertAuthorized("reject null OntModel", false);
    }

    @Test
    public void acceptEmptyChanges() {
        this.additions = this.model(new Statement[0]);
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("accept empty changes add", true);
    }

    @Test
    public void acceptSimpleAdd() {
        this.additions = this.model(this.dataStatement(PRIMARY_RESOURCE_URI, SOME_PREDICATE_URI));
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("accept simple add", true);
    }

    @Test
    public void acceptSimpleDrop() {
        this.additions = this.model(new Statement[0]);
        this.retractions = this.model(this.dataStatement(PRIMARY_RESOURCE_URI, SOME_PREDICATE_URI));
        this.assertAuthorized("accept simple add", true);
    }

    @Test
    public void rejectSimpleAdd() {
        PolicyHelper_ModelsTest.setLoggerLevel(PolicyHelper.class, Level.ERROR);
        this.additions = this.model(this.dataStatement(OTHER_RESOURCE_URI, SOME_PREDICATE_URI));
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("reject simple add", false);
    }

    @Test
    public void rejectSimpleDrop() {
        PolicyHelper_ModelsTest.setLoggerLevel(PolicyHelper.class, Level.ERROR);
        this.additions = this.model(new Statement[0]);
        this.retractions = this.model(this.dataStatement(OTHER_RESOURCE_URI, SOME_PREDICATE_URI));
        this.assertAuthorized("reject simple drop", false);
    }

    @Test
    public void acceptAddBecauseOfExistingStatement() {
        this.ontModel.add(this.objectStatement(PRIMARY_RESOURCE_URI, FRIEND_PREDICATE_URI, OTHER_RESOURCE_URI));
        this.additions = this.model(this.dataStatement(OTHER_RESOURCE_URI, SOME_PREDICATE_URI));
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("accept add because of existing statement", true);
    }

    @Test
    public void acceptDropBecauseOfExistingStatement() {
        this.ontModel.add(this.objectStatement(PRIMARY_RESOURCE_URI, FRIEND_PREDICATE_URI, OTHER_RESOURCE_URI));
        this.additions = this.model(new Statement[0]);
        this.retractions = this.model(this.dataStatement(OTHER_RESOURCE_URI, SOME_PREDICATE_URI));
        this.assertAuthorized("accept drop because of existing statement", true);
    }

    @Test
    public void acceptAddBecauseOfOtherAdd() {
        this.additions = this.model(this.dataStatement(OTHER_RESOURCE_URI, SOME_PREDICATE_URI), this.objectStatement(PRIMARY_RESOURCE_URI, FRIEND_PREDICATE_URI, OTHER_RESOURCE_URI));
        this.retractions = this.model(new Statement[0]);
        this.assertAuthorized("accept add because of other add", true);
    }

    @Test
    public void acceptDropBecauseOfAdd() {
        this.additions = this.model(this.objectStatement(PRIMARY_RESOURCE_URI, FRIEND_PREDICATE_URI, OTHER_RESOURCE_URI));
        this.retractions = this.model(this.dataStatement(OTHER_RESOURCE_URI, SOME_PREDICATE_URI));
        this.assertAuthorized("accept drop because of add", true);
    }

    private Statement dataStatement(String subjectUri, String predicateUri) {
        Model model = ModelFactory.createDefaultModel();
        Resource subject = model.createResource(subjectUri);
        Property predicate = model.createProperty(predicateUri);
        return model.createStatement(subject, predicate, "whoCares?");
    }

    private Statement objectStatement(String subjectUri, String predicateUri, String objectUri) {
        Model model = ModelFactory.createDefaultModel();
        Resource subject = model.createResource(subjectUri);
        Resource object = model.createResource(objectUri);
        Property predicate = model.createProperty(predicateUri);
        return model.createStatement(subject, predicate, (RDFNode)object);
    }

    private Model model(Statement ... stmts) {
        Model innerModel = ModelFactory.createDefaultModel();
        Model proxy = (Model)Proxy.newProxyInstance(OrderedModelInvocationHandler.class.getClassLoader(), new Class[]{Model.class}, (InvocationHandler)new OrderedModelInvocationHandler(innerModel));
        proxy.add(stmts);
        return proxy;
    }

    private void assertAuthorized(String message, boolean expected) {
        boolean actual = PolicyHelper.isAuthorizedAsExpected((HttpServletRequest)this.req, (Model)this.additions, (Model)this.retractions, (OntModel)this.ontModel);
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    private class MySimplePolicy
    implements PolicyIface {
        private MySimplePolicy() {
        }

        public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
            if (!(whatToAuth instanceof AbstractPropertyStatementAction)) {
                return this.inconclusive();
            }
            AbstractPropertyStatementAction action = (AbstractPropertyStatementAction)whatToAuth;
            String subjectUri = action.getResourceUris()[0];
            if (PolicyHelper_ModelsTest.PRIMARY_RESOURCE_URI.equals(subjectUri)) {
                return this.authorized();
            }
            Statement friendStmt = PolicyHelper_ModelsTest.this.objectStatement(PolicyHelper_ModelsTest.PRIMARY_RESOURCE_URI, PolicyHelper_ModelsTest.FRIEND_PREDICATE_URI, subjectUri);
            if (this.statementExists(action.getOntModel(), friendStmt)) {
                return this.authorized();
            }
            return this.inconclusive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean statementExists(OntModel oModel, Statement stmt) {
            try (StmtIterator stmts = oModel.listStatements(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());){
                boolean bl = stmts.hasNext();
                return bl;
            }
        }

        private PolicyDecision authorized() {
            return new BasicPolicyDecision(Authorization.AUTHORIZED, "");
        }

        private PolicyDecision inconclusive() {
            return new BasicPolicyDecision(Authorization.INCONCLUSIVE, "");
        }
    }

    public static class StatementListIterator
    extends NiceIterator<Statement>
    implements StmtIterator {
        private final Iterator<Statement> innerIterator;

        public StatementListIterator(List<Statement> stmts) {
            this.innerIterator = new ArrayList<Statement>(stmts).iterator();
        }

        public Statement nextStatement() throws NoSuchElementException {
            return this.next();
        }

        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        public Statement next() {
            return this.innerIterator.next();
        }
    }

    public static class OrderedModelInvocationHandler
    implements InvocationHandler {
        private final Model proxied;
        private final List<Statement> stmts = new ArrayList<Statement>();

        public OrderedModelInvocationHandler(Model proxied) {
            this.proxied = proxied;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("add") && args.length == 1 && args[0] instanceof Statement[]) {
                this.stmts.addAll(Arrays.asList((Statement[])args[0]));
                return method.invoke((Object)this.proxied, args);
            }
            if (method.getName().equals("listStatements") && (args == null || args.length == 0)) {
                return new StatementListIterator(this.stmts);
            }
            return method.invoke((Object)this.proxied, args);
        }
    }
}

