/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts;

import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsOrdering;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelectionCriteria;
import org.junit.Assert;
import org.junit.Test;

public class UserAccountsSelectionCriteriaTest {
    private UserAccountsSelectionCriteria criteria;

    @Test(expected=IllegalArgumentException.class)
    public void accountsPerPageOutOfRange() {
        this.criteria = this.create(0, 10, UserAccountsOrdering.DEFAULT_ORDERING, "role", "search");
    }

    @Test(expected=IllegalArgumentException.class)
    public void pageIndexOutOfRange() {
        this.criteria = this.create(10, -1, UserAccountsOrdering.DEFAULT_ORDERING, "role", "search");
    }

    @Test
    public void orderByIsNull() {
        this.criteria = this.create(10, 1, null, "role", "search");
        Assert.assertEquals((String)"ordering", (Object)UserAccountsOrdering.DEFAULT_ORDERING, (Object)this.criteria.getOrderBy());
    }

    @Test
    public void roleFilterUriIsNull() {
        this.criteria = this.create(10, 1, UserAccountsOrdering.DEFAULT_ORDERING, null, "search");
        Assert.assertEquals((String)"roleFilter", (Object)"", (Object)this.criteria.getRoleFilterUri());
    }

    @Test
    public void searchTermIsNull() {
        this.criteria = this.create(10, 1, UserAccountsOrdering.DEFAULT_ORDERING, "role", null);
        Assert.assertEquals((String)"searchTerm", (Object)"", (Object)this.criteria.getSearchTerm());
    }

    private UserAccountsSelectionCriteria create(int accountsPerPage, int pageIndex, UserAccountsOrdering orderBy, String roleFilterUri, String searchTerm) {
        return new UserAccountsSelectionCriteria(accountsPerPage, pageIndex, orderBy, roleFilterUri, searchTerm);
    }
}

