/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyItemInfo;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationship;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelectionCriteria;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ProxyRelationshipSelectorTest
extends AbstractTestClass {
    private static final Log log = LogFactory.getLog(ProxyRelationshipSelectorTest.class);
    private static final String USER_ACCOUNT_DATA_FILENAME = "ProxyRelationshipSelectorTest_UserAccountsModel.n3";
    private static final String UNION_DATA_FILENAME = "ProxyRelationshipSelectorTest_UnionModel.n3";
    private static final String NS_MINE = "http://vivo.mydomain.edu/individual/";
    private static final String MATCHING_PROPERTY = "http://vivo.mydomain.edu/individual/matching";
    private static final String URL_PROFILE_IMAGE = "http://mydomain.edu/profileImage.jpg";
    private static final String URL_SELF_IMAGE = "http://mydomain.edu/selfImage.jpg";
    private static OntModel userAccountsModel;
    private static OntModel unionModel;
    private static ProxyRelationshipSelector.Context context;
    private static final Relation RELATION_1;
    private static final Relation RELATION_2;
    private static final Relation RELATION_3;
    private static final Relation RELATION_4;
    private static final Relation RELATION_5;
    private static final Relation RELATION_6;
    private static final Relation RELATION_7;
    private ProxyRelationshipSelection selection;
    private ProxyRelationshipSelectionCriteria criteria;

    @BeforeClass
    public static void setupModel() throws IOException {
        userAccountsModel = ProxyRelationshipSelectorTest.prepareModel(USER_ACCOUNT_DATA_FILENAME);
        unionModel = ProxyRelationshipSelectorTest.prepareModel(UNION_DATA_FILENAME);
        context = new ProxyRelationshipSelector.Context(userAccountsModel, unionModel, MATCHING_PROPERTY);
    }

    private static OntModel prepareModel(String filename) throws IOException {
        InputStream stream = ProxyRelationshipSelectorTest.class.getResourceAsStream(filename);
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, "N3");
        stream.close();
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        ontModel.prepare();
        return ontModel;
    }

    @Test(expected=NullPointerException.class)
    public void contextIsNull() {
        ProxyRelationshipSelector.select(null, (ProxyRelationshipSelectionCriteria)this.criteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.DEFAULT_VIEW, ""));
    }

    @Test(expected=NullPointerException.class)
    public void userAccountsModelIsNull_select_nullPointerException() {
        ProxyRelationshipSelector.Context brokenContext = new ProxyRelationshipSelector.Context(null, unionModel, MATCHING_PROPERTY);
        ProxyRelationshipSelector.select((ProxyRelationshipSelector.Context)brokenContext, (ProxyRelationshipSelectionCriteria)this.criteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.DEFAULT_VIEW, ""));
    }

    @Test(expected=NullPointerException.class)
    public void unionModelIsNull_select_nullPointerException() {
        ProxyRelationshipSelector.Context brokenContext = new ProxyRelationshipSelector.Context(userAccountsModel, null, MATCHING_PROPERTY);
        ProxyRelationshipSelector.select((ProxyRelationshipSelector.Context)brokenContext, (ProxyRelationshipSelectionCriteria)this.criteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.DEFAULT_VIEW, ""));
    }

    @Test(expected=NullPointerException.class)
    public void criteriaIsNull() {
        ProxyRelationshipSelector.select((ProxyRelationshipSelector.Context)context, null);
    }

    @Test
    public void checkAllFieldsOnFirstRelationshipByProxy() {
        this.selectOnCriteria(1, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "");
        log.debug((Object)("SELECTION: " + this.selection));
        this.assertExpectedCounts(7, new int[][]{this.counts(1, 1)});
        ProxyRelationship pr = (ProxyRelationship)this.selection.getProxyRelationships().get(0);
        Assert.assertEquals((String)"proxy", (Object)this.item(ProxyRelationshipSelectorTest.mydomain("userFirstProxy"), "AAAA, FirstProxy", "Self", URL_SELF_IMAGE), pr.getProxyInfos().get(0));
        Assert.assertEquals((String)"profile", (Object)this.item(ProxyRelationshipSelectorTest.mydomain("firstProfile"), "AAAA, FirstProfile", "Profile", URL_PROFILE_IMAGE), pr.getProfileInfos().get(0));
    }

    @Test
    @Ignore
    public void checkAllFieldsOnFirstRelationshipByProfile() {
        this.selectOnCriteria(1, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROFILE, "");
        this.assertExpectedCounts(7, new int[][]{this.counts(1, 1)});
        ProxyRelationship pr = (ProxyRelationship)this.selection.getProxyRelationships().get(0);
        Assert.assertEquals((String)"proxy", (Object)this.item(ProxyRelationshipSelectorTest.mydomain("userFirstProxy"), "AAAA, FirstProxy", "Self", URL_SELF_IMAGE), pr.getProxyInfos().get(0));
        Assert.assertEquals((String)"profile", (Object)this.item(ProxyRelationshipSelectorTest.mydomain("firstProfile"), "AAAA, FirstProfile", "Profile", URL_PROFILE_IMAGE), pr.getProfileInfos().get(0));
    }

    @Test
    public void paginationFirstOfSeveralByProxy() {
        this.selectOnCriteria(3, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "");
        this.assertExpectedRelations(7, RELATION_1, RELATION_2, RELATION_3);
    }

    @Test
    public void paginationOnlyPageByProxy() {
        this.selectOnCriteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "");
        this.assertExpectedRelations(7, RELATION_1, RELATION_2, RELATION_3, RELATION_4, RELATION_5, RELATION_6, RELATION_7);
    }

    @Test
    public void paginationSecondOfSeveralByProxy() {
        this.selectOnCriteria(3, 2, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "");
        this.assertExpectedRelations(7, RELATION_4, RELATION_5, RELATION_6);
    }

    @Test
    public void paginationOutOfRangeTooHighByProxy() {
        this.selectOnCriteria(3, 7, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "");
        this.assertExpectedRelations(7, new Relation[0]);
    }

    @Test
    @Ignore
    public void paginationLastFullPageByProxy() {
        Assert.fail((String)"paginationLastFullPageByProxy not implemented");
    }

    @Test
    public void paginationLastPartialPageByProxy() {
        this.selectOnCriteria(3, 3, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "");
        this.assertExpectedRelations(7, RELATION_7);
    }

    @Test
    public void searchFirstProxy() {
        this.selectOnCriteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "AA");
        this.assertExpectedRelations(1, RELATION_1);
    }

    @Test
    public void searchAccountWithNoProxy() {
        this.selectOnCriteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "None");
        this.assertExpectedRelations(0, new Relation[0]);
    }

    @Test
    public void searchMultipleProxies() {
        this.selectOnCriteria(10, 1, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "No");
        this.assertExpectedRelations(3, RELATION_4, RELATION_5, RELATION_6);
    }

    @Test
    public void searchPopularWithPagination() {
        this.selectOnCriteria(2, 2, ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY, "No");
        this.assertExpectedRelations(3, RELATION_6);
    }

    private ProxyRelationshipSelectionCriteria criteria(int accountsPerPage, int pageIndex, ProxyRelationshipSelectionCriteria.ProxyRelationshipView view, String searchTerm) {
        return new ProxyRelationshipSelectionCriteria(accountsPerPage, pageIndex, view, searchTerm);
    }

    private void selectOnCriteria(int relationshipsPerPage, int pageIndex, ProxyRelationshipSelectionCriteria.ProxyRelationshipView viewBy, String searchTerm) {
        this.criteria = new ProxyRelationshipSelectionCriteria(relationshipsPerPage, pageIndex, viewBy, searchTerm);
        this.selection = ProxyRelationshipSelector.select((ProxyRelationshipSelector.Context)context, (ProxyRelationshipSelectionCriteria)this.criteria);
    }

    private int[] counts(int proxyCount, int profileCount) {
        return new int[]{proxyCount, profileCount};
    }

    private ProxyItemInfo item(String uri, String label, String classLabel, String imageUrl) {
        return new ProxyItemInfo(uri, label, classLabel, imageUrl);
    }

    private static List<String> list(String ... uris) {
        return Arrays.asList(uris);
    }

    private static Relation relation(List<String> proxyUris, List<String> profileUris) {
        return new Relation(proxyUris, profileUris);
    }

    private static String mydomain(String localName) {
        return NS_MINE + localName;
    }

    private void assertExpectedCounts(int total, int[] ... counts) {
        Assert.assertEquals((String)"total result count", (long)total, (long)this.selection.getTotalResultCount());
        List relationships = this.selection.getProxyRelationships();
        Assert.assertEquals((String)"number of returns", (long)counts.length, (long)relationships.size());
        for (int i = 0; i < counts.length; ++i) {
            ProxyRelationship r = (ProxyRelationship)relationships.get(i);
            Assert.assertEquals((String)("number of proxies in result " + i), (long)counts[i][0], (long)r.getProxyInfos().size());
            Assert.assertEquals((String)("number of profiles in result " + i), (long)counts[i][1], (long)r.getProfileInfos().size());
        }
    }

    private void assertExpectedRelations(int total, Relation ... relations) {
        Assert.assertEquals((String)"total result count", (long)total, (long)this.selection.getTotalResultCount());
        Assert.assertEquals((String)"page result count", (long)relations.length, (long)this.selection.getProxyRelationships().size());
        for (int i = 0; i < relations.length; ++i) {
            this.assertEqualUris(i, relations[i], (ProxyRelationship)this.selection.getProxyRelationships().get(i));
        }
    }

    private void assertEqualUris(int i, Relation relation, ProxyRelationship proxyRelationship) {
        List<String> expectedProxyUris = relation.proxyUris;
        ArrayList<String> actualProxyUris = new ArrayList<String>();
        for (ProxyItemInfo proxyInfo : proxyRelationship.getProxyInfos()) {
            actualProxyUris.add(proxyInfo.getUri());
        }
        Assert.assertEquals((String)("proxies for relationship " + i), expectedProxyUris, actualProxyUris);
        List<String> expectedProfileUris = relation.profileUris;
        ArrayList<String> actualProfileUris = new ArrayList<String>();
        for (ProxyItemInfo profileInfo : proxyRelationship.getProfileInfos()) {
            actualProfileUris.add(profileInfo.getUri());
        }
        Assert.assertEquals((String)("profiles for relationship " + i), expectedProfileUris, actualProfileUris);
    }

    static {
        RELATION_1 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userFirstProxy")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("firstProfile")));
        RELATION_2 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userProxyWithSelfWithBoth")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("popularProfile")));
        RELATION_3 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userProxyWithSelfWithNeither")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("popularProfile")));
        RELATION_4 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userProxyWithSelfWithNoClassLabel")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("popularProfile")));
        RELATION_5 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userProxyWithSelfWithNoImageUrl")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("popularProfile")));
        RELATION_6 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userProxyWithNoSelf")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("popularProfile")));
        RELATION_7 = ProxyRelationshipSelectorTest.relation(ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("userPopularProxy")), ProxyRelationshipSelectorTest.list(ProxyRelationshipSelectorTest.mydomain("profileWithBoth"), ProxyRelationshipSelectorTest.mydomain("profileWithNeither"), ProxyRelationshipSelectorTest.mydomain("profileWithNoImageUrl"), ProxyRelationshipSelectorTest.mydomain("profileWithNoClassLabel")));
    }

    private static class Relation {
        final List<String> proxyUris;
        final List<String> profileUris;

        public Relation(List<String> proxyUris, List<String> profileUris) {
            this.proxyUris = proxyUris;
            this.profileUris = profileUris;
        }
    }
}

