/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.webapp.controller.edit.PrimitiveRdfEdit;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrimitiveRdfEditTest {
    OntModel testModel;
    WebappDaoFactory wdf;
    private String testN3a = "<http://example.com/motorcycles/honda/vtl1000> <http://example.com/engines/displacement> \"1000cm3\" .<http://example.com/motorcycles/honda/919> <http://example.com/engines/displacement> \"919cm3\" .";
    private String testN3b = "<http://example.com/motorcycles/honda/919> <http://example.com/motorcycles/relatedTo> <http://exmaple.com/motorcycle/honda/599> .";

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testProcessChanges() throws Exception {
        OntModel writeModel = ModelFactory.createOntologyModel();
        int totalStmts = 3;
        PrimitiveRdfEdit pre = new PrimitiveRdfEdit();
        String[] params = new String[]{this.testN3a, this.testN3b};
        Set models = pre.parseRdfParam(params, "N3");
        Assert.assertNotNull((Object)models);
        Assert.assertTrue((models.size() == 2 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)writeModel);
        long size = writeModel.size();
        pre.processChanges("uri:fakeEditorUri", (Model)writeModel, pre.mergeModels(models), ModelFactory.createDefaultModel());
        Assert.assertEquals((long)(size + (long)totalStmts), (long)writeModel.size());
        String[] params3 = new String[]{this.testN3b};
        Set retracts = pre.parseRdfParam(params3, "N3");
        pre.processChanges("uri:fakeEditorUri", (Model)writeModel, ModelFactory.createDefaultModel(), pre.mergeModels(retracts));
        Assert.assertEquals((long)(size + (long)totalStmts - 1L), (long)writeModel.size());
    }

    @Test
    public void testParseRdfParam() throws Exception {
        PrimitiveRdfEdit pre = new PrimitiveRdfEdit();
        String[] params = new String[]{this.testN3a, this.testN3b};
        Set models = pre.parseRdfParam(params, "N3");
        Assert.assertNotNull((Object)models);
        Assert.assertTrue((models.size() == 2 ? 1 : 0) != 0);
    }
}

