/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.vclassgroup;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import edu.cornell.mannlib.vitro.webapp.dao.vclassgroup.ProhibitedFromSearch;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;

public class ProhibitedFromSearchTest {
    String SEARCH_CONFIG_URI = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex";
    String TEST_CLASS = "http://vivoweb.org/ontology/test/bogus#Class5";
    String n3 = "@prefix : <http://vitro.mannlib.cornell.edu/ns/vitroDisplay#> . \n@prefix vivo: <http://vivoweb.org/ontology/test/bogus#> . \n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \n<" + this.SEARCH_CONFIG_URI + "> rdf:type :ProhibitedFromSearch ;\n" + "           <" + DisplayVocabulary.EXCLUDE_CLASS.getURI() + "> vivo:Class2, vivo:Class3, vivo:Class4, <" + this.TEST_CLASS + "> .\n";

    @Test
    public void testBuildingProhibited() {
        Model r = ModelFactory.createDefaultModel().read((Reader)new StringReader(this.n3), null, "N3");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.add(r.listStatements());
        Assert.assertTrue((m.size() > 4L ? 1 : 0) != 0);
        ProhibitedFromSearch pfs = new ProhibitedFromSearch(this.SEARCH_CONFIG_URI, m);
        Assert.assertNotNull((Object)pfs.prohibitedClasses);
        Assert.assertTrue((pfs.prohibitedClasses.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)pfs.isClassProhibitedFromSearch(this.TEST_CLASS));
        Assert.assertTrue((!pfs.isClassProhibitedFromSearch("http://someOtherClass.com/test") ? 1 : 0) != 0);
    }

    @Test
    public void testNotFound() {
        Model r = ModelFactory.createDefaultModel().read((Reader)new StringReader(this.n3), null, "N3");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.add(r.listStatements());
        Assert.assertTrue((m.size() > 4L ? 1 : 0) != 0);
        ProhibitedFromSearch pfs = new ProhibitedFromSearch("http://NotFound.com/inModel", m);
        Assert.assertNotNull((Object)pfs.prohibitedClasses);
        Assert.assertTrue((pfs.prohibitedClasses.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((!pfs.isClassProhibitedFromSearch(this.TEST_CLASS) ? 1 : 0) != 0);
        Assert.assertTrue((!pfs.isClassProhibitedFromSearch("http://someOtherClass.com/test") ? 1 : 0) != 0);
    }

    @Test
    public void testListener() {
        Model r = ModelFactory.createDefaultModel().read((Reader)new StringReader(this.n3), null, "N3");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.add(r.listStatements());
        Assert.assertTrue((m.size() > 4L ? 1 : 0) != 0);
        ProhibitedFromSearch pfs = new ProhibitedFromSearch(this.SEARCH_CONFIG_URI, m);
        Assert.assertTrue((pfs.prohibitedClasses.size() == 4 ? 1 : 0) != 0);
        Resource bougsClass3 = ResourceFactory.createResource((String)"http://example.com/bougsClass3");
        Resource searchConfig = ResourceFactory.createResource((String)this.SEARCH_CONFIG_URI);
        m.add(searchConfig, (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)bougsClass3);
        Assert.assertEquals((long)5L, (long)pfs.prohibitedClasses.size());
        m.remove(searchConfig, (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)bougsClass3);
        Assert.assertEquals((long)4L, (long)pfs.prohibitedClasses.size());
        Resource bougsClass4 = ResourceFactory.createResource((String)"http://vivoweb.org/ontology/test/bogus#Class4");
        m.remove(searchConfig, (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)bougsClass4);
        Assert.assertEquals((long)3L, (long)pfs.prohibitedClasses.size());
    }

    @Test
    public void testListenerAbnormal() {
        Model r = ModelFactory.createDefaultModel().read((Reader)new StringReader(this.n3), null, "N3");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.add(r.listStatements());
        Assert.assertTrue((m.size() > 4L ? 1 : 0) != 0);
        ProhibitedFromSearch pfs = new ProhibitedFromSearch(this.SEARCH_CONFIG_URI, m);
        Assert.assertTrue((pfs.prohibitedClasses.size() == 4 ? 1 : 0) != 0);
        int originalSize = pfs.prohibitedClasses.size();
        Literal bogusLiteral = ResourceFactory.createPlainLiteral((String)"some bogus literal");
        Resource searchConfig = ResourceFactory.createResource((String)this.SEARCH_CONFIG_URI);
        m.add(searchConfig, (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)bogusLiteral);
        Assert.assertEquals((long)originalSize, (long)pfs.prohibitedClasses.size());
        m.remove(searchConfig, (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)bogusLiteral);
        Assert.assertEquals((long)originalSize, (long)pfs.prohibitedClasses.size());
        Resource anonRes = ResourceFactory.createResource();
        m.remove(searchConfig, (Property)DisplayVocabulary.EXCLUDE_CLASS, (RDFNode)anonRes);
        Assert.assertEquals((long)originalSize, (long)pfs.prohibitedClasses.size());
    }

    @Test
    public void testPrimaryIndex() {
        String primaryIndexN3 = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex><http://vitro.mannlib.cornell.edu/ontologies/display/1.1#excludeClass><http://vivoweb.org/ontology/core#NonAcademic> . ";
        Model r = ModelFactory.createDefaultModel().read((Reader)new StringReader(primaryIndexN3), null, "N3");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.add(r.listStatements());
        Assert.assertTrue((m.size() == 1L ? 1 : 0) != 0);
        ProhibitedFromSearch pfs = new ProhibitedFromSearch("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#SearchIndex", m);
        Assert.assertNotNull((Object)pfs.prohibitedClasses);
        Assert.assertEquals((long)1L, (long)pfs.prohibitedClasses.size());
        Assert.assertTrue((boolean)pfs.isClassProhibitedFromSearch("http://vivoweb.org/ontology/core#NonAcademic"));
        Assert.assertTrue((!pfs.isClassProhibitedFromSearch("http://someOtherClass.com/test") ? 1 : 0) != 0);
    }
}

