/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.AdditionsAndRetractions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.NewURIMaker;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.ProcessRdfForm;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ProcessRdfFormTest
extends AbstractTestClass {
    String NEWURI_STRING = "http://newURI/n";

    @Test
    public void basicNewStatementTest() throws Exception {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setEditKey("mockEditKey");
        config.setN3Required(Arrays.asList("?test1 ?test2 ?test3 ."));
        config.setUrisOnform(Arrays.asList("test1", "test2", "test3"));
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("test1", new String[]{"http://test.com/uri1"});
        values.put("test2", new String[]{"http://test.com/uri2"});
        values.put("test3", new String[]{"http://test.com/uri3"});
        values.put("editKey", new String[]{"mockEditKey"});
        MultiValueEditSubmission submission = new MultiValueEditSubmission(values, config);
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        List req = config.getN3Required();
        List opt = config.getN3Optional();
        processor.subInValuesToN3(config, submission, req, opt, null, null);
        Assert.assertNotNull((Object)req);
        Assert.assertTrue((req.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull(req.get(0));
        Assert.assertEquals((Object)"<http://test.com/uri1> <http://test.com/uri2> <http://test.com/uri3> .", req.get(0));
        AdditionsAndRetractions changes = processor.process(config, submission, null);
        Assert.assertNotNull((Object)changes);
        Assert.assertNotNull((Object)changes.getAdditions());
        Assert.assertNotNull((Object)changes.getRetractions());
        Assert.assertTrue((changes.getAdditions().size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((changes.getRetractions().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)changes.getAdditions().contains(ResourceFactory.createResource((String)"http://test.com/uri1"), ResourceFactory.createProperty((String)"http://test.com/uri2"), (RDFNode)ResourceFactory.createResource((String)"http://test.com/uri3")));
    }

    @Test
    public void basicEditStatement() throws Exception {
        String testXURI = "http://test.com/uriX";
        String testYURI = "http://test.com/uriY";
        String testZURIOrginal = "http://test.com/uriZ";
        String testZURIChanged = "http://test.com/uriZChanged";
        Model model = ModelFactory.createDefaultModel();
        model.add(model.createResource(testXURI), model.createProperty(testYURI), (RDFNode)model.createResource(testZURIOrginal));
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setEditKey("mockEditKey");
        config.setUrisOnform(Arrays.asList("testX", "testY", "testZ"));
        config.setN3Required(Arrays.asList("?testX ?testY ?testZ ."));
        config.setVarNameForSubject("testX");
        config.setSubjectUri(testXURI);
        config.setPredicateUri(testYURI);
        config.setVarNameForPredicate("testY");
        config.setObject(testZURIOrginal);
        config.setVarNameForObject("testZ");
        config.prepareForObjPropUpdate(model);
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("testZ", new String[]{testZURIChanged});
        values.put("editKey", new String[]{"mockEditKey"});
        MultiValueEditSubmission submission = new MultiValueEditSubmission(values, config);
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        AdditionsAndRetractions changes = processor.process(config, submission, null);
        Assert.assertNotNull((Object)changes);
        Assert.assertNotNull((Object)changes.getAdditions());
        Assert.assertNotNull((Object)changes.getRetractions());
        Assert.assertTrue((changes.getAdditions().size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((changes.getRetractions().size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)changes.getAdditions().contains(ResourceFactory.createResource((String)testXURI), ResourceFactory.createProperty((String)testYURI), (RDFNode)ResourceFactory.createResource((String)testZURIChanged)));
        Assert.assertTrue((boolean)changes.getRetractions().contains(ResourceFactory.createResource((String)testXURI), ResourceFactory.createProperty((String)testYURI), (RDFNode)ResourceFactory.createResource((String)testZURIOrginal)));
    }

    @Test
    public void substituteInSubPredObjURIsTest() {
        String testXURI = "http://test.com/uriX";
        String testYURI = "http://test.com/uriY";
        String testZURI = "http://test.com/uriZ";
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setVarNameForSubject("testX");
        config.setSubjectUri(testXURI);
        config.setPredicateUri(testYURI);
        config.setVarNameForPredicate("testY");
        config.setObject(testZURI);
        config.setVarNameForObject("testZ");
        List<String> a = Arrays.asList("a.0 ?testX ?testY ?testZ.", "a.1 ?testX ?testY ?testZ.");
        List<String> b = Arrays.asList("b.0 ?testX ?testY ?testZ.", "b.1 ?testX ?testY ?testZ.");
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        processor.substituteInSubPredObjURIs(config, new List[]{a, b});
        Assert.assertEquals((Object)("a.0 <" + testXURI + "> <" + testYURI + "> <" + testZURI + ">."), (Object)a.get(0));
        Assert.assertEquals((Object)("a.1 <" + testXURI + "> <" + testYURI + "> <" + testZURI + ">."), (Object)a.get(1));
        Assert.assertEquals((Object)("b.0 <" + testXURI + "> <" + testYURI + "> <" + testZURI + ">."), (Object)b.get(0));
        Assert.assertEquals((Object)("b.1 <" + testXURI + "> <" + testYURI + "> <" + testZURI + ">."), (Object)b.get(1));
    }

    @Test
    public void unicodeTest() throws Exception {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setEditKey("mockEditKey");
        config.setN3Required(Arrays.asList("?test1 ?test2 ?test3 ."));
        config.setUrisOnform(Arrays.asList("test1", "test2", "test3"));
        String test1 = "http://test.com/uriWithUnicode\u01ba";
        String test2 = "http://test.com/latin-1-\u00d9\u00e5\u00e0\u00de\u00f1\u00f6\u00ff";
        String test3 = "http://test.com/moreUnicode-\u1f0e\u1f18\u1f64";
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("test1", new String[]{test1});
        values.put("test2", new String[]{test2});
        values.put("test3", new String[]{test3});
        values.put("editKey", new String[]{"mockEditKey"});
        MultiValueEditSubmission submission = new MultiValueEditSubmission(values, config);
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        List req = config.getN3Required();
        List opt = config.getN3Optional();
        processor.subInValuesToN3(config, submission, req, opt, null, null);
        Assert.assertNotNull((Object)req);
        Assert.assertTrue((req.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull(req.get(0));
        Assert.assertEquals((Object)("<" + test1 + "> <" + test2 + "> <" + test3 + "> ."), req.get(0));
        AdditionsAndRetractions changes = processor.process(config, submission, null);
        Assert.assertNotNull((Object)changes);
        Assert.assertNotNull((Object)changes.getAdditions());
        Assert.assertNotNull((Object)changes.getRetractions());
        Assert.assertTrue((changes.getAdditions().size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((changes.getRetractions().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)changes.getAdditions().contains(ResourceFactory.createResource((String)test1), ResourceFactory.createProperty((String)test2), (RDFNode)ResourceFactory.createResource((String)test3)));
    }

    @Test
    public void basicNewResourceTest() throws Exception {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setEditKey("mockEditKey");
        config.setN3Required(Arrays.asList("?newRes ?test2 ?test3 ."));
        config.setUrisOnform(Arrays.asList("test2", "test3"));
        config.addNewResource("newRes", null);
        config.setEntityToReturnTo("?newRes");
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("test2", new String[]{"http://test.com/uri2"});
        values.put("test3", new String[]{"http://test.com/uri3"});
        values.put("editKey", new String[]{"mockEditKey"});
        MultiValueEditSubmission submission = new MultiValueEditSubmission(values, config);
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        List req = config.getN3Required();
        List opt = config.getN3Optional();
        processor.subInValuesToN3(config, submission, req, opt, null, null);
        Assert.assertNotNull((Object)req);
        Assert.assertTrue((req.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull(req.get(0));
        Assert.assertEquals((Object)("<" + this.NEWURI_STRING + "0> <http://test.com/uri2> <http://test.com/uri3> ."), req.get(0));
        Assert.assertEquals((Object)("<" + this.NEWURI_STRING + "0>"), (Object)submission.getEntityToReturnTo());
        AdditionsAndRetractions changes = processor.process(config, submission, null);
        Assert.assertNotNull((Object)changes);
        Assert.assertNotNull((Object)changes.getAdditions());
        Assert.assertNotNull((Object)changes.getRetractions());
        Assert.assertTrue((changes.getAdditions().size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((changes.getRetractions().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)changes.getAdditions().contains(ResourceFactory.createResource((String)(this.NEWURI_STRING + "0")), ResourceFactory.createProperty((String)"http://test.com/uri2"), (RDFNode)ResourceFactory.createResource((String)"http://test.com/uri3")));
    }

    @Test
    public void forcedNewResourceTest() throws Exception {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setEditKey("mockEditKey");
        config.setN3Required(Arrays.asList("?newRes ?test2 ?test3 ."));
        config.setUrisOnform(Arrays.asList("newRes", "test2", "test3"));
        config.addUrisInScope("newRes", Arrays.asList("<http://test.com/uri1>"));
        config.addNewResource("newRes", null);
        config.setEntityToReturnTo("?newRes");
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("newRes", new String[]{">NEW URI REQUIRED<"});
        values.put("test2", new String[]{"http://test.com/uri2"});
        values.put("test3", new String[]{"http://test.com/uri3"});
        values.put("editKey", new String[]{"mockEditKey"});
        MultiValueEditSubmission submission = new MultiValueEditSubmission(values, config);
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        List req = config.getN3Required();
        List opt = config.getN3Optional();
        processor.subInValuesToN3(config, submission, req, opt, null, null);
        Assert.assertNotNull((Object)req);
        Assert.assertTrue((req.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull(req.get(0));
        Assert.assertEquals((Object)("<" + this.NEWURI_STRING + "0> <http://test.com/uri2> <http://test.com/uri3> ."), req.get(0));
        Assert.assertEquals((Object)("<" + this.NEWURI_STRING + "0>"), (Object)submission.getEntityToReturnTo());
        AdditionsAndRetractions changes = processor.process(config, submission, null);
        Assert.assertNotNull((Object)changes);
        Assert.assertNotNull((Object)changes.getAdditions());
        Assert.assertNotNull((Object)changes.getRetractions());
        Assert.assertTrue((changes.getAdditions().size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((changes.getRetractions().size() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)changes.getAdditions().contains(ResourceFactory.createResource((String)(this.NEWURI_STRING + "0")), ResourceFactory.createProperty((String)"http://test.com/uri2"), (RDFNode)ResourceFactory.createResource((String)"http://test.com/uri3")));
    }

    @Test
    public void basicEditReplaceStatement() throws Exception {
        String testXURI = "http://test.com/uriX";
        String testYURI = "http://test.com/uriY";
        String testZURIOrginal = "http://test.com/uriZ";
        String testZURIChanged = "http://test.com/uriZChanged";
        String zType = "http://test.com/TestType";
        String rdfsLabel = "http://www.w3.org/2000/01/rdf-schema#label";
        Model model = ModelFactory.createDefaultModel();
        model.add(model.createResource(testXURI), model.createProperty(testYURI), (RDFNode)model.createResource(testZURIOrginal));
        model.add(model.createResource(testZURIOrginal), RDF.type, (RDFNode)model.createResource(zType));
        model.add(model.createResource(testZURIOrginal), RDFS.label, (RDFNode)model.createLiteral("Z Original Label"));
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setEditKey("mockEditKey");
        config.setLiteralsOnForm(Arrays.asList("zLabel"));
        config.setUrisOnform(Arrays.asList("testX", "testY", "testZ"));
        config.setN3Required(Arrays.asList("?testX ?testY ?testZ ."));
        config.setN3Optional(Arrays.asList("?testZ a <" + zType + "> . \n" + "?testZ <" + rdfsLabel + "> ?zLabel ."));
        config.addLiteralInScope("zLabel", new Literal[]{model.createLiteral("Z Original Label")});
        config.setVarNameForSubject("testX");
        config.setSubjectUri(testXURI);
        config.setPredicateUri(testYURI);
        config.setVarNameForPredicate("testY");
        config.setObject(testZURIOrginal);
        config.setVarNameForObject("testZ");
        config.addField(new FieldVTwo().setName("zLabel"));
        config.prepareForObjPropUpdate(model);
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        values.put("testZ", new String[]{testZURIChanged});
        values.put("zLabel", new String[]{"New Z Label"});
        values.put("editKey", new String[]{"mockEditKey"});
        MultiValueEditSubmission submission = new MultiValueEditSubmission(values, config);
        ProcessRdfForm processor = new ProcessRdfForm(config, this.getMockNewURIMaker());
        AdditionsAndRetractions changes = processor.process(config, submission, null);
        Assert.assertNotNull((Object)changes);
        Assert.assertNotNull((Object)changes.getAdditions());
        Assert.assertNotNull((Object)changes.getRetractions());
        Assert.assertTrue((boolean)changes.getAdditions().contains(ResourceFactory.createResource((String)testXURI), ResourceFactory.createProperty((String)testYURI), (RDFNode)ResourceFactory.createResource((String)testZURIChanged)));
        Assert.assertTrue((boolean)changes.getRetractions().contains(ResourceFactory.createResource((String)testXURI), ResourceFactory.createProperty((String)testYURI), (RDFNode)ResourceFactory.createResource((String)testZURIOrginal)));
    }

    public NewURIMaker getMockNewURIMaker() {
        return new NewURIMaker(){
            int count = 0;

            public String getUnusedNewURI(String prefixURI) throws InsertException {
                if (prefixURI != null) {
                    return prefixURI + this.count;
                }
                return ProcessRdfFormTest.this.NEWURI_STRING + this.count;
            }
        };
    }
}

